//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/applicationinsights/armapplicationinsights"
	"net/http"
	"net/url"
	"regexp"
)

// ProactiveDetectionConfigurationsServer is a fake server for instances of the armapplicationinsights.ProactiveDetectionConfigurationsClient type.
type ProactiveDetectionConfigurationsServer struct {
	// Get is the fake for method ProactiveDetectionConfigurationsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceName string, configurationID string, options *armapplicationinsights.ProactiveDetectionConfigurationsClientGetOptions) (resp azfake.Responder[armapplicationinsights.ProactiveDetectionConfigurationsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method ProactiveDetectionConfigurationsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, resourceName string, options *armapplicationinsights.ProactiveDetectionConfigurationsClientListOptions) (resp azfake.Responder[armapplicationinsights.ProactiveDetectionConfigurationsClientListResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method ProactiveDetectionConfigurationsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, resourceName string, configurationID string, proactiveDetectionProperties armapplicationinsights.ComponentProactiveDetectionConfiguration, options *armapplicationinsights.ProactiveDetectionConfigurationsClientUpdateOptions) (resp azfake.Responder[armapplicationinsights.ProactiveDetectionConfigurationsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewProactiveDetectionConfigurationsServerTransport creates a new instance of ProactiveDetectionConfigurationsServerTransport with the provided implementation.
// The returned ProactiveDetectionConfigurationsServerTransport instance is connected to an instance of armapplicationinsights.ProactiveDetectionConfigurationsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewProactiveDetectionConfigurationsServerTransport(srv *ProactiveDetectionConfigurationsServer) *ProactiveDetectionConfigurationsServerTransport {
	return &ProactiveDetectionConfigurationsServerTransport{srv: srv}
}

// ProactiveDetectionConfigurationsServerTransport connects instances of armapplicationinsights.ProactiveDetectionConfigurationsClient to instances of ProactiveDetectionConfigurationsServer.
// Don't use this type directly, use NewProactiveDetectionConfigurationsServerTransport instead.
type ProactiveDetectionConfigurationsServerTransport struct {
	srv *ProactiveDetectionConfigurationsServer
}

// Do implements the policy.Transporter interface for ProactiveDetectionConfigurationsServerTransport.
func (p *ProactiveDetectionConfigurationsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ProactiveDetectionConfigurationsClient.Get":
		resp, err = p.dispatchGet(req)
	case "ProactiveDetectionConfigurationsClient.List":
		resp, err = p.dispatchList(req)
	case "ProactiveDetectionConfigurationsClient.Update":
		resp, err = p.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (p *ProactiveDetectionConfigurationsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if p.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/components/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ProactiveDetectionConfigs/(?P<ConfigurationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	configurationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ConfigurationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Get(req.Context(), resourceGroupNameParam, resourceNameParam, configurationIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ComponentProactiveDetectionConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProactiveDetectionConfigurationsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if p.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/components/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ProactiveDetectionConfigs`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.List(req.Context(), resourceGroupNameParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ComponentProactiveDetectionConfigurationArray, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (p *ProactiveDetectionConfigurationsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if p.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Insights/components/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ProactiveDetectionConfigs/(?P<ConfigurationId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armapplicationinsights.ComponentProactiveDetectionConfiguration](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	configurationIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("ConfigurationId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := p.srv.Update(req.Context(), resourceGroupNameParam, resourceNameParam, configurationIDParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ComponentProactiveDetectionConfiguration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
