//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azmetrics

import "time"

// LocalizableString - The localizable string class.
type LocalizableString struct {
	// REQUIRED; The invariant value.
	Value *string

	// The display name.
	LocalizedValue *string
}

// MetadataValue - Represents a metric metadata value.
type MetadataValue struct {
	// The name of the metadata.
	Name *LocalizableString

	// The value of the metadata.
	Value *string
}

// Metric - The result data of a query.
type Metric struct {
	// REQUIRED; The metric Id.
	ID *string

	// REQUIRED; The name and the display name of the metric, i.e. it is localizable string.
	Name *LocalizableString

	// REQUIRED; The time series returned when a data query is performed.
	TimeSeries []TimeSeriesElement

	// REQUIRED; The resource type of the metric resource.
	Type *string

	// REQUIRED; The unit of the metric.
	Unit *MetricUnit

	// Detailed description of this metric.
	DisplayDescription *string

	// 'Success' or the error details on query failures for this metric.
	ErrorCode *string

	// Error message encountered querying this specific metric.
	ErrorMessage *string
}

// MetricResults - The metrics result for a resource.
type MetricResults struct {
	// The collection of metric data responses per resource, per metric.
	Values []MetricData
}

// MetricData - Metric data values.
type MetricData struct {
	// REQUIRED; The end time, in datetime format, for which the data was retrieved.
	EndTime *string

	// REQUIRED; The start time, in datetime format, for which the data was retrieved.
	StartTime *string

	// REQUIRED; The value of the collection.
	Values []Metric

	// The interval (window size) for which the metric data was returned in ISO 8601 duration format with a special case for 'FULL'
	// value that returns single datapoint for entire time span requested (
	// Examples: PT15M, PT1H, P1D, FULL). This may be adjusted and different from what was originally requested if AutoAdjustTimegrain=true
	// is specified.
	Interval *string

	// The namespace of the metrics been queried
	Namespace *string

	// The resource that has been queried for metrics.
	ResourceID *string

	// The region of the resource been queried for metrics.
	ResourceRegion *string
}

// MetricValue - Represents a metric value.
type MetricValue struct {
	// REQUIRED; The timestamp for the metric value in ISO 8601 format.
	TimeStamp *time.Time

	// The average value in the time range.
	Average *float64

	// The number of samples in the time range. Can be used to determine the number of values that contributed to the average
	// value.
	Count *float64

	// The greatest value in the time range.
	Maximum *float64

	// The least value in the time range.
	Minimum *float64

	// The sum of all of the values in the time range.
	Total *float64
}

// ResourceIDList - The comma separated list of resource IDs to query metrics for.
type ResourceIDList struct {
	// The list of resource IDs to query metrics for.
	ResourceIDs []string
}

// TimeSeriesElement - A time series result type. The discriminator value is always TimeSeries in this case.
type TimeSeriesElement struct {
	// An array of data points representing the metric values. This is only returned if a result type of data is specified.
	Data []MetricValue

	// The metadata values returned if $filter was specified in the call.
	MetadataValues []MetadataValue
}
