## Go

``` yaml
title: Logs Query Client
clear-output-folder: false
go: true
input-file: https://github.com/Azure/azure-rest-api-specs/blob/0b64ca7cbe3af8cd13228dfb783a16b8272b8be2/specification/operationalinsights/data-plane/Microsoft.OperationalInsights/stable/2022-10-27/OperationalInsights.json
license-header: MICROSOFT_MIT_NO_VERSION
module: github.com/Azure/azure-sdk-for-go/sdk/monitor/query/azlogs
openapi-type: "data-plane"
output-folder: ../azlogs
security: "AADToken"
use: "@autorest/go@4.0.0-preview.61"
inject-spans: true
version: "^3.0.0"
slice-elements-byval: true
rawjson-as-bytes: true

directive:
  # delete extra endpoints
  - from: swagger-document
    where: $["paths"]
    transform: >
        delete $["/workspaces/{workspaceId}/metadata"];
  - from: swagger-document
    where: $["x-ms-paths"]
    transform: >
        delete $["/{resourceId}/query?disambiguation_dummy"];
  - from: swagger-document
    where: $["paths"]
    transform: >
        delete $["/$batch"];

  # delete extra operations
  - remove-operation: Query_Get
  - remove-operation: Query_ResourceGet
  - remove-operation: Query_Batch

  # delete metadata and batch models
  - remove-model: metadataResults
  - remove-model: metadataCategory
  - remove-model: metadataSolution
  - remove-model: metadataResourceType
  - remove-model: metadataTable
  - remove-model: metadataFunction
  - remove-model: metadataQuery
  - remove-model: metadataApplication
  - remove-model: metadataWorkspace
  - remove-model: metadataResource
  - remove-model: metadataPermissions
  - remove-model: batchRequest
  - remove-model: batchQueryRequest
  - remove-model: batchResponse
  - remove-model: batchQueryResponse
  - remove-model: batchQueryResults

 # rename log operations to generate into a separate logs client
  - rename-operation:
      from: Query_Execute
      to: Logs_QueryWorkspace
  - rename-operation:
      from: Query_ResourceExecute
      to: Logs_QueryResource

  # rename Body.Workspaces to Body.AdditionalWorkspaces
  - from: swagger-document
    where: $.definitions.queryBody.properties.workspaces
    transform: $["x-ms-client-name"] = "AdditionalWorkspaces"
  
  # rename Render to Visualization
  - from: swagger-document
    where: $.definitions.queryResults.properties.render
    transform: $["x-ms-client-name"] = "Visualization"

  # rename LogsColumnType to ColumnType
  - from: swagger-document
    where: $.definitions.logsColumnType.x-ms-enum
    transform: $["name"] = "ColumnType"
  
  # rename Prefer to Options
  - from: swagger-document
    where: $.parameters.PreferHeaderParameter
    transform: $["x-ms-client-name"] = "Options"
  - from: options.go
    where: $
    transform: return $.replace(/Options \*string/g, "Options *QueryOptions");
  - from: client.go
    where: $
    transform: return $.replace(/\*options\.Options/g, "options.Options.preferHeader()");

  # delete unused error models
  - from: models.go
    where: $
    transform: return $.replace(/(?:\/\/.*\s)+type (?:ErrorResponse|ErrorResponseAutoGenerated|ErrorInfo|ErrorDetail).+\{(?:\s.+\s)+\}\s/g, "");
  - from: models_serde.go
    where: $
    transform: return $.replace(/(?:\/\/.*\s)+func \(\w \*?(?:ErrorResponse|ErrorResponseAutoGenerated|ErrorInfo|ErrorDetail)\).*\{\s(?:.+\s)+\}\s/g, "");

  # add host as field in client struct
  - from: client.go
    where: $
    transform: return $.replace(/host/g, "client.host");
  - from: client.go
    where: $
    transform: return $.replace(/internal \*azcore.Client/g, "host string\n internal *azcore.Client");
  - from: constants.go
    where: $
    transform: return $.replace(/const host = "(.*?)"/, "");

  # change Table.Rows from type [][]byte to type []Row
  - from: models.go
    where: $
    transform: return $.replace(/Rows \[\]\[\]\[\]byte/g, "Rows []Row");

  # change type of timespan from *string to *TimeInterval
  - from: 
        - models.go
        - options.go
    where: $
    transform: return $.replace(/Timespan \*string/g, "Timespan *TimeInterval");
  
  # delete client name prefix from method options and response types
  - from:
      - client.go
      - options.go
      - response_types.go
    where: $
    transform: return $.replace(/Client(\w+)((?:Options|Response))/g, "$1$2");
```