//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package aznamespaces

import "github.com/Azure/azure-sdk-for-go/sdk/azcore/messaging"

// acknowledgeOptions - Array of lock tokens for the corresponding received Cloud Events to be acknowledged.
type acknowledgeOptions struct {
	// REQUIRED; Array of lock tokens.
	LockTokens []string
}

// AcknowledgeResult - The result of the Acknowledge operation.
type AcknowledgeResult struct {
	// REQUIRED; Array of FailedLockToken for failed cloud events. Each FailedLockToken includes the lock token along with the
	// related error information (namely, the error code and description).
	FailedLockTokens []FailedLockToken

	// REQUIRED; Array of lock tokens for the successfully acknowledged cloud events.
	SucceededLockTokens []string
}

// BrokerProperties - Properties of the Event Broker operation.
type BrokerProperties struct {
	// REQUIRED; The attempt count for delivering the event.
	DeliveryCount *int32

	// REQUIRED; The token of the lock on the event.
	LockToken *string
}

// Error - The error object.
type Error struct {
	// REQUIRED; One of a server-defined set of error codes.
	Code *string

	// REQUIRED; A human-readable representation of the error.
	message *string
}

// FailedLockToken - Failed LockToken information.
type FailedLockToken struct {
	// REQUIRED; Error information of the failed operation result for the lock token in the request.
	Error *Error

	// REQUIRED; The lock token of an entry in the request.
	LockToken *string
}

// ReceiveDetails - Receive operation details per Cloud Event.
type ReceiveDetails struct {
	// REQUIRED; The Event Broker details.
	BrokerProperties *BrokerProperties

	// REQUIRED; Cloud Event details.
	Event messaging.CloudEvent
}

// ReceiveResult - Details of the Receive operation response.
type ReceiveResult struct {
	// REQUIRED; Array of receive responses, one per cloud event.
	Value []ReceiveDetails
}

// rejectOptions - Array of lock tokens for the corresponding received Cloud Events to be rejected.
type rejectOptions struct {
	// REQUIRED; Array of lock tokens.
	LockTokens []string
}

// RejectResult - The result of the Reject operation.
type RejectResult struct {
	// REQUIRED; Array of FailedLockToken for failed cloud events. Each FailedLockToken includes the lock token along with the
	// related error information (namely, the error code and description).
	FailedLockTokens []FailedLockToken

	// REQUIRED; Array of lock tokens for the successfully rejected cloud events.
	SucceededLockTokens []string
}

// releaseOptions - Array of lock tokens for the corresponding received Cloud Events to be released.
type releaseOptions struct {
	// REQUIRED; Array of lock tokens.
	LockTokens []string
}

// ReleaseResult - The result of the Release operation.
type ReleaseResult struct {
	// REQUIRED; Array of FailedLockToken for failed cloud events. Each FailedLockToken includes the lock token along with the
	// related error information (namely, the error code and description).
	FailedLockTokens []FailedLockToken

	// REQUIRED; Array of lock tokens for the successfully released cloud events.
	SucceededLockTokens []string
}

// RenewCloudEventLocksResult - The result of the RenewLock operation.
type RenewCloudEventLocksResult struct {
	// REQUIRED; Array of FailedLockToken for failed cloud events. Each FailedLockToken includes the lock token along with the
	// related error information (namely, the error code and description).
	FailedLockTokens []FailedLockToken

	// REQUIRED; Array of lock tokens for the successfully renewed locks.
	SucceededLockTokens []string
}

// renewLockOptions - Array of lock tokens for the corresponding received Cloud Events to be renewed.
type renewLockOptions struct {
	// REQUIRED; Array of lock tokens.
	LockTokens []string
}
