//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armkeyvault

import "time"

// AccessPolicyEntry - An identity that have access to the key vault. All identities in the array must use the same tenant
// ID as the key vault's tenant ID.
type AccessPolicyEntry struct {
	// REQUIRED; The object ID of a user, service principal or security group in the Azure Active Directory tenant for the vault.
	// The object ID must be unique for the list of access policies.
	ObjectID *string `json:"objectId,omitempty"`

	// REQUIRED; Permissions the identity has for keys, secrets and certificates.
	Permissions *Permissions `json:"permissions,omitempty"`

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`

	// Application ID of the client making request on behalf of a principal
	ApplicationID *string `json:"applicationId,omitempty"`
}

// Attributes - The object attributes managed by the KeyVault service.
type Attributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// CheckNameAvailabilityResult - The CheckNameAvailability operation response.
type CheckNameAvailabilityResult struct {
	// READ-ONLY; An error message explaining the Reason value in more detail.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; A boolean value that indicates whether the name is available for you to use. If true, the name is available.
	// If false, the name has already been taken or is invalid and cannot be used.
	NameAvailable *bool `json:"nameAvailable,omitempty" azure:"ro"`

	// READ-ONLY; The reason that a vault name could not be used. The Reason element is only returned if NameAvailable is false.
	Reason *Reason `json:"reason,omitempty" azure:"ro"`
}

// DeletedVault - Deleted vault information with extended details.
type DeletedVault struct {
	// Properties of the vault
	Properties *DeletedVaultProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource ID for the deleted key vault.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the key vault.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the key vault.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DeletedVaultListResult - List of vaults
type DeletedVaultListResult struct {
	// The URL to get the next set of deleted vaults.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of deleted vaults.
	Value []*DeletedVault `json:"value,omitempty"`
}

// DeletedVaultProperties - Properties of the deleted vault.
type DeletedVaultProperties struct {
	// READ-ONLY; The deleted date.
	DeletionDate *time.Time `json:"deletionDate,omitempty" azure:"ro"`

	// READ-ONLY; The location of the original vault.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Purge protection status of the original vault.
	PurgeProtectionEnabled *bool `json:"purgeProtectionEnabled,omitempty" azure:"ro"`

	// READ-ONLY; The scheduled purged date.
	ScheduledPurgeDate *time.Time `json:"scheduledPurgeDate,omitempty" azure:"ro"`

	// READ-ONLY; Tags of the original vault.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; The resource id of the original vault.
	VaultID *string `json:"vaultId,omitempty" azure:"ro"`
}

// DimensionProperties - Type of operation: get, read, delete, etc.
type DimensionProperties struct {
	// Display name of dimension.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of dimension.
	Name *string `json:"name,omitempty"`

	// Property to specify whether the dimension should be exported for shoebox.
	ToBeExportedForShoebox *bool `json:"toBeExportedForShoebox,omitempty"`
}

// IPRule - A rule governing the accessibility of a vault from a specific ip address or ip range.
type IPRule struct {
	// REQUIRED; An IPv4 address range in CIDR notation, such as '124.56.78.91' (simple IP address) or '124.56.78.0/24' (all addresses
	// that start with 124.56.78).
	Value *string `json:"value,omitempty"`
}

// LogSpecification - Log specification of operation.
type LogSpecification struct {
	// Blob duration of specification.
	BlobDuration *string `json:"blobDuration,omitempty"`

	// Display name of log specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Name of log specification.
	Name *string `json:"name,omitempty"`
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// The metric aggregation type. Possible values include: 'Average', 'Count', 'Total'.
	AggregationType *string `json:"aggregationType,omitempty"`

	// The dimensions of metric
	Dimensions []*DimensionProperties `json:"dimensions,omitempty"`

	// Display description of Metric specification.
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// Display name of Metric specification.
	DisplayName *string `json:"displayName,omitempty"`

	// Property to specify whether to fill gap with zero.
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// The internal metric name.
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// The metric lock aggregation type.
	LockAggregationType *string `json:"lockAggregationType,omitempty"`

	// Name of metric specification.
	Name *string `json:"name,omitempty"`

	// The supported aggregation types for the metrics.
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// The metric unit. Possible values include: 'Bytes', 'Count', 'Milliseconds'.
	Unit *string `json:"unit,omitempty"`
}

// NetworkRuleSet - A set of rules governing the network accessibility of a vault.
type NetworkRuleSet struct {
	// Tells what traffic can bypass network rules. This can be 'AzureServices' or 'None'. If not specified the default is 'AzureServices'.
	Bypass *NetworkRuleBypassOptions `json:"bypass,omitempty"`

	// The default action when no rule from ipRules and from virtualNetworkRules match. This is only used after the bypass property
	// has been evaluated.
	DefaultAction *NetworkRuleAction `json:"defaultAction,omitempty"`

	// The list of IP address rules.
	IPRules []*IPRule `json:"ipRules,omitempty"`

	// The list of virtual network rules.
	VirtualNetworkRules []*VirtualNetworkRule `json:"virtualNetworkRules,omitempty"`
}

// Operation - Key Vault REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Property to specify whether the action is a data action.
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`

	// Properties of operation, include metric specifications.
	OperationProperties *OperationProperties `json:"properties,omitempty"`

	// The origin of operations.
	Origin *string `json:"origin,omitempty"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Description of operation.
	Description *string `json:"description,omitempty"`

	// Type of operation: get, read, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft Key Vault.
	Provider *string `json:"provider,omitempty"`

	// Resource on which the operation is performed etc.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of the request to list Storage operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	// The URL to get the next set of operations.
	NextLink *string `json:"nextLink,omitempty"`

	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation `json:"value,omitempty"`
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.NewListPager method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// Permissions the identity has for keys, secrets, certificates and storage.
type Permissions struct {
	// Permissions to certificates
	Certificates []*CertificatePermissions `json:"certificates,omitempty"`

	// Permissions to keys
	Keys []*KeyPermissions `json:"keys,omitempty"`

	// Permissions to secrets
	Secrets []*SecretPermissions `json:"secrets,omitempty"`

	// Permissions to storage accounts
	Storage []*StoragePermissions `json:"storage,omitempty"`
}

// PrivateEndpoint - Private endpoint object properties.
type PrivateEndpoint struct {
	// READ-ONLY; Full identifier of the private endpoint resource.
	ID *string `json:"id,omitempty" azure:"ro"`
}

// PrivateEndpointConnection - Private endpoint connection resource.
type PrivateEndpointConnection struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`

	// Resource properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionItem - Private endpoint connection item.
type PrivateEndpointConnectionItem struct {
	// Modified whenever there is a change in the state of private endpoint connection.
	Etag *string `json:"etag,omitempty"`

	// Id of private endpoint connection.
	ID *string `json:"id,omitempty"`

	// Private endpoint connection properties.
	Properties *PrivateEndpointConnectionProperties `json:"properties,omitempty"`
}

// PrivateEndpointConnectionProperties - Properties of the private endpoint connection resource.
type PrivateEndpointConnectionProperties struct {
	// Properties of the private endpoint object.
	PrivateEndpoint *PrivateEndpoint `json:"privateEndpoint,omitempty"`

	// Approval state of the private link connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState `json:"privateLinkServiceConnectionState,omitempty"`

	// READ-ONLY; Provisioning state of the private endpoint connection.
	ProvisioningState *PrivateEndpointConnectionProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// PrivateEndpointConnectionsClientBeginDeleteOptions contains the optional parameters for the PrivateEndpointConnectionsClient.BeginDelete
// method.
type PrivateEndpointConnectionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// PrivateEndpointConnectionsClientGetOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Get
// method.
type PrivateEndpointConnectionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// PrivateEndpointConnectionsClientPutOptions contains the optional parameters for the PrivateEndpointConnectionsClient.Put
// method.
type PrivateEndpointConnectionsClientPutOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkResource - A private link resource
type PrivateLinkResource struct {
	// Resource properties.
	Properties *PrivateLinkResourceProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// PrivateLinkResourceListResult - A list of private link resources
type PrivateLinkResourceListResult struct {
	// Array of private link resources
	Value []*PrivateLinkResource `json:"value,omitempty"`
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string `json:"requiredZoneNames,omitempty"`

	// READ-ONLY; Group identifier of private link resource.
	GroupID *string `json:"groupId,omitempty" azure:"ro"`

	// READ-ONLY; Required member names of private link resource.
	RequiredMembers []*string `json:"requiredMembers,omitempty" azure:"ro"`
}

// PrivateLinkResourcesClientListByVaultOptions contains the optional parameters for the PrivateLinkResourcesClient.ListByVault
// method.
type PrivateLinkResourcesClientListByVaultOptions struct {
	// placeholder for future optional parameters
}

// PrivateLinkServiceConnectionState - An object that represents the approval state of the private link connection.
type PrivateLinkServiceConnectionState struct {
	// A message indicating if changes on the service provider require any updates on the consumer.
	ActionsRequired *string `json:"actionsRequired,omitempty"`

	// The reason for approval or rejection.
	Description *string `json:"description,omitempty"`

	// Indicates whether the connection has been approved, rejected or removed by the key vault owner.
	Status *PrivateEndpointServiceConnectionStatus `json:"status,omitempty"`
}

// Resource - Key Vault resource
type Resource struct {
	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ResourceListResult - List of vault resources.
type ResourceListResult struct {
	// The URL to get the next set of vault resources.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of vault resources.
	Value []*Resource `json:"value,omitempty"`
}

// SKU details
type SKU struct {
	// REQUIRED; SKU family name
	Family *SKUFamily `json:"family,omitempty"`

	// REQUIRED; SKU name to specify whether the key vault is a standard vault or a premium vault.
	Name *SKUName `json:"name,omitempty"`
}

// Secret - Resource information with extended details.
type Secret struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Azure location of the key vault resource.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SecretAttributes - The secret management attributes.
type SecretAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// Expiry date in seconds since 1970-01-01T00:00:00Z.
	Expires *time.Time `json:"exp,omitempty"`

	// Not before date in seconds since 1970-01-01T00:00:00Z.
	NotBefore *time.Time `json:"nbf,omitempty"`

	// READ-ONLY; Creation time in seconds since 1970-01-01T00:00:00Z.
	Created *time.Time `json:"created,omitempty" azure:"ro"`

	// READ-ONLY; Last updated time in seconds since 1970-01-01T00:00:00Z.
	Updated *time.Time `json:"updated,omitempty" azure:"ro"`
}

// SecretCreateOrUpdateParameters - Parameters for creating or updating a secret
type SecretCreateOrUpdateParameters struct {
	// REQUIRED; Properties of the secret
	Properties *SecretProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretListResult - List of secrets
type SecretListResult struct {
	// The URL to get the next set of secrets.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of secrets.
	Value []*Secret `json:"value,omitempty"`
}

// SecretPatchParameters - Parameters for patching a secret
type SecretPatchParameters struct {
	// Properties of the secret
	Properties *SecretPatchProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the secret.
	Tags map[string]*string `json:"tags,omitempty"`
}

// SecretPatchProperties - Properties of the secret
type SecretPatchProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The value of the secret.
	Value *string `json:"value,omitempty"`
}

// SecretProperties - Properties of the secret
type SecretProperties struct {
	// The attributes of the secret.
	Attributes *SecretAttributes `json:"attributes,omitempty"`

	// The content type of the secret.
	ContentType *string `json:"contentType,omitempty"`

	// The value of the secret. NOTE: 'value' will never be returned from the service, as APIs using this model are is intended
	// for internal use in ARM deployments. Users should use the data-plane REST
	// service for interaction with vault secrets.
	Value *string `json:"value,omitempty"`

	// READ-ONLY; The URI to retrieve the current version of the secret.
	SecretURI *string `json:"secretUri,omitempty" azure:"ro"`

	// READ-ONLY; The URI to retrieve the specific version of the secret.
	SecretURIWithVersion *string `json:"secretUriWithVersion,omitempty" azure:"ro"`
}

// SecretsClientCreateOrUpdateOptions contains the optional parameters for the SecretsClient.CreateOrUpdate method.
type SecretsClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientGetOptions contains the optional parameters for the SecretsClient.Get method.
type SecretsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SecretsClientListOptions contains the optional parameters for the SecretsClient.NewListPager method.
type SecretsClientListOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// SecretsClientUpdateOptions contains the optional parameters for the SecretsClient.Update method.
type SecretsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServiceSpecification - One property of operation, include log specifications.
type ServiceSpecification struct {
	// Log specifications of operation.
	LogSpecifications []*LogSpecification `json:"logSpecifications,omitempty"`

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification `json:"metricSpecifications,omitempty"`
}

// Vault - Resource information with extended details.
type Vault struct {
	// REQUIRED; Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`

	// Azure location of the key vault resource.
	Location *string `json:"location,omitempty"`

	// Tags assigned to the key vault resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified identifier of the key vault resource.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the key vault resource.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Resource type of the key vault resource.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultAccessPolicyParameters - Parameters for updating the access policy in a vault
type VaultAccessPolicyParameters struct {
	// REQUIRED; Properties of the access policy
	Properties *VaultAccessPolicyProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the access policy.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The resource type of the access policy.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; The resource name of the access policy.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource name of the access policy.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// VaultAccessPolicyProperties - Properties of the vault access policy
type VaultAccessPolicyProperties struct {
	// REQUIRED; An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same
	// tenant ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`
}

// VaultCheckNameAvailabilityParameters - The parameters used to check the availability of the vault name.
type VaultCheckNameAvailabilityParameters struct {
	// REQUIRED; The vault name.
	Name *string `json:"name,omitempty"`

	// CONSTANT; The type of resource, Microsoft.KeyVault/vaults
	// Field has constant value "Microsoft.KeyVault/vaults", any specified value is ignored.
	Type *string `json:"type,omitempty"`
}

// VaultCreateOrUpdateParameters - Parameters for creating or updating a vault
type VaultCreateOrUpdateParameters struct {
	// REQUIRED; The supported Azure location where the key vault should be created.
	Location *string `json:"location,omitempty"`

	// REQUIRED; Properties of the vault
	Properties *VaultProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VaultListResult - List of vaults
type VaultListResult struct {
	// The URL to get the next set of vaults.
	NextLink *string `json:"nextLink,omitempty"`

	// The list of vaults.
	Value []*Vault `json:"value,omitempty"`
}

// VaultPatchParameters - Parameters for creating or updating a vault
type VaultPatchParameters struct {
	// Properties of the vault
	Properties *VaultPatchProperties `json:"properties,omitempty"`

	// The tags that will be assigned to the key vault.
	Tags map[string]*string `json:"tags,omitempty"`
}

// VaultPatchProperties - Properties of the vault
type VaultPatchProperties struct {
	// An array of 0 to 16 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored. When false, the key vault will use the access policies specified in vault properties, and any
	// policy stored on Azure Resource Manager will be ignored. If null or not
	// specified, the value of this property will not change.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. Once set to true, it cannot
	// be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`

	// A collection of rules governing the accessibility of the vault from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// SKU details
	SKU *SKU `json:"sku,omitempty"`

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`

	// The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`
}

// VaultProperties - Properties of the vault
type VaultProperties struct {
	// REQUIRED; SKU details
	SKU *SKU `json:"sku,omitempty"`

	// REQUIRED; The Azure Active Directory tenant ID that should be used for authenticating requests to the key vault.
	TenantID *string `json:"tenantId,omitempty"`

	// An array of 0 to 1024 identities that have access to the key vault. All identities in the array must use the same tenant
	// ID as the key vault's tenant ID. When createMode is set to recover, access
	// policies are not required. Otherwise, access policies are required.
	AccessPolicies []*AccessPolicyEntry `json:"accessPolicies,omitempty"`

	// The vault's create mode to indicate whether the vault need to be recovered or not.
	CreateMode *CreateMode `json:"createMode,omitempty"`

	// Property specifying whether protection against purge is enabled for this vault. Setting this property to true activates
	// protection against purge for this vault and its content - only the Key Vault
	// service may initiate a hard, irrecoverable deletion. The setting is effective only if soft delete is also enabled. Enabling
	// this functionality is irreversible - that is, the property does not accept
	// false as its value.
	EnablePurgeProtection *bool `json:"enablePurgeProtection,omitempty"`

	// Property that controls how data actions are authorized. When true, the key vault will use Role Based Access Control (RBAC)
	// for authorization of data actions, and the access policies specified in vault
	// properties will be ignored. When false, the key vault will use the access policies specified in vault properties, and any
	// policy stored on Azure Resource Manager will be ignored. If null or not
	// specified, the vault is created with the default value of false. Note that management actions are always authorized with
	// RBAC.
	EnableRbacAuthorization *bool `json:"enableRbacAuthorization,omitempty"`

	// Property to specify whether the 'soft delete' functionality is enabled for this key vault. If it's not set to any value(true
	// or false) when creating new key vault, it will be set to true by default.
	// Once set to true, it cannot be reverted to false.
	EnableSoftDelete *bool `json:"enableSoftDelete,omitempty"`

	// Property to specify whether Azure Virtual Machines are permitted to retrieve certificates stored as secrets from the key
	// vault.
	EnabledForDeployment *bool `json:"enabledForDeployment,omitempty"`

	// Property to specify whether Azure Disk Encryption is permitted to retrieve secrets from the vault and unwrap keys.
	EnabledForDiskEncryption *bool `json:"enabledForDiskEncryption,omitempty"`

	// Property to specify whether Azure Resource Manager is permitted to retrieve secrets from the key vault.
	EnabledForTemplateDeployment *bool `json:"enabledForTemplateDeployment,omitempty"`

	// Rules governing the accessibility of the key vault from specific network locations.
	NetworkACLs *NetworkRuleSet `json:"networkAcls,omitempty"`

	// Provisioning state of the vault.
	ProvisioningState *VaultProvisioningState `json:"provisioningState,omitempty"`

	// softDelete data retention days. It accepts >=7 and <=90.
	SoftDeleteRetentionInDays *int32 `json:"softDeleteRetentionInDays,omitempty"`

	// The URI of the vault for performing operations on keys and secrets. This property is readonly
	VaultURI *string `json:"vaultUri,omitempty"`

	// READ-ONLY; The resource id of HSM Pool.
	HsmPoolResourceID *string `json:"hsmPoolResourceId,omitempty" azure:"ro"`

	// READ-ONLY; List of private endpoint connections associated with the key vault.
	PrivateEndpointConnections []*PrivateEndpointConnectionItem `json:"privateEndpointConnections,omitempty" azure:"ro"`
}

// VaultsClientBeginCreateOrUpdateOptions contains the optional parameters for the VaultsClient.BeginCreateOrUpdate method.
type VaultsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VaultsClientBeginPurgeDeletedOptions contains the optional parameters for the VaultsClient.BeginPurgeDeleted method.
type VaultsClientBeginPurgeDeletedOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// VaultsClientCheckNameAvailabilityOptions contains the optional parameters for the VaultsClient.CheckNameAvailability method.
type VaultsClientCheckNameAvailabilityOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientDeleteOptions contains the optional parameters for the VaultsClient.Delete method.
type VaultsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientGetDeletedOptions contains the optional parameters for the VaultsClient.GetDeleted method.
type VaultsClientGetDeletedOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientGetOptions contains the optional parameters for the VaultsClient.Get method.
type VaultsClientGetOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientListByResourceGroupOptions contains the optional parameters for the VaultsClient.NewListByResourceGroupPager
// method.
type VaultsClientListByResourceGroupOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientListBySubscriptionOptions contains the optional parameters for the VaultsClient.NewListBySubscriptionPager
// method.
type VaultsClientListBySubscriptionOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientListDeletedOptions contains the optional parameters for the VaultsClient.NewListDeletedPager method.
type VaultsClientListDeletedOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientListOptions contains the optional parameters for the VaultsClient.NewListPager method.
type VaultsClientListOptions struct {
	// Maximum number of results to return.
	Top *int32
}

// VaultsClientUpdateAccessPolicyOptions contains the optional parameters for the VaultsClient.UpdateAccessPolicy method.
type VaultsClientUpdateAccessPolicyOptions struct {
	// placeholder for future optional parameters
}

// VaultsClientUpdateOptions contains the optional parameters for the VaultsClient.Update method.
type VaultsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// VirtualNetworkRule - A rule governing the accessibility of a vault from a specific virtual network.
type VirtualNetworkRule struct {
	// REQUIRED; Full resource id of a vnet subnet, such as '/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.Network/virtualNetworks/test-vnet/subnets/subnet1'.
	ID *string `json:"id,omitempty"`

	// Property to specify whether NRP will ignore the check if parent subnet has serviceEndpoints configured.
	IgnoreMissingVnetServiceEndpoint *bool `json:"ignoreMissingVnetServiceEndpoint,omitempty"`
}
