/* sudoku-board.c generated by valac 0.27.2.2-e6bbc, the Vala compiler
 * generated from sudoku-board.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_DIFFICULTY_CATEGORY (difficulty_category_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _coord_free0(var) ((var == NULL) ? NULL : (var = (coord_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_HOUSE (house_get_type ())

#define TYPE_CELL (cell_get_type ())
typedef struct _Cell Cell;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	DIFFICULTY_CATEGORY_UNKNOWN,
	DIFFICULTY_CATEGORY_EASY,
	DIFFICULTY_CATEGORY_MEDIUM,
	DIFFICULTY_CATEGORY_HARD,
	DIFFICULTY_CATEGORY_VERY_HARD
} DifficultyCategory;

struct _SudokuBoardPrivate {
	gboolean* possible_in_row;
	gint possible_in_row_length1;
	gint possible_in_row_length2;
	gboolean* possible_in_col;
	gint possible_in_col_length1;
	gint possible_in_col_length2;
	gboolean* possible_in_block;
	gint possible_in_block_length1;
	gint possible_in_block_length2;
	gint possible_in_block_length3;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gint n_earmarks;
	gdouble _previous_played_time;
	DifficultyCategory _difficulty_category;
	gint _block_rows;
	gint _block_cols;
	gint _rows;
	gint _cols;
	gint _filled;
	gint _fixed;
};

typedef enum  {
	HOUSE_ROW,
	HOUSE_COLUMN,
	HOUSE_BLOCK
} House;

struct _Cell {
	Coord coord;
	gint val;
};


static gpointer sudoku_board_parent_class = NULL;

GType sudoku_board_get_type (void) G_GNUC_CONST;
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
GType difficulty_category_get_type (void) G_GNUC_CONST;
#define SUDOKU_BOARD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_BOARD, SudokuBoardPrivate))
enum  {
	SUDOKU_BOARD_DUMMY_PROPERTY,
	SUDOKU_BOARD_PREVIOUS_PLAYED_TIME,
	SUDOKU_BOARD_DIFFICULTY_CATEGORY,
	SUDOKU_BOARD_BLOCK_ROWS,
	SUDOKU_BOARD_BLOCK_COLS,
	SUDOKU_BOARD_ROWS,
	SUDOKU_BOARD_COLS,
	SUDOKU_BOARD_MAX_VAL,
	SUDOKU_BOARD_BROKEN,
	SUDOKU_BOARD_FILLED,
	SUDOKU_BOARD_FIXED,
	SUDOKU_BOARD_COMPLETE
};
gboolean sudoku_board_is_empty (SudokuBoard* self);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_fixed (SudokuBoard* self);
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
static void sudoku_board_set_cols (SudokuBoard* self, gint value);
static void sudoku_board_set_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_rows (SudokuBoard* self, gint value);
static void sudoku_board_set_block_cols (SudokuBoard* self, gint value);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
gint sudoku_board_get_max_val (SudokuBoard* self);
gint coord_hash (Coord* coord);
gboolean coord_equal (Coord* a, Coord* b);
void coord_init (Coord *self, gint row, gint col);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
gint sudoku_board_get_block_cols (SudokuBoard* self);
static gint* _vala_array_dup1 (gint* self, int length);
static gboolean* _vala_array_dup2 (gboolean* self, int length);
static gboolean* _vala_array_dup3 (gboolean* self, int length);
static gboolean* _vala_array_dup4 (gboolean* self, int length);
static gboolean* _vala_array_dup5 (gboolean* self, int length);
static void sudoku_board_set_filled (SudokuBoard* self, gint value);
static void sudoku_board_set_fixed (SudokuBoard* self, gint value);
static gboolean* _vala_array_dup6 (gboolean* self, int length);
DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self);
void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value);
void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit);
void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column);
gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col);
gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1);
static gint* _vala_array_dup7 (gint* self, int length);
gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1);
void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_get_complete (SudokuBoard* self);
void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val);
GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val);
gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val);
gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val);
gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val);
void sudoku_board_to_initial_state (SudokuBoard* self);
void sudoku_board_print (SudokuBoard* self, gint indent);
void sudoku_board_get_string (SudokuBoard* self);
gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state);
gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2);
static gint* _vala_array_dup8 (gint* self, int length);
GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self);
gboolean sudoku_board_is_finished (SudokuBoard* self);
const gchar* sudoku_saver_get_finishgame_dir (void);
gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col);
gdouble sudoku_board_get_previous_played_time (SudokuBoard* self);
void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value);
gboolean sudoku_board_get_broken (SudokuBoard* self);
static void sudoku_board_finalize (GObject* obj);
static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType house_get_type (void) G_GNUC_CONST;
GType cell_get_type (void) G_GNUC_CONST;
Cell* cell_dup (const Cell* self);
void cell_free (Cell* self);
void cell_init (Cell *self, Coord* coord, gint val);
gint cell_hash (Cell* cell);
gboolean cell_equal (Cell* a, Cell* b);
gchar* difficulty_category_to_string (DifficultyCategory self);
gchar* difficulty_category_to_untranslated_string (DifficultyCategory self);
DifficultyCategory difficulty_category_from_string (const gchar* input);


gboolean sudoku_board_is_empty (SudokuBoard* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 75 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_filled;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_fixed;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ == _tmp2_) {
#line 248 "sudoku-board.c"
		gint _tmp3_ = 0;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = self->priv->n_earmarks;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp3_ == 0;
#line 254 "sudoku-board.c"
	} else {
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 258 "sudoku-board.c"
	}
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 77 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 264 "sudoku-board.c"
}


SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols) {
	SudokuBoard * self = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gboolean* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gboolean* _tmp25_ = NULL;
	GeeHashSet* _tmp68_ = NULL;
	GeeArrayList* _tmp69_ = NULL;
	GeeList* _tmp97_ = NULL;
	GeeList* _tmp98_ = NULL;
	GeeList* _tmp99_ = NULL;
	GeeArrayList* _tmp100_ = NULL;
	GeeList* _tmp128_ = NULL;
	GeeList* _tmp129_ = NULL;
	GeeList* _tmp130_ = NULL;
	GeeHashMap* _tmp131_ = NULL;
	GeeMap* _tmp186_ = NULL;
	GeeMap* _tmp187_ = NULL;
	GeeMap* _tmp188_ = NULL;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self = (SudokuBoard*) g_object_new (object_type, NULL);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = block_rows;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = block_cols;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_cols (self, _tmp0_ * _tmp1_);
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_rows (self, _tmp0_ * _tmp1_);
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = block_rows;
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_block_rows (self, _tmp2_);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = block_cols;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_block_cols (self, _tmp3_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = self->priv->_rows;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->priv->_cols;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_new0 (gint, _tmp4_ * _tmp5_);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = _tmp6_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length1 = _tmp4_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells_length2 = _tmp5_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = self->priv->_rows;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = self->priv->_cols;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = g_new0 (gboolean, _tmp7_ * _tmp8_);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = _tmp9_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length1 = _tmp7_;
#line 100 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed_length2 = _tmp8_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = self->priv->_rows;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->_cols;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = g_new0 (gboolean, _tmp10_ * _tmp11_);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = _tmp12_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length1 = _tmp10_;
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row_length2 = _tmp11_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->_cols;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = self->priv->_rows;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = g_new0 (gboolean, _tmp13_ * _tmp14_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = _tmp15_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length1 = _tmp13_;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col_length2 = _tmp14_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = block_rows;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = block_cols;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = block_rows;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = block_cols;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = g_new0 (gboolean, (_tmp16_ * _tmp17_) * (_tmp18_ * _tmp19_));
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = _tmp20_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length1 = _tmp16_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length2 = _tmp17_;
#line 103 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block_length3 = _tmp18_ * _tmp19_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = self->priv->_rows;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = self->priv->_cols;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = sudoku_board_get_max_val (self);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = _tmp23_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = g_new0 (gboolean, (_tmp21_ * _tmp22_) * _tmp24_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = _tmp25_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length1 = _tmp21_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length2 = _tmp22_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks_length3 = _tmp24_;
#line 423 "sudoku-board.c"
	{
		gint l1 = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 428 "sudoku-board.c"
		{
			gboolean _tmp26_ = FALSE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp26_ = TRUE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 435 "sudoku-board.c"
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp26_) {
#line 440 "sudoku-board.c"
					gint _tmp27_ = 0;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp27_ = l1;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp27_ + 1;
#line 446 "sudoku-board.c"
				}
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp26_ = FALSE;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp28_ = l1;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp29_ = self->priv->_rows;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp28_ < _tmp29_)) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 458 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 464 "sudoku-board.c"
					{
						gboolean _tmp30_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp30_ = TRUE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 471 "sudoku-board.c"
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							gint* _tmp34_ = NULL;
							gint _tmp34__length1 = 0;
							gint _tmp34__length2 = 0;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gboolean* _tmp38_ = NULL;
							gint _tmp38__length1 = 0;
							gint _tmp38__length2 = 0;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							gboolean _tmp41_ = FALSE;
							gboolean* _tmp42_ = NULL;
							gint _tmp42__length1 = 0;
							gint _tmp42__length2 = 0;
							gint _tmp43_ = 0;
							gint _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gboolean* _tmp46_ = NULL;
							gint _tmp46__length1 = 0;
							gint _tmp46__length2 = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							gboolean _tmp49_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp30_) {
#line 500 "sudoku-board.c"
								gint _tmp31_ = 0;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp31_ = l2;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp31_ + 1;
#line 506 "sudoku-board.c"
							}
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp30_ = FALSE;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp32_ = l2;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp33_ = self->priv->_cols;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp32_ < _tmp33_)) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 518 "sudoku-board.c"
							}
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34_ = self->cells;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34__length1 = self->cells_length1;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34__length2 = self->cells_length2;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp35_ = l1;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp36_ = l2;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = 0;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp37_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38_ = self->is_fixed;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38__length1 = self->is_fixed_length1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38__length2 = self->is_fixed_length2;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp39_ = l1;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp40_ = l2;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_] = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42_ = self->priv->possible_in_row;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42__length1 = self->priv->possible_in_row_length1;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42__length2 = self->priv->possible_in_row_length2;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp43_ = l1;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp44_ = l2;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_] = TRUE;
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp45_ = _tmp42_[(_tmp43_ * _tmp42__length2) + _tmp44_];
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46_ = self->priv->possible_in_col;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46__length1 = self->priv->possible_in_col_length1;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46__length2 = self->priv->possible_in_col_length2;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp47_ = l2;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp48_ = l1;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_] = TRUE;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 576 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint l1 = 0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 587 "sudoku-board.c"
		{
			gboolean _tmp50_ = FALSE;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp50_ = TRUE;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 594 "sudoku-board.c"
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp50_) {
#line 599 "sudoku-board.c"
					gint _tmp51_ = 0;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp51_ = l1;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp51_ + 1;
#line 605 "sudoku-board.c"
				}
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp50_ = FALSE;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp52_ = l1;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp53_ = block_rows;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp52_ < _tmp53_)) {
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 617 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 623 "sudoku-board.c"
					{
						gboolean _tmp54_ = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp54_ = TRUE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 630 "sudoku-board.c"
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp54_) {
#line 635 "sudoku-board.c"
								gint _tmp55_ = 0;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp55_ = l2;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp55_ + 1;
#line 641 "sudoku-board.c"
							}
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp54_ = FALSE;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp56_ = l2;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp57_ = block_cols;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp56_ < _tmp57_)) {
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 653 "sudoku-board.c"
							}
							{
								gint l3 = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l3 = 0;
#line 659 "sudoku-board.c"
								{
									gboolean _tmp58_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp58_ = TRUE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									while (TRUE) {
#line 666 "sudoku-board.c"
										gint _tmp60_ = 0;
										gint _tmp61_ = 0;
										gint _tmp62_ = 0;
										gboolean* _tmp63_ = NULL;
										gint _tmp63__length1 = 0;
										gint _tmp63__length2 = 0;
										gint _tmp63__length3 = 0;
										gint _tmp64_ = 0;
										gint _tmp65_ = 0;
										gint _tmp66_ = 0;
										gboolean _tmp67_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										if (!_tmp58_) {
#line 680 "sudoku-board.c"
											gint _tmp59_ = 0;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp59_ = l3;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											l3 = _tmp59_ + 1;
#line 686 "sudoku-board.c"
										}
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp58_ = FALSE;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp60_ = l3;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp61_ = sudoku_board_get_max_val (self);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp62_ = _tmp61_;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										if (!(_tmp60_ < _tmp62_)) {
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											break;
#line 700 "sudoku-board.c"
										}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63_ = self->priv->possible_in_block;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length1 = self->priv->possible_in_block_length1;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length2 = self->priv->possible_in_block_length2;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63__length3 = self->priv->possible_in_block_length3;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp64_ = l1;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp65_ = l2;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp66_ = l3;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_] = TRUE;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										_tmp67_ = _tmp63_[(((_tmp64_ * _tmp63__length2) + _tmp65_) * _tmp63__length3) + _tmp66_];
#line 720 "sudoku-board.c"
									}
								}
							}
						}
					}
				}
			}
		}
	}
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->broken_coords = (GeeSet*) _tmp68_;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = (GeeList*) _tmp69_;
#line 742 "sudoku-board.c"
	{
		gint col = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 747 "sudoku-board.c"
		{
			gboolean _tmp70_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp70_ = TRUE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 754 "sudoku-board.c"
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				GeeList* _tmp74_ = NULL;
				GeeArrayList* _tmp75_ = NULL;
				GeeArrayList* _tmp76_ = NULL;
				GeeList* _tmp88_ = NULL;
				gint _tmp89_ = 0;
				GeeList* _tmp90_ = NULL;
				gint _tmp91_ = 0;
				gpointer _tmp92_ = NULL;
				GeeList* _tmp93_ = NULL;
				GeeList* _tmp94_ = NULL;
				GeeList* _tmp95_ = NULL;
				GeeList* _tmp96_ = NULL;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp70_) {
#line 771 "sudoku-board.c"
					gint _tmp71_ = 0;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp71_ = col;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp71_ + 1;
#line 777 "sudoku-board.c"
				}
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp70_ = FALSE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp72_ = col;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp73_ = self->priv->_cols;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp72_ < _tmp73_)) {
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 789 "sudoku-board.c"
				}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp74_ = self->coords_for_col;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp75_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp76_ = _tmp75_;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp74_, (GeeList*) _tmp76_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp76_);
#line 801 "sudoku-board.c"
				{
					gint row = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 806 "sudoku-board.c"
					{
						gboolean _tmp77_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp77_ = TRUE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 813 "sudoku-board.c"
							gint _tmp79_ = 0;
							gint _tmp80_ = 0;
							GeeList* _tmp81_ = NULL;
							gint _tmp82_ = 0;
							gpointer _tmp83_ = NULL;
							GeeList* _tmp84_ = NULL;
							gint _tmp85_ = 0;
							gint _tmp86_ = 0;
							Coord _tmp87_ = {0};
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp77_) {
#line 825 "sudoku-board.c"
								gint _tmp78_ = 0;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp78_ = row;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp78_ + 1;
#line 831 "sudoku-board.c"
							}
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp77_ = FALSE;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp79_ = row;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp80_ = self->priv->_rows;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp79_ < _tmp80_)) {
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 843 "sudoku-board.c"
							}
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp81_ = self->coords_for_col;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp82_ = col;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp83_ = gee_list_get (_tmp81_, _tmp82_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp84_ = (GeeList*) _tmp83_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp85_ = row;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp86_ = col;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp87_, _tmp85_, _tmp86_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp84_, &_tmp87_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp84_);
#line 863 "sudoku-board.c"
						}
					}
				}
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp88_ = self->coords_for_col;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp89_ = col;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp90_ = self->coords_for_col;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp91_ = col;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp92_ = gee_list_get (_tmp90_, _tmp91_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp93_ = (GeeList*) _tmp92_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp94_ = gee_list_get_read_only_view (_tmp93_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp95_ = _tmp94_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp96_ = _tmp95_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp88_, _tmp89_, _tmp96_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp96_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp93_);
#line 891 "sudoku-board.c"
			}
		}
	}
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp97_ = self->coords_for_col;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp98_ = gee_list_get_read_only_view (_tmp97_);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp99_ = _tmp98_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_col = _tmp99_;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp100_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = (GeeList*) _tmp100_;
#line 911 "sudoku-board.c"
	{
		gint row = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		row = 0;
#line 916 "sudoku-board.c"
		{
			gboolean _tmp101_ = FALSE;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp101_ = TRUE;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 923 "sudoku-board.c"
				gint _tmp103_ = 0;
				gint _tmp104_ = 0;
				GeeList* _tmp105_ = NULL;
				GeeArrayList* _tmp106_ = NULL;
				GeeArrayList* _tmp107_ = NULL;
				GeeList* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				GeeList* _tmp121_ = NULL;
				gint _tmp122_ = 0;
				gpointer _tmp123_ = NULL;
				GeeList* _tmp124_ = NULL;
				GeeList* _tmp125_ = NULL;
				GeeList* _tmp126_ = NULL;
				GeeList* _tmp127_ = NULL;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp101_) {
#line 940 "sudoku-board.c"
					gint _tmp102_ = 0;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp102_ = row;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = _tmp102_ + 1;
#line 946 "sudoku-board.c"
				}
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp101_ = FALSE;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp103_ = row;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp104_ = self->priv->_rows;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp103_ < _tmp104_)) {
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 958 "sudoku-board.c"
				}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp105_ = self->coords_for_row;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp106_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp107_ = _tmp106_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp105_, (GeeList*) _tmp107_);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp107_);
#line 970 "sudoku-board.c"
				{
					gint col = 0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = 0;
#line 975 "sudoku-board.c"
					{
						gboolean _tmp108_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp108_ = TRUE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 982 "sudoku-board.c"
							gint _tmp110_ = 0;
							gint _tmp111_ = 0;
							GeeList* _tmp112_ = NULL;
							gint _tmp113_ = 0;
							gpointer _tmp114_ = NULL;
							GeeList* _tmp115_ = NULL;
							gint _tmp116_ = 0;
							gint _tmp117_ = 0;
							Coord _tmp118_ = {0};
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp108_) {
#line 994 "sudoku-board.c"
								gint _tmp109_ = 0;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp109_ = col;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								col = _tmp109_ + 1;
#line 1000 "sudoku-board.c"
							}
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp108_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp110_ = col;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp111_ = self->priv->_cols;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp110_ < _tmp111_)) {
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1012 "sudoku-board.c"
							}
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp112_ = self->coords_for_row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp113_ = row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp114_ = gee_list_get (_tmp112_, _tmp113_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp115_ = (GeeList*) _tmp114_;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp116_ = row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp117_ = col;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp118_, _tmp116_, _tmp117_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp115_, &_tmp118_);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp115_);
#line 1032 "sudoku-board.c"
						}
					}
				}
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp119_ = self->coords_for_row;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp120_ = row;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp121_ = self->coords_for_row;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp122_ = row;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp123_ = gee_list_get (_tmp121_, _tmp122_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp124_ = (GeeList*) _tmp123_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp125_ = gee_list_get_read_only_view (_tmp124_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp126_ = _tmp125_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp127_ = _tmp126_;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_list_set (_tmp119_, _tmp120_, _tmp127_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp127_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_g_object_unref0 (_tmp124_);
#line 1060 "sudoku-board.c"
			}
		}
	}
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp128_ = self->coords_for_row;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp129_ = gee_list_get_read_only_view (_tmp128_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp130_ = _tmp129_;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_row = _tmp130_;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp131_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = (GeeMap*) _tmp131_;
#line 1080 "sudoku-board.c"
	{
		gint col = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1085 "sudoku-board.c"
		{
			gboolean _tmp132_ = FALSE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp132_ = TRUE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1092 "sudoku-board.c"
				gint _tmp134_ = 0;
				gint _tmp135_ = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp132_) {
#line 1097 "sudoku-board.c"
					gint _tmp133_ = 0;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp133_ = col;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp133_ + 1;
#line 1103 "sudoku-board.c"
				}
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp132_ = FALSE;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp134_ = col;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp135_ = block_cols;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp134_ < _tmp135_)) {
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1115 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1121 "sudoku-board.c"
					{
						gboolean _tmp136_ = FALSE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp136_ = TRUE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1128 "sudoku-board.c"
							gint _tmp138_ = 0;
							gint _tmp139_ = 0;
							GeeMap* _tmp140_ = NULL;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							Coord _tmp143_ = {0};
							GeeArrayList* _tmp144_ = NULL;
							GeeArrayList* _tmp145_ = NULL;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp136_) {
#line 1139 "sudoku-board.c"
								gint _tmp137_ = 0;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp137_ = row;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp137_ + 1;
#line 1145 "sudoku-board.c"
							}
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp136_ = FALSE;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp138_ = row;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp139_ = block_rows;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp138_ < _tmp139_)) {
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1157 "sudoku-board.c"
							}
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp140_ = self->coords_for_block;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp141_ = row;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp142_ = col;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp143_, _tmp141_, _tmp142_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp144_ = gee_array_list_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp145_ = _tmp144_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp140_, &_tmp143_, (GeeList*) _tmp145_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp145_);
#line 1175 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1186 "sudoku-board.c"
		{
			gboolean _tmp146_ = FALSE;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp146_ = TRUE;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1193 "sudoku-board.c"
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp146_) {
#line 1198 "sudoku-board.c"
					gint _tmp147_ = 0;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp147_ = col;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp147_ + 1;
#line 1204 "sudoku-board.c"
				}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp146_ = FALSE;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp148_ = col;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp149_ = self->priv->_cols;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp148_ < _tmp149_)) {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1216 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1222 "sudoku-board.c"
					{
						gboolean _tmp150_ = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp150_ = TRUE;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1229 "sudoku-board.c"
							gint _tmp152_ = 0;
							gint _tmp153_ = 0;
							GeeMap* _tmp154_ = NULL;
							gint _tmp155_ = 0;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
							gint _tmp158_ = 0;
							Coord _tmp159_ = {0};
							gpointer _tmp160_ = NULL;
							GeeList* _tmp161_ = NULL;
							gint _tmp162_ = 0;
							gint _tmp163_ = 0;
							Coord _tmp164_ = {0};
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp150_) {
#line 1245 "sudoku-board.c"
								gint _tmp151_ = 0;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp151_ = row;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp151_ + 1;
#line 1251 "sudoku-board.c"
							}
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp150_ = FALSE;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp152_ = row;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp153_ = self->priv->_rows;
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp152_ < _tmp153_)) {
#line 161 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1263 "sudoku-board.c"
							}
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp154_ = self->coords_for_block;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp155_ = row;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp156_ = block_rows;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp157_ = col;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp158_ = block_cols;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp159_, _tmp155_ / _tmp156_, _tmp157_ / _tmp158_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp160_ = gee_map_get (_tmp154_, &_tmp159_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp161_ = (GeeList*) _tmp160_;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp162_ = row;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp163_ = col;
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp164_, _tmp162_, _tmp163_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_collection_add ((GeeCollection*) _tmp161_, &_tmp164_);
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp161_);
#line 1291 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
	{
		gint col = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		col = 0;
#line 1302 "sudoku-board.c"
		{
			gboolean _tmp165_ = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp165_ = TRUE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1309 "sudoku-board.c"
				gint _tmp167_ = 0;
				gint _tmp168_ = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp165_) {
#line 1314 "sudoku-board.c"
					gint _tmp166_ = 0;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp166_ = col;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					col = _tmp166_ + 1;
#line 1320 "sudoku-board.c"
				}
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp165_ = FALSE;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp167_ = col;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp168_ = block_cols;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp167_ < _tmp168_)) {
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1332 "sudoku-board.c"
				}
				{
					gint row = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					row = 0;
#line 1338 "sudoku-board.c"
					{
						gboolean _tmp169_ = FALSE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp169_ = TRUE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 1345 "sudoku-board.c"
							gint _tmp171_ = 0;
							gint _tmp172_ = 0;
							GeeMap* _tmp173_ = NULL;
							gint _tmp174_ = 0;
							gint _tmp175_ = 0;
							Coord _tmp176_ = {0};
							GeeMap* _tmp177_ = NULL;
							gint _tmp178_ = 0;
							gint _tmp179_ = 0;
							Coord _tmp180_ = {0};
							gpointer _tmp181_ = NULL;
							GeeList* _tmp182_ = NULL;
							GeeList* _tmp183_ = NULL;
							GeeList* _tmp184_ = NULL;
							GeeList* _tmp185_ = NULL;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp169_) {
#line 1363 "sudoku-board.c"
								gint _tmp170_ = 0;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp170_ = row;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								row = _tmp170_ + 1;
#line 1369 "sudoku-board.c"
							}
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp169_ = FALSE;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp171_ = row;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp172_ = block_rows;
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp171_ < _tmp172_)) {
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 1381 "sudoku-board.c"
							}
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp173_ = self->coords_for_block;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp174_ = row;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp175_ = col;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp176_, _tmp174_, _tmp175_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp177_ = self->coords_for_block;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp178_ = row;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp179_ = col;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							coord_init (&_tmp180_, _tmp178_, _tmp179_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp181_ = gee_map_get (_tmp177_, &_tmp180_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp182_ = (GeeList*) _tmp181_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp183_ = gee_list_get_read_only_view (_tmp182_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp184_ = _tmp183_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp185_ = _tmp184_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							gee_map_set (_tmp173_, &_tmp176_, _tmp185_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp185_);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_g_object_unref0 (_tmp182_);
#line 1415 "sudoku-board.c"
						}
					}
				}
			}
		}
	}
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp186_ = self->coords_for_block;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp187_ = gee_map_get_read_only_view (_tmp186_);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp188_ = _tmp187_;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->coords_for_block = _tmp188_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return self;
#line 1434 "sudoku-board.c"
}


SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return sudoku_board_construct (TYPE_SUDOKU_BOARD, block_rows, block_cols);
#line 1441 "sudoku-board.c"
}


static gint* _vala_array_dup1 (gint* self, int length) {
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 1448 "sudoku-board.c"
}


static gboolean* _vala_array_dup2 (gboolean* self, int length) {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1455 "sudoku-board.c"
}


static gboolean* _vala_array_dup3 (gboolean* self, int length) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1462 "sudoku-board.c"
}


static gboolean* _vala_array_dup4 (gboolean* self, int length) {
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1469 "sudoku-board.c"
}


static gboolean* _vala_array_dup5 (gboolean* self, int length) {
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1476 "sudoku-board.c"
}


static gboolean* _vala_array_dup6 (gboolean* self, int length) {
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gboolean));
#line 1483 "sudoku-board.c"
}


SudokuBoard* sudoku_board_clone (SudokuBoard* self) {
	SudokuBoard* result = NULL;
	SudokuBoard* board = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuBoard* _tmp2_ = NULL;
	gint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gboolean* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint _tmp5__length2 = 0;
	gboolean* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	gint _tmp6__length2 = 0;
	gboolean* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	gint _tmp7__length2 = 0;
	gboolean* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	gint _tmp8__length2 = 0;
	gboolean* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gboolean* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gboolean* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp11__length3 = 0;
	gboolean* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	gint _tmp12__length2 = 0;
	gint _tmp12__length3 = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GeeSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	gboolean* _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint _tmp18__length2 = 0;
	gint _tmp18__length3 = 0;
	gboolean* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp19__length2 = 0;
	gint _tmp19__length3 = 0;
	DifficultyCategory _tmp20_ = 0;
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_cols;
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_new (_tmp0_, _tmp1_);
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board = _tmp2_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->cells;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->cells_length1;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->cells_length2;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup1 (_tmp3_, _tmp3__length1 * _tmp3__length2) : ((gpointer) _tmp3_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp3__length1;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length2 = _tmp3__length2;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = (g_free (board->cells), NULL);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells = _tmp4_;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length1 = _tmp4__length1;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->cells_length2 = _tmp4__length2;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = self->is_fixed;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length1 = self->is_fixed_length1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5__length2 = self->is_fixed_length2;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = (_tmp5_ != NULL) ? _vala_array_dup2 (_tmp5_, _tmp5__length1 * _tmp5__length2) : ((gpointer) _tmp5_);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length1 = _tmp5__length1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6__length2 = _tmp5__length2;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = (g_free (board->is_fixed), NULL);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed = _tmp6_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length1 = _tmp6__length1;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->is_fixed_length2 = _tmp6__length2;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = self->priv->possible_in_row;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length1 = self->priv->possible_in_row_length1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7__length2 = self->priv->possible_in_row_length2;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = (_tmp7_ != NULL) ? _vala_array_dup3 (_tmp7_, _tmp7__length1 * _tmp7__length2) : ((gpointer) _tmp7_);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length1 = _tmp7__length1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8__length2 = _tmp7__length2;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = (g_free (board->priv->possible_in_row), NULL);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row = _tmp8_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length1 = _tmp8__length1;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_row_length2 = _tmp8__length2;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->priv->possible_in_col;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->priv->possible_in_col_length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->priv->possible_in_col_length2;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = (_tmp9_ != NULL) ? _vala_array_dup4 (_tmp9_, _tmp9__length1 * _tmp9__length2) : ((gpointer) _tmp9_);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length1 = _tmp9__length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10__length2 = _tmp9__length2;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = (g_free (board->priv->possible_in_col), NULL);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col = _tmp10_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length1 = _tmp10__length1;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_col_length2 = _tmp10__length2;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->possible_in_block;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length1 = self->priv->possible_in_block_length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length2 = self->priv->possible_in_block_length2;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11__length3 = self->priv->possible_in_block_length3;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = (_tmp11_ != NULL) ? _vala_array_dup5 (_tmp11_, (_tmp11__length1 * _tmp11__length2) * _tmp11__length3) : ((gpointer) _tmp11_);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length1 = _tmp11__length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length2 = _tmp11__length2;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12__length3 = _tmp11__length3;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = (g_free (board->priv->possible_in_block), NULL);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block = _tmp12_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length1 = _tmp12__length1;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length2 = _tmp12__length2;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->possible_in_block_length3 = _tmp12__length3;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->_filled;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (board, _tmp13_);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = self->priv->_fixed;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_fixed (board, _tmp14_);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = self->priv->n_earmarks;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->n_earmarks = _tmp15_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = board->broken_coords;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->broken_coords;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	gee_collection_add_all ((GeeCollection*) _tmp16_, (GeeCollection*) _tmp17_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = self->priv->earmarks;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length1 = self->priv->earmarks_length1;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length2 = self->priv->earmarks_length2;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18__length3 = self->priv->earmarks_length3;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = (_tmp18_ != NULL) ? _vala_array_dup6 (_tmp18_, (_tmp18__length1 * _tmp18__length2) * _tmp18__length3) : ((gpointer) _tmp18_);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length1 = _tmp18__length1;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length2 = _tmp18__length2;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19__length3 = _tmp18__length3;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks = (g_free (board->priv->earmarks), NULL);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks = _tmp19_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length1 = _tmp19__length1;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length2 = _tmp19__length2;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board->priv->earmarks_length3 = _tmp19__length3;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = self->priv->_difficulty_category;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_difficulty_category (board, _tmp20_);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = board;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 1707 "sudoku-board.c"
}


void sudoku_board_enable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 1741 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->priv->earmarks;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->priv->earmarks_length1;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->priv->earmarks_length2;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length3 = self->priv->earmarks_length3;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = column;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = digit;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = TRUE;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = self->priv->n_earmarks;
#line 200 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		self->priv->n_earmarks = _tmp10_ + 1;
#line 1773 "sudoku-board.c"
	}
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->n_earmarks;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp11_ > 0, "n_earmarks > 0");
#line 1779 "sudoku-board.c"
}


void sudoku_board_disable_earmark (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp4_) {
#line 1813 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp5__length3 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_ = 0;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->priv->earmarks;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->priv->earmarks_length1;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->priv->earmarks_length2;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length3 = self->priv->earmarks_length3;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = column;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = digit;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)] = FALSE;
#line 209 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = self->priv->n_earmarks;
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		self->priv->n_earmarks = _tmp10_ - 1;
#line 1845 "sudoku-board.c"
	}
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = self->priv->n_earmarks;
#line 204 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp11_ >= 0, "n_earmarks >= 0");
#line 1851 "sudoku-board.c"
}


void sudoku_board_disable_all_earmarks (SudokuBoard* self, gint row, gint column) {
	gint _tmp13_ = 0;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 1859 "sudoku-board.c"
	{
		gint i = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 1;
#line 1864 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 1871 "sudoku-board.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gboolean* _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				gint _tmp5__length2 = 0;
				gint _tmp5__length3 = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gboolean _tmp9_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 1885 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = i;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp1_ + 1;
#line 1891 "sudoku-board.c"
				}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = i;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = sudoku_board_get_max_val (self);
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = _tmp3_;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ <= _tmp4_)) {
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 1905 "sudoku-board.c"
				}
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = self->priv->earmarks;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length1 = self->priv->earmarks_length1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length2 = self->priv->earmarks_length2;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5__length3 = self->priv->earmarks_length3;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = row;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = column;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = i;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = _tmp5_[(((_tmp6_ * _tmp5__length2) + _tmp7_) * _tmp5__length3) + (_tmp8_ - 1)];
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp9_) {
#line 1925 "sudoku-board.c"
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp10_ = row;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp11_ = column;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp12_ = i;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					sudoku_board_disable_earmark (self, _tmp10_, _tmp11_, _tmp12_);
#line 1937 "sudoku-board.c"
				}
			}
		}
	}
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->priv->n_earmarks;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_warn_if_fail (_tmp13_ >= 0, "n_earmarks >= 0");
#line 1946 "sudoku-board.c"
}


gboolean sudoku_board_is_earmark_enabled (SudokuBoard* self, gint row, gint column, gint digit) {
	gboolean result = FALSE;
	gboolean* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp0__length3 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->earmarks;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->priv->earmarks_length1;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->priv->earmarks_length2;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length3 = self->priv->earmarks_length3;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = column;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = digit;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp0_[(((_tmp1_ * _tmp0__length2) + _tmp2_) * _tmp0__length3) + (_tmp3_ - 1)];
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp4_;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 1982 "sudoku-board.c"
}


gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gint _tmp3__length2 = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp0_ - 1;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->possible_in_row;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length1 = self->priv->possible_in_row_length1;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3__length2 = self->priv->possible_in_row_length2;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = row;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = val;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp3_[(_tmp4_ * _tmp3__length2) + _tmp5_];
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp6_) {
#line 2017 "sudoku-board.c"
		gboolean* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gboolean _tmp10_ = FALSE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = self->priv->possible_in_col;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length1 = self->priv->possible_in_col_length1;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7__length2 = self->priv->possible_in_col_length2;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = col;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = val;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _tmp10_;
#line 2038 "sudoku-board.c"
	} else {
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = FALSE;
#line 2042 "sudoku-board.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_) {
#line 2046 "sudoku-board.c"
		gboolean* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp11__length3 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gboolean _tmp17_ = FALSE;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11_ = self->priv->possible_in_block;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length1 = self->priv->possible_in_block_length1;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length2 = self->priv->possible_in_block_length2;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp11__length3 = self->priv->possible_in_block_length3;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp12_ = row;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = self->priv->_block_cols;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = self->priv->_block_rows;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp16_ = val;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp17_ = _tmp11_[((((_tmp12_ / _tmp13_) * _tmp11__length2) + (_tmp14_ / _tmp15_)) * _tmp11__length3) + _tmp16_];
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _tmp17_;
#line 2079 "sudoku-board.c"
	} else {
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = FALSE;
#line 2083 "sudoku-board.c"
	}
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp1_;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2089 "sudoku-board.c"
}


gint sudoku_board_count_possibilities (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = sudoku_board_get_possibilities (self, _tmp0_, _tmp1_, &_tmp2_);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4__length1 = _tmp2_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp2_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = (g_free (_tmp4_), NULL);
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp5_;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2122 "sudoku-board.c"
}


static gint* _vala_array_dup7 (gint* self, int length) {
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 2129 "sudoku-board.c"
}


gint* sudoku_board_get_possibilities (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint* possibilities = NULL;
	gint* _tmp6_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gint count = 0;
	gint* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp22_ = 0;
	gint* _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gint* _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ != 0) {
#line 2169 "sudoku-board.c"
		gint* _tmp4_ = NULL;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = g_new0 (gint, 0);
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = 0;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (result_length1) {
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			*result_length1 = _tmp5__length1;
#line 2183 "sudoku-board.c"
		}
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		result = _tmp5_;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		return result;
#line 2189 "sudoku-board.c"
	}
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_new0 (gint, 9);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp6_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = 9;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	count = 0;
#line 2201 "sudoku-board.c"
	{
		gint l = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2206 "sudoku-board.c"
		{
			gboolean _tmp7_ = FALSE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = TRUE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2213 "sudoku-board.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp7_) {
#line 2223 "sudoku-board.c"
					gint _tmp8_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp8_ = l;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp8_ + 1;
#line 2229 "sudoku-board.c"
				}
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = FALSE;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = sudoku_board_get_max_val (self);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = _tmp10_;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp9_ <= _tmp11_)) {
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2243 "sudoku-board.c"
				}
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = row;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = col;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = l;
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = sudoku_board_is_possible (self, _tmp12_, _tmp13_, _tmp14_);
#line 248 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp15_) {
#line 2255 "sudoku-board.c"
					gint* _tmp16_ = NULL;
					gint _tmp16__length1 = 0;
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_ = possibilities;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16__length1 = possibilities_length1;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = count;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp18_ = l;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp16_[_tmp17_] = _tmp18_;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp19_ = _tmp16_[_tmp17_];
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp20_ = count;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					count = _tmp20_ + 1;
#line 2278 "sudoku-board.c"
				}
			}
		}
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = possibilities;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = possibilities_length1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = count;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = ((_tmp21_ + 0) != NULL) ? _vala_array_dup7 (_tmp21_ + 0, _tmp22_ - 0) : ((gpointer) (_tmp21_ + 0));
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23__length1 = _tmp22_ - 0;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = _tmp23_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24__length1 = _tmp23__length1;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp24__length1;
#line 2301 "sudoku-board.c"
	}
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp24_;
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = (g_free (possibilities), NULL);
#line 253 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2309 "sudoku-board.c"
}


gboolean* sudoku_board_get_possibilities_as_bool_array (SudokuBoard* self, gint row, gint col, int* result_length1) {
	gboolean* result = NULL;
	gboolean* possibilities = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean* _tmp2_ = NULL;
	gint possibilities_length1 = 0;
	gint _possibilities_size_ = 0;
	gboolean* _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
#line 256 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_get_max_val (self);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_new0 (gboolean, _tmp1_);
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp2_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities_length1 = _tmp1_;
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_possibilities_size_ = possibilities_length1;
#line 2337 "sudoku-board.c"
	{
		gint l = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l = 1;
#line 2342 "sudoku-board.c"
		{
			gboolean _tmp3_ = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = TRUE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 2349 "sudoku-board.c"
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gboolean* _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
				gboolean _tmp14_ = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp3_) {
#line 2363 "sudoku-board.c"
					gint _tmp4_ = 0;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp4_ = l;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l = _tmp4_ + 1;
#line 2369 "sudoku-board.c"
				}
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = FALSE;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = l;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = sudoku_board_get_max_val (self);
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = _tmp6_;
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp5_ <= _tmp7_)) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 2383 "sudoku-board.c"
				}
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = possibilities;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8__length1 = possibilities_length1;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = l;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = row;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp11_ = col;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp12_ = l;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = sudoku_board_is_possible (self, _tmp10_, _tmp11_, _tmp12_);
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_[_tmp9_ - 1] = _tmp13_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp14_ = _tmp8_[_tmp9_ - 1];
#line 2403 "sudoku-board.c"
			}
		}
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = possibilities;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15__length1 = possibilities_length1;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp15__length1;
#line 2415 "sudoku-board.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp15_;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2421 "sudoku-board.c"
}


void sudoku_board_get_block_for (SudokuBoard* self, gint row, gint col, Coord* result) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Coord _tmp4_ = {0};
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_rows;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_block_cols;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp4_, _tmp0_ / _tmp1_, _tmp2_ / _tmp3_);
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	*result = _tmp4_;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return;
#line 2447 "sudoku-board.c"
}


void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp16__length2 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	gint _tmp20_ = 0;
	gboolean* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gint _tmp21__length2 = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gboolean _tmp27_ = FALSE;
	gboolean* _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	gint _tmp29__length2 = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	gboolean* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp38__length2 = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
	gboolean _tmp41_ = FALSE;
	gboolean* _tmp47_ = NULL;
	gint _tmp47__length1 = 0;
	gint _tmp47__length2 = 0;
	gint _tmp47__length3 = 0;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	gint _tmp50_ = 0;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	gboolean _tmp53_ = FALSE;
	gint _tmp63_ = 0;
	gboolean* _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gint _tmp64__length2 = 0;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gboolean _tmp67_ = FALSE;
	gboolean* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	gint _tmp68__length2 = 0;
	gint _tmp69_ = 0;
	gint _tmp70_ = 0;
	gboolean _tmp71_ = FALSE;
	gboolean* _tmp72_ = NULL;
	gint _tmp72__length1 = 0;
	gint _tmp72__length2 = 0;
	gint _tmp72__length3 = 0;
	gint _tmp73_ = 0;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp79_ = FALSE;
	gboolean _tmp80_ = FALSE;
#line 273 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 276 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp0_ > 0, "val > 0");
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_max_val (self);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_vala_assert (_tmp1_ <= _tmp3_, "val <= max_val");
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 2544 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 2565 "sudoku-board.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp12_ != 0) {
#line 2581 "sudoku-board.c"
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp13_ = row;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp14_ = col;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp15_ = is_fixed;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp13_, _tmp14_, _tmp15_);
#line 2593 "sudoku-board.c"
	}
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = self->cells;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length1 = self->cells_length1;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16__length2 = self->cells_length2;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = row;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = col;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = val;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_] = _tmp19_;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp20_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = self->is_fixed;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length1 = self->is_fixed_length1;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21__length2 = self->is_fixed_length2;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = row;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp23_ = col;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp24_ = is_fixed;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp25_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp26_ = self->priv->_filled;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (self, _tmp26_ + 1);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp27_ = is_fixed;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp27_) {
#line 2635 "sudoku-board.c"
		gint _tmp28_ = 0;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp28_ = self->priv->_fixed;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_fixed (self, _tmp28_ + 1);
#line 2641 "sudoku-board.c"
	}
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29_ = self->priv->possible_in_row;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29__length1 = self->priv->possible_in_row_length1;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp29__length2 = self->priv->possible_in_row_length2;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp30_ = row;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp31_ = val;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + (_tmp31_ - 1)];
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp32_) {
#line 2657 "sudoku-board.c"
		GeeList* _tmp33_ = NULL;
		gint _tmp34_ = 0;
		gpointer _tmp35_ = NULL;
		GeeList* _tmp36_ = NULL;
		gint _tmp37_ = 0;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = self->coords_for_row;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = row;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = gee_list_get (_tmp33_, _tmp34_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp36_ = (GeeList*) _tmp35_;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp37_ = val;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp36_, _tmp37_);
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp36_);
#line 2677 "sudoku-board.c"
	}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38_ = self->priv->possible_in_col;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38__length1 = self->priv->possible_in_col_length1;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp38__length2 = self->priv->possible_in_col_length2;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp39_ = col;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp40_ = val;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)];
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp41_) {
#line 2693 "sudoku-board.c"
		GeeList* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gpointer _tmp44_ = NULL;
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = self->coords_for_col;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = col;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp45_ = (GeeList*) _tmp44_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp46_ = val;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp45_, _tmp46_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp45_);
#line 2713 "sudoku-board.c"
	}
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47_ = self->priv->possible_in_block;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length1 = self->priv->possible_in_block_length1;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length2 = self->priv->possible_in_block_length2;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp47__length3 = self->priv->possible_in_block_length3;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp48_ = row;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp49_ = self->priv->_block_cols;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp50_ = col;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp51_ = self->priv->_block_rows;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp52_ = val;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp53_ = _tmp47_[((((_tmp48_ / _tmp49_) * _tmp47__length2) + (_tmp50_ / _tmp51_)) * _tmp47__length3) + (_tmp52_ - 1)];
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp53_) {
#line 2737 "sudoku-board.c"
		GeeMap* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		Coord _tmp59_ = {0};
		gpointer _tmp60_ = NULL;
		GeeList* _tmp61_ = NULL;
		gint _tmp62_ = 0;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = self->coords_for_block;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = row;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = self->priv->_block_cols;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp57_ = col;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = self->priv->_block_rows;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp59_, _tmp55_ / _tmp56_, _tmp57_ / _tmp58_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp60_ = gee_map_get (_tmp54_, &_tmp59_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp61_ = (GeeList*) _tmp60_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp62_ = val;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp61_, _tmp62_);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp61_);
#line 2769 "sudoku-board.c"
	}
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp63_ = val;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	val = _tmp63_ - 1;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64_ = self->priv->possible_in_row;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64__length1 = self->priv->possible_in_row_length1;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64__length2 = self->priv->possible_in_row_length2;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp65_ = row;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp66_ = val;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_] = FALSE;
#line 310 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp67_ = _tmp64_[(_tmp65_ * _tmp64__length2) + _tmp66_];
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_ = self->priv->possible_in_col;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68__length1 = self->priv->possible_in_col_length1;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68__length2 = self->priv->possible_in_col_length2;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp69_ = col;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp70_ = val;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_] = FALSE;
#line 311 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp71_ = _tmp68_[(_tmp69_ * _tmp68__length2) + _tmp70_];
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72_ = self->priv->possible_in_block;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length1 = self->priv->possible_in_block_length1;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length2 = self->priv->possible_in_block_length2;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72__length3 = self->priv->possible_in_block_length3;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp73_ = row;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp74_ = self->priv->_block_cols;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp75_ = col;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp76_ = self->priv->_block_rows;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp77_ = val;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_] = FALSE;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp78_ = _tmp72_[((((_tmp73_ / _tmp74_) * _tmp72__length2) + (_tmp75_ / _tmp76_)) * _tmp72__length3) + _tmp77_];
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp79_ = sudoku_board_get_complete (self);
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp80_ = _tmp79_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp80_) {
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_signal_emit_by_name (self, "completed");
#line 2833 "sudoku-board.c"
	}
}


void sudoku_board_set (SudokuBoard* self, gint row, gint col, gint val) {
	gint _tmp0_ = 0;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = val;
#line 320 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp0_ == 0) {
#line 2846 "sudoku-board.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = row;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = col;
#line 322 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove (self, _tmp1_, _tmp2_, FALSE);
#line 2855 "sudoku-board.c"
	} else {
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = val;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp4_ > 0) {
#line 2863 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = val;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = sudoku_board_get_max_val (self);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _tmp6_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = _tmp5_ <= _tmp7_;
#line 2875 "sudoku-board.c"
		} else {
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = FALSE;
#line 2879 "sudoku-board.c"
		}
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		if (_tmp3_) {
#line 2883 "sudoku-board.c"
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = row;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = col;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = val;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			sudoku_board_insert (self, _tmp8_, _tmp9_, _tmp10_, FALSE);
#line 2895 "sudoku-board.c"
		} else {
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 2899 "sudoku-board.c"
		}
	}
}


gint sudoku_board_get (SudokuBoard* self, gint row, gint col) {
	gint result = 0;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp3_;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 2931 "sudoku-board.c"
}


void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gint previous_val = 0;
	gint* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	gint _tmp9__length2 = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint* _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp13__length2 = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	GeeSet* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	Coord _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	gint _tmp126_ = 0;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = col;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ == 0) {
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		return;
#line 2980 "sudoku-board.c"
	}
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = is_fixed;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (!_tmp4_) {
#line 2986 "sudoku-board.c"
		gboolean* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp5__length2 = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gboolean _tmp8_ = FALSE;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = self->is_fixed;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length1 = self->is_fixed_length1;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5__length2 = self->is_fixed_length2;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = row;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = col;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp5_[(_tmp6_ * _tmp5__length2) + _tmp7_];
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_vala_assert (!_tmp8_, "!this.is_fixed[row, col]");
#line 3007 "sudoku-board.c"
	}
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = self->cells;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length1 = self->cells_length1;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9__length2 = self->cells_length2;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp10_ = row;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp11_ = col;
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 349 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	previous_val = _tmp12_;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_ = self->cells;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length1 = self->cells_length1;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13__length2 = self->cells_length2;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp14_ = row;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp15_ = col;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_] = 0;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp16_ = _tmp13_[(_tmp14_ * _tmp13__length2) + _tmp15_];
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp17_ = self->broken_coords;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = row;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp19_ = col;
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	coord_init (&_tmp20_, _tmp18_, _tmp19_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp21_ = gee_collection_contains ((GeeCollection*) _tmp17_, &_tmp20_);
#line 352 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp21_) {
#line 3049 "sudoku-board.c"
		GeeList* _tmp22_ = NULL;
		gint _tmp23_ = 0;
		gpointer _tmp24_ = NULL;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		GeeList* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gpointer _tmp29_ = NULL;
		GeeList* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		GeeMap* _tmp32_ = NULL;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Coord _tmp37_ = {0};
		gpointer _tmp38_ = NULL;
		GeeList* _tmp39_ = NULL;
		gint _tmp40_ = 0;
		GeeSet* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		Coord _tmp44_ = {0};
		GeeList* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gpointer _tmp47_ = NULL;
		GeeList* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		GeeList* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gpointer _tmp52_ = NULL;
		GeeList* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		GeeMap* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		Coord _tmp60_ = {0};
		gpointer _tmp61_ = NULL;
		GeeList* _tmp62_ = NULL;
		gint _tmp63_ = 0;
		gboolean* _tmp64_ = NULL;
		gint _tmp64__length1 = 0;
		gint _tmp64__length2 = 0;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		GeeList* _tmp67_ = NULL;
		gint _tmp68_ = 0;
		gpointer _tmp69_ = NULL;
		GeeList* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		GeeSet* _tmp72_ = NULL;
		GeeSet* _tmp73_ = NULL;
		gint _tmp74_ = 0;
		gint _tmp75_ = 0;
		gboolean _tmp76_ = FALSE;
		gboolean* _tmp77_ = NULL;
		gint _tmp77__length1 = 0;
		gint _tmp77__length2 = 0;
		gint _tmp78_ = 0;
		gint _tmp79_ = 0;
		GeeList* _tmp80_ = NULL;
		gint _tmp81_ = 0;
		gpointer _tmp82_ = NULL;
		GeeList* _tmp83_ = NULL;
		gint _tmp84_ = 0;
		GeeSet* _tmp85_ = NULL;
		GeeSet* _tmp86_ = NULL;
		gint _tmp87_ = 0;
		gint _tmp88_ = 0;
		gboolean _tmp89_ = FALSE;
		gboolean* _tmp90_ = NULL;
		gint _tmp90__length1 = 0;
		gint _tmp90__length2 = 0;
		gint _tmp90__length3 = 0;
		gint _tmp91_ = 0;
		gint _tmp92_ = 0;
		gint _tmp93_ = 0;
		gint _tmp94_ = 0;
		gint _tmp95_ = 0;
		GeeMap* _tmp96_ = NULL;
		gint _tmp97_ = 0;
		gint _tmp98_ = 0;
		gint _tmp99_ = 0;
		gint _tmp100_ = 0;
		Coord _tmp101_ = {0};
		gpointer _tmp102_ = NULL;
		GeeList* _tmp103_ = NULL;
		gint _tmp104_ = 0;
		GeeSet* _tmp105_ = NULL;
		GeeSet* _tmp106_ = NULL;
		gint _tmp107_ = 0;
		gint _tmp108_ = 0;
		gboolean _tmp109_ = FALSE;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp22_ = self->coords_for_row;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp23_ = row;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp25_ = (GeeList*) _tmp24_;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp26_ = previous_val;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp25_, _tmp26_);
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp25_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp27_ = self->coords_for_col;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp28_ = col;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp29_ = gee_list_get (_tmp27_, _tmp28_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp30_ = (GeeList*) _tmp29_;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp31_ = previous_val;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp30_, _tmp31_);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp30_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp32_ = self->coords_for_block;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp33_ = row;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp34_ = self->priv->_block_rows;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp35_ = col;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp36_ = self->priv->_block_cols;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp37_, _tmp33_ / _tmp34_, _tmp35_ / _tmp36_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp38_ = gee_map_get (_tmp32_, &_tmp37_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp39_ = (GeeList*) _tmp38_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp40_ = previous_val;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_remove_breakages_for (self, _tmp39_, _tmp40_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp39_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp41_ = self->broken_coords;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp42_ = row;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp43_ = col;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp44_, _tmp42_, _tmp43_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_remove ((GeeCollection*) _tmp41_, &_tmp44_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp45_ = self->coords_for_row;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp46_ = row;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp47_ = gee_list_get (_tmp45_, _tmp46_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp48_ = (GeeList*) _tmp47_;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp49_ = previous_val;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp48_, _tmp49_);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp48_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp50_ = self->coords_for_col;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp51_ = col;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp53_ = (GeeList*) _tmp52_;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp54_ = previous_val;
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp53_, _tmp54_);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp53_);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp55_ = self->coords_for_block;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp56_ = row;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp57_ = self->priv->_block_rows;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp58_ = col;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp59_ = self->priv->_block_cols;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp60_, _tmp56_ / _tmp57_, _tmp58_ / _tmp59_);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp61_ = gee_map_get (_tmp55_, &_tmp60_);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp62_ = (GeeList*) _tmp61_;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp63_ = previous_val;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_mark_breakages_for (self, _tmp62_, _tmp63_);
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp62_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_ = self->priv->possible_in_row;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length1 = self->priv->possible_in_row_length1;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64__length2 = self->priv->possible_in_row_length2;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp65_ = row;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp66_ = previous_val;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp67_ = self->coords_for_row;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp68_ = row;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp69_ = gee_list_get (_tmp67_, _tmp68_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp70_ = (GeeList*) _tmp69_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp71_ = previous_val;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp72_ = sudoku_board_get_occurances (self, _tmp70_, _tmp71_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp73_ = _tmp72_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp74_ = gee_collection_get_size ((GeeCollection*) _tmp73_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp75_ = _tmp74_;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)] = _tmp75_ == 0;
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp76_ = _tmp64_[(_tmp65_ * _tmp64__length2) + (_tmp66_ - 1)];
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp73_);
#line 366 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp70_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_ = self->priv->possible_in_col;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length1 = self->priv->possible_in_col_length1;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77__length2 = self->priv->possible_in_col_length2;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp78_ = col;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp79_ = previous_val;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp80_ = self->coords_for_col;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp81_ = col;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp83_ = (GeeList*) _tmp82_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp84_ = previous_val;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp85_ = sudoku_board_get_occurances (self, _tmp83_, _tmp84_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp86_ = _tmp85_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp87_ = gee_collection_get_size ((GeeCollection*) _tmp86_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp88_ = _tmp87_;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)] = _tmp88_ == 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp89_ = _tmp77_[(_tmp78_ * _tmp77__length2) + (_tmp79_ - 1)];
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp86_);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp83_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_ = self->priv->possible_in_block;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length1 = self->priv->possible_in_block_length1;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length2 = self->priv->possible_in_block_length2;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90__length3 = self->priv->possible_in_block_length3;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp91_ = row;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp92_ = self->priv->_block_cols;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp93_ = col;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp94_ = self->priv->_block_rows;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp95_ = previous_val;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp96_ = self->coords_for_block;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp97_ = row;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp98_ = self->priv->_block_rows;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp99_ = col;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp100_ = self->priv->_block_cols;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		coord_init (&_tmp101_, _tmp97_ / _tmp98_, _tmp99_ / _tmp100_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp102_ = gee_map_get (_tmp96_, &_tmp101_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp103_ = (GeeList*) _tmp102_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp104_ = previous_val;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp105_ = sudoku_board_get_occurances (self, _tmp103_, _tmp104_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp106_ = _tmp105_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp107_ = gee_collection_get_size ((GeeCollection*) _tmp106_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp108_ = _tmp107_;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)] = _tmp108_ == 0;
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp109_ = _tmp90_[((((_tmp91_ / _tmp92_) * _tmp90__length2) + (_tmp93_ / _tmp94_)) * _tmp90__length3) + (_tmp95_ - 1)];
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp106_);
#line 368 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_tmp103_);
#line 3379 "sudoku-board.c"
	} else {
		gint _tmp110_ = 0;
		gboolean* _tmp111_ = NULL;
		gint _tmp111__length1 = 0;
		gint _tmp111__length2 = 0;
		gint _tmp112_ = 0;
		gint _tmp113_ = 0;
		gboolean _tmp114_ = FALSE;
		gboolean* _tmp115_ = NULL;
		gint _tmp115__length1 = 0;
		gint _tmp115__length2 = 0;
		gint _tmp116_ = 0;
		gint _tmp117_ = 0;
		gboolean _tmp118_ = FALSE;
		gboolean* _tmp119_ = NULL;
		gint _tmp119__length1 = 0;
		gint _tmp119__length2 = 0;
		gint _tmp119__length3 = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_ = 0;
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gboolean _tmp125_ = FALSE;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp110_ = previous_val;
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		previous_val = _tmp110_ - 1;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_ = self->priv->possible_in_row;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length1 = self->priv->possible_in_row_length1;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111__length2 = self->priv->possible_in_row_length2;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp112_ = row;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp113_ = previous_val;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_] = TRUE;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp114_ = _tmp111_[(_tmp112_ * _tmp111__length2) + _tmp113_];
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_ = self->priv->possible_in_col;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length1 = self->priv->possible_in_col_length1;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115__length2 = self->priv->possible_in_col_length2;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp116_ = col;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp117_ = previous_val;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_] = TRUE;
#line 375 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp118_ = _tmp115_[(_tmp116_ * _tmp115__length2) + _tmp117_];
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_ = self->priv->possible_in_block;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length1 = self->priv->possible_in_block_length1;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length2 = self->priv->possible_in_block_length2;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119__length3 = self->priv->possible_in_block_length3;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp120_ = row;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp121_ = self->priv->_block_cols;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp122_ = col;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp123_ = self->priv->_block_rows;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp124_ = previous_val;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_] = TRUE;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp125_ = _tmp119_[((((_tmp120_ / _tmp121_) * _tmp119__length2) + (_tmp122_ / _tmp123_)) * _tmp119__length3) + _tmp124_];
#line 3458 "sudoku-board.c"
	}
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp126_ = self->priv->_filled;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_set_filled (self, _tmp126_ - 1);
#line 3464 "sudoku-board.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return self ? g_object_ref (self) : NULL;
#line 3471 "sudoku-board.c"
}


GeeSet* sudoku_board_get_occurances (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* result = NULL;
	GeeSet* occurances = NULL;
	GeeHashSet* _tmp0_ = NULL;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coords != NULL, NULL);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_set_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	occurances = (GeeSet*) _tmp0_;
#line 3487 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp1_ = NULL;
		GeeList* _tmp2_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _coord_index = 0;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = coords;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp2_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = _coord_list;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp5_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3515 "sudoku-board.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Coord coord = {0};
			GeeList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			Coord* _tmp12_ = NULL;
			Coord _tmp13_ = {0};
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp6_ + 1;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_index;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_size;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3546 "sudoku-board.c"
			}
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_list;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = _coord_index;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = gee_list_get (_tmp9_, _tmp10_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = (Coord*) _tmp11_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp13_ = *_tmp12_;
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp12_);
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp13_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3582 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = occurances;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 388 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_add ((GeeCollection*) _tmp21_, &_tmp22_);
#line 3591 "sudoku-board.c"
			}
		}
#line 385 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3596 "sudoku-board.c"
	}
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = occurances;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3602 "sudoku-board.c"
}


gboolean sudoku_board_row_contains (SudokuBoard* self, gint row, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_row;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = row;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3648 "sudoku-board.c"
}


gboolean sudoku_board_col_contains (SudokuBoard* self, gint col, gint val) {
	gboolean result = FALSE;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_col;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_list_get (_tmp0_, _tmp1_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3694 "sudoku-board.c"
}


gboolean sudoku_board_block_contains (SudokuBoard* self, Coord* block, gint val) {
	gboolean result = FALSE;
	GeeMap* _tmp0_ = NULL;
	Coord _tmp1_ = {0};
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	GeeSet* _tmp5_ = NULL;
	GeeSet* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp9_ = FALSE;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (block != NULL, FALSE);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->coords_for_block;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *block;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (GeeList*) _tmp2_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = val;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = sudoku_board_get_occurances (self, _tmp3_, _tmp4_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = _tmp5_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = _tmp7_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp9_ = _tmp8_ != 0;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp6_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (_tmp3_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp9_;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 3742 "sudoku-board.c"
}


static void sudoku_board_remove_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 3751 "sudoku-board.c"
	{
		GeeList* _coord_list = NULL;
		GeeList* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _coord_index = 0;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = coords;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_list = _tmp1_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp2_ = _coord_list;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = _tmp3_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_size = _tmp4_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_coord_index = -1;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		while (TRUE) {
#line 3779 "sudoku-board.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Coord coord = {0};
			GeeList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			Coord* _tmp11_ = NULL;
			Coord _tmp12_ = {0};
			gboolean _tmp13_ = FALSE;
			gint* _tmp14_ = NULL;
			gint _tmp14__length1 = 0;
			gint _tmp14__length2 = 0;
			Coord _tmp15_ = {0};
			gint _tmp16_ = 0;
			Coord _tmp17_ = {0};
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = _coord_index;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_index = _tmp5_ + 1;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _coord_index;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = _coord_size;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				break;
#line 3811 "sudoku-board.c"
			}
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _coord_list;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = _coord_index;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp10_ = gee_list_get (_tmp8_, _tmp9_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp11_ = (Coord*) _tmp10_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp12_ = *_tmp11_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_coord_free0 (_tmp11_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			coord = _tmp12_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14_ = self->cells;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length1 = self->cells_length1;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp14__length2 = self->cells_length2;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp15_ = coord;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp16_ = _tmp15_.row;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp17_ = coord;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp18_ = _tmp17_.col;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp19_ = _tmp14_[(_tmp16_ * _tmp14__length2) + _tmp18_];
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp20_ = val;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp19_ == _tmp20_) {
#line 3847 "sudoku-board.c"
				GeeSet* _tmp21_ = NULL;
				Coord _tmp22_ = {0};
				gboolean _tmp23_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = self->broken_coords;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp22_ = coord;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp23_ = gee_collection_contains ((GeeCollection*) _tmp21_, &_tmp22_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = _tmp23_;
#line 3859 "sudoku-board.c"
			} else {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp13_ = FALSE;
#line 3863 "sudoku-board.c"
			}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			if (_tmp13_) {
#line 3867 "sudoku-board.c"
				GeeSet* _tmp24_ = NULL;
				Coord _tmp25_ = {0};
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp24_ = self->broken_coords;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp25_ = coord;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				gee_collection_remove ((GeeCollection*) _tmp24_, &_tmp25_);
#line 3876 "sudoku-board.c"
			}
		}
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_g_object_unref0 (_coord_list);
#line 3881 "sudoku-board.c"
	}
}


static void sudoku_board_mark_breakages_for (SudokuBoard* self, GeeList* coords, gint val) {
	GeeSet* occurances = NULL;
	GeeList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GeeSet* _tmp2_ = NULL;
	GeeSet* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coords != NULL);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = coords;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = sudoku_board_get_occurances (self, _tmp0_, _tmp1_);
#line 422 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	occurances = _tmp2_;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = occurances;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_ != 1) {
#line 3914 "sudoku-board.c"
		GeeSet* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = self->broken_coords;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = occurances;
#line 425 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp7_);
#line 3923 "sudoku-board.c"
	}
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (occurances);
#line 3927 "sudoku-board.c"
}


void sudoku_board_to_initial_state (SudokuBoard* self) {
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 3934 "sudoku-board.c"
	{
		gint l1 = 0;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 3939 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 3946 "sudoku-board.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 3951 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 3957 "sudoku-board.c"
				}
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = self->priv->_rows;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < _tmp3_)) {
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 3969 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 3975 "sudoku-board.c"
					{
						gboolean _tmp4_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp4_ = TRUE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 3982 "sudoku-board.c"
							gint _tmp6_ = 0;
							gint _tmp7_ = 0;
							gboolean* _tmp8_ = NULL;
							gint _tmp8__length1 = 0;
							gint _tmp8__length2 = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							gboolean _tmp11_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp4_) {
#line 3993 "sudoku-board.c"
								gint _tmp5_ = 0;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp5_ = l2;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp5_ + 1;
#line 3999 "sudoku-board.c"
							}
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp4_ = FALSE;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = l2;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = self->priv->_cols;
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp6_ < _tmp7_)) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4011 "sudoku-board.c"
							}
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->is_fixed;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length1 = self->is_fixed_length1;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8__length2 = self->is_fixed_length2;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = l1;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp11_) {
#line 4027 "sudoku-board.c"
								gint _tmp12_ = 0;
								gint _tmp13_ = 0;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp12_ = l1;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = l2;
#line 436 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								sudoku_board_remove (self, _tmp12_, _tmp13_, FALSE);
#line 4036 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
}


void sudoku_board_print (SudokuBoard* self, gint indent) {
	FILE* _tmp22_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 4051 "sudoku-board.c"
	{
		gint l1 = 0;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4056 "sudoku-board.c"
		{
			gboolean _tmp0_ = FALSE;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = TRUE;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4063 "sudoku-board.c"
				gint _tmp2_ = 0;
				FILE* _tmp21_ = NULL;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp0_) {
#line 4068 "sudoku-board.c"
					gint _tmp1_ = 0;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp1_ = l1;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp1_ + 1;
#line 4074 "sudoku-board.c"
				}
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp0_ = FALSE;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp2_ = l1;
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp2_ < 9)) {
#line 442 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4084 "sudoku-board.c"
				}
				{
					gint i = 0;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = 0;
#line 4090 "sudoku-board.c"
					{
						gboolean _tmp3_ = FALSE;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp3_ = TRUE;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4097 "sudoku-board.c"
							gint _tmp5_ = 0;
							gint _tmp6_ = 0;
							FILE* _tmp7_ = NULL;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp3_) {
#line 4103 "sudoku-board.c"
								gint _tmp4_ = 0;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp4_ = i;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								i = _tmp4_ + 1;
#line 4109 "sudoku-board.c"
							}
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp3_ = FALSE;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = i;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp6_ = indent;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp5_ < _tmp6_)) {
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4121 "sudoku-board.c"
							}
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = stdout;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp7_, " ");
#line 4127 "sudoku-board.c"
						}
					}
				}
				{
					gint l2 = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4135 "sudoku-board.c"
					{
						gboolean _tmp8_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp8_ = TRUE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4142 "sudoku-board.c"
							gint _tmp10_ = 0;
							gint* _tmp11_ = NULL;
							gint _tmp11__length1 = 0;
							gint _tmp11__length2 = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp8_) {
#line 4152 "sudoku-board.c"
								gint _tmp9_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp9_ = l2;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp9_ + 1;
#line 4158 "sudoku-board.c"
							}
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l2;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp10_ < 9)) {
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4168 "sudoku-board.c"
							}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = self->cells;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length1 = self->cells_length1;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11__length2 = self->cells_length2;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = l1;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp14_ != 0) {
#line 4184 "sudoku-board.c"
								FILE* _tmp15_ = NULL;
								gint* _tmp16_ = NULL;
								gint _tmp16__length1 = 0;
								gint _tmp16__length2 = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = stdout;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = self->cells;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length1 = self->cells_length1;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16__length2 = self->cells_length2;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = l1;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = l2;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp15_, "%d ", _tmp19_);
#line 4208 "sudoku-board.c"
							} else {
								FILE* _tmp20_ = NULL;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = stdout;
#line 453 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp20_, "  ");
#line 4215 "sudoku-board.c"
							}
						}
					}
				}
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp21_ = stdout;
#line 455 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp21_, "\n");
#line 4224 "sudoku-board.c"
			}
		}
	}
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp22_ = stdout;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fflush (_tmp22_);
#line 4232 "sudoku-board.c"
}


void sudoku_board_get_string (SudokuBoard* self) {
	FILE* _tmp0_ = NULL;
	FILE* _tmp18_ = NULL;
#line 460 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = stdout;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp0_, "[ ");
#line 4245 "sudoku-board.c"
	{
		gint l1 = 0;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4250 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4257 "sudoku-board.c"
				gint _tmp3_ = 0;
				FILE* _tmp4_ = NULL;
				FILE* _tmp15_ = NULL;
				gint _tmp16_ = 0;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4264 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4270 "sudoku-board.c"
				}
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < 9)) {
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4280 "sudoku-board.c"
				}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = stdout;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp4_, "[ ");
#line 4286 "sudoku-board.c"
				{
					gint l2 = 0;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4291 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4298 "sudoku-board.c"
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4310 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4316 "sudoku-board.c"
							}
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < 9)) {
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4326 "sudoku-board.c"
							}
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = stdout;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							fprintf (_tmp8_, "%d", _tmp12_);
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp13_ = l2;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp13_ != 8) {
#line 4348 "sudoku-board.c"
								FILE* _tmp14_ = NULL;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = stdout;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								fprintf (_tmp14_, ",");
#line 4354 "sudoku-board.c"
							}
						}
					}
				}
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp15_ = stdout;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				fprintf (_tmp15_, " ]");
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp16_ = l1;
#line 472 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp16_ != 8) {
#line 4367 "sudoku-board.c"
					FILE* _tmp17_ = NULL;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp17_ = stdout;
#line 473 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					fprintf (_tmp17_, ",");
#line 4373 "sudoku-board.c"
				}
			}
		}
	}
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp18_ = stdout;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	fprintf (_tmp18_, " ]");
#line 4382 "sudoku-board.c"
}


gchar* sudoku_board_to_string (SudokuBoard* self, gboolean get_original_state) {
	gchar* result = NULL;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 480 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp0_;
#line 4396 "sudoku-board.c"
	{
		gint i = 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 0;
#line 4401 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4408 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4413 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 4419 "sudoku-board.c"
				}
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4431 "sudoku-board.c"
				}
				{
					gint j = 0;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					j = 0;
#line 4437 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4444 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gboolean* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gboolean _tmp12_ = FALSE;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4455 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = j;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								j = _tmp6_ + 1;
#line 4461 "sudoku-board.c"
							}
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = j;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4473 "sudoku-board.c"
							}
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->is_fixed;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->is_fixed_length1;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->is_fixed_length2;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = i;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = j;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_) {
#line 4489 "sudoku-board.c"
								const gchar* _tmp13_ = NULL;
								gint* _tmp14_ = NULL;
								gint _tmp14__length1 = 0;
								gint _tmp14__length2 = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gchar* _tmp18_ = NULL;
								gchar* _tmp19_ = NULL;
								gchar* _tmp20_ = NULL;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = board_string;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = self->cells;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length1 = self->cells_length1;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14__length2 = self->cells_length2;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = i;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp16_ = j;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = g_strdup_printf ("%i", _tmp17_);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp19_ = _tmp18_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp20_ = g_strconcat (_tmp13_, _tmp19_, NULL);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp20_;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp19_);
#line 4526 "sudoku-board.c"
							} else {
								gchar* _tmp21_ = NULL;
								gboolean _tmp22_ = FALSE;
								const gchar* _tmp29_ = NULL;
								gchar* _tmp30_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = get_original_state;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								if (_tmp22_) {
#line 4536 "sudoku-board.c"
									gchar* _tmp23_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp23_ = g_strdup ("0");
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp23_;
#line 4544 "sudoku-board.c"
								} else {
									gint* _tmp24_ = NULL;
									gint _tmp24__length1 = 0;
									gint _tmp24__length2 = 0;
									gint _tmp25_ = 0;
									gint _tmp26_ = 0;
									gint _tmp27_ = 0;
									gchar* _tmp28_ = NULL;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24_ = self->cells;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length1 = self->cells_length1;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp24__length2 = self->cells_length2;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp25_ = i;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp26_ = j;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp28_ = g_strdup_printf ("%i", _tmp27_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_g_free0 (_tmp21_);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									_tmp21_ = _tmp28_;
#line 4571 "sudoku-board.c"
								}
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp29_ = board_string;
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp30_ = g_strconcat (_tmp29_, _tmp21_, NULL);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (board_string);
#line 488 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								board_string = _tmp30_;
#line 485 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_free0 (_tmp21_);
#line 4583 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = board_string;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4595 "sudoku-board.c"
}


static gint* _vala_array_dup8 (gint* self, int length) {
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return g_memdup (self, length * sizeof (gint));
#line 4602 "sudoku-board.c"
}


gint* sudoku_board_get_cells (SudokuBoard* self, int* result_length1, int* result_length2) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->cells;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length1 = self->cells_length1;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0__length2 = self->cells_length2;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup8 (_tmp0_, _tmp0__length1 * _tmp0__length2) : ((gpointer) _tmp0_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length1 = _tmp0__length1;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1__length2 = _tmp0__length2;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length1 = _tmp1__length1;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2__length2 = _tmp1__length2;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length1) {
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length1 = _tmp2__length1;
#line 4641 "sudoku-board.c"
	}
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (result_length2) {
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		*result_length2 = _tmp2__length2;
#line 4647 "sudoku-board.c"
	}
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4653 "sudoku-board.c"
}


GeeHashMap* sudoku_board_calculate_open_squares (SudokuBoard* self) {
	GeeHashMap* result = NULL;
	GeeHashMap* possibilities = NULL;
	GeeHashMap* _tmp0_ = NULL;
#line 499 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = gee_hash_map_new (TYPE_COORD, (GBoxedCopyFunc) coord_dup, coord_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeHashDataFunc) coord_hash, NULL, NULL, (GeeEqualDataFunc) coord_equal, NULL, NULL, NULL, NULL, NULL);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	possibilities = _tmp0_;
#line 4667 "sudoku-board.c"
	{
		gint l1 = 0;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		l1 = 0;
#line 4672 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4679 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4684 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = l1;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l1 = _tmp2_ + 1;
#line 4690 "sudoku-board.c"
				}
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = l1;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = self->priv->_rows;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ < _tmp4_)) {
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4702 "sudoku-board.c"
				}
				{
					gint l2 = 0;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					l2 = 0;
#line 4708 "sudoku-board.c"
					{
						gboolean _tmp5_ = FALSE;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						_tmp5_ = TRUE;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
						while (TRUE) {
#line 4715 "sudoku-board.c"
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint* _tmp9_ = NULL;
							gint _tmp9__length1 = 0;
							gint _tmp9__length2 = 0;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!_tmp5_) {
#line 4726 "sudoku-board.c"
								gint _tmp6_ = 0;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp6_ = l2;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								l2 = _tmp6_ + 1;
#line 4732 "sudoku-board.c"
							}
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp5_ = FALSE;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp7_ = l2;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp8_ = self->priv->_cols;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (!(_tmp7_ < _tmp8_)) {
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								break;
#line 4744 "sudoku-board.c"
							}
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9_ = self->cells;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length1 = self->cells_length1;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp9__length2 = self->cells_length2;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp10_ = l1;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp11_ = l2;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							_tmp12_ = _tmp9_[(_tmp10_ * _tmp9__length2) + _tmp11_];
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
							if (_tmp12_ == 0) {
#line 4760 "sudoku-board.c"
								GeeArrayList* possArrayList = NULL;
								GeeArrayList* _tmp13_ = NULL;
								gint* possArray = NULL;
								gint _tmp14_ = 0;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint* _tmp17_ = NULL;
								gint possArray_length1 = 0;
								gint _possArray_size_ = 0;
								gint* _tmp18_ = NULL;
								gint _tmp18__length1 = 0;
								GeeHashMap* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								Coord _tmp24_ = {0};
								GeeArrayList* _tmp25_ = NULL;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp13_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArrayList = _tmp13_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp14_ = l1;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp15_ = l2;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp17_ = sudoku_board_get_possibilities (self, _tmp14_, _tmp15_, &_tmp16_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray = _tmp17_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray_length1 = _tmp16_;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_possArray_size_ = possArray_length1;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18_ = possArray;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp18__length1 = possArray_length1;
#line 4797 "sudoku-board.c"
								{
									gint* i_collection = NULL;
									gint i_collection_length1 = 0;
									gint _i_collection_size_ = 0;
									gint i_it = 0;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									i_collection = _tmp18_;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									i_collection_length1 = _tmp18__length1;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
									for (i_it = 0; i_it < _tmp18__length1; i_it = i_it + 1) {
#line 4809 "sudoku-board.c"
										gint i = 0;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
										i = i_collection[i_it];
#line 4813 "sudoku-board.c"
										{
											GeeArrayList* _tmp19_ = NULL;
											gint _tmp20_ = 0;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp19_ = possArrayList;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											_tmp20_ = i;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
											gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
#line 4823 "sudoku-board.c"
										}
									}
								}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp21_ = possibilities;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp22_ = l1;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp23_ = l2;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								coord_init (&_tmp24_, _tmp22_, _tmp23_);
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_tmp25_ = possArrayList;
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, &_tmp24_, _tmp25_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								possArray = (g_free (possArray), NULL);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
								_g_object_unref0 (possArrayList);
#line 4843 "sudoku-board.c"
							}
						}
					}
				}
			}
		}
	}
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = possibilities;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4855 "sudoku-board.c"
}


gboolean sudoku_board_is_finished (SudokuBoard* self) {
	gboolean result = FALSE;
	gchar* board_string = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* finishgame_file = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GFile* file = NULL;
	GFile* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = sudoku_board_to_string (self, TRUE);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = g_strconcat (_tmp1_, ".save", NULL);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (_tmp1_);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	board_string = _tmp3_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = sudoku_saver_get_finishgame_dir ();
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = _tmp4_;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp6_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, board_string, NULL);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	finishgame_file = _tmp6_;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp7_ = g_file_new_for_path (finishgame_file);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	file = _tmp7_;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp8_ = g_file_query_exists (file, NULL);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp8_;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (file);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (finishgame_file);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_free0 (board_string);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 4911 "sudoku-board.c"
}


gchar* sudoku_board_get_earmarks_string (SudokuBoard* self, gint row, gint col) {
	gchar* result = NULL;
	gchar* s = NULL;
	gchar* _tmp0_ = NULL;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = g_strdup ("");
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	s = _tmp0_;
#line 4925 "sudoku-board.c"
	{
		gint i = 0;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		i = 1;
#line 4930 "sudoku-board.c"
		{
			gboolean _tmp1_ = FALSE;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = TRUE;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			while (TRUE) {
#line 4937 "sudoku-board.c"
				gint _tmp3_ = 0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gboolean* _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gint _tmp6__length2 = 0;
				gint _tmp6__length3 = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!_tmp1_) {
#line 4951 "sudoku-board.c"
					gint _tmp2_ = 0;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp2_ = i;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					i = _tmp2_ + 1;
#line 4957 "sudoku-board.c"
				}
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp1_ = FALSE;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp3_ = i;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp4_ = sudoku_board_get_max_val (self);
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp5_ = _tmp4_;
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (!(_tmp3_ <= _tmp5_)) {
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					break;
#line 4971 "sudoku-board.c"
				}
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6_ = self->priv->earmarks;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length1 = self->priv->earmarks_length1;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length2 = self->priv->earmarks_length2;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp6__length3 = self->priv->earmarks_length3;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp7_ = row;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp8_ = col;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp9_ = i;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				_tmp10_ = _tmp6_[(((_tmp7_ * _tmp6__length2) + _tmp8_) * _tmp6__length3) + (_tmp9_ - 1)];
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				if (_tmp10_) {
#line 4991 "sudoku-board.c"
					const gchar* _tmp11_ = NULL;
					gint _tmp12_ = 0;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp11_ = s;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp12_ = i;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp13_ = g_strdup_printf ("%i", _tmp12_);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp14_ = _tmp13_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_tmp15_ = g_strconcat (_tmp11_, _tmp14_, NULL);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (s);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					s = _tmp15_;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
					_g_free0 (_tmp14_);
#line 5013 "sudoku-board.c"
				}
			}
		}
	}
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = s;
#line 535 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5022 "sudoku-board.c"
}


gdouble sudoku_board_get_previous_played_time (SudokuBoard* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_previous_played_time;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5037 "sudoku-board.c"
}


void sudoku_board_set_previous_played_time (SudokuBoard* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = _tmp0_;
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "previous-played-time");
#line 5051 "sudoku-board.c"
}


DifficultyCategory sudoku_board_get_difficulty_category (SudokuBoard* self) {
	DifficultyCategory result;
	DifficultyCategory _tmp0_ = 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_difficulty_category;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5066 "sudoku-board.c"
}


void sudoku_board_set_difficulty_category (SudokuBoard* self, DifficultyCategory value) {
	DifficultyCategory _tmp0_ = 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_difficulty_category = _tmp0_;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "difficulty-category");
#line 5080 "sudoku-board.c"
}


gint sudoku_board_get_block_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5095 "sudoku-board.c"
}


static void sudoku_board_set_block_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_rows = _tmp0_;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "block-rows");
#line 5109 "sudoku-board.c"
}


gint sudoku_board_get_block_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_cols;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5124 "sudoku-board.c"
}


static void sudoku_board_set_block_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_block_cols = _tmp0_;
#line 45 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "block-cols");
#line 5138 "sudoku-board.c"
}


gint sudoku_board_get_rows (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_rows;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5153 "sudoku-board.c"
}


static void sudoku_board_set_rows (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_rows = _tmp0_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "rows");
#line 5167 "sudoku-board.c"
}


gint sudoku_board_get_cols (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_cols;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5182 "sudoku-board.c"
}


static void sudoku_board_set_cols (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_cols = _tmp0_;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "cols");
#line 5196 "sudoku-board.c"
}


gint sudoku_board_get_max_val (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_block_rows;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_block_cols;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_ * _tmp1_;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5214 "sudoku-board.c"
}


gboolean sudoku_board_get_broken (SudokuBoard* self) {
	gboolean result;
	GeeSet* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->broken_coords;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp2_ != 0;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5235 "sudoku-board.c"
}


gint sudoku_board_get_filled (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_filled;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5250 "sudoku-board.c"
}


static void sudoku_board_set_filled (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_filled = _tmp0_;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "filled");
#line 5264 "sudoku-board.c"
}


gint sudoku_board_get_fixed (SudokuBoard* self) {
	gint result;
	gint _tmp0_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = self->priv->_fixed;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5279 "sudoku-board.c"
}


static void sudoku_board_set_fixed (SudokuBoard* self, gint value) {
	gint _tmp0_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = value;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_fixed = _tmp0_;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_notify ((GObject *) self, "fixed");
#line 5293 "sudoku-board.c"
}


gboolean sudoku_board_get_complete (SudokuBoard* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = self->priv->_filled;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = self->priv->_cols;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = self->priv->_rows;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp1_ == (_tmp2_ * _tmp3_)) {
#line 5313 "sudoku-board.c"
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp4_ = sudoku_board_get_broken (self);
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = _tmp4_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = !_tmp5_;
#line 5322 "sudoku-board.c"
	} else {
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5326 "sudoku-board.c"
	}
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 72 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5332 "sudoku-board.c"
}


static void sudoku_board_class_init (SudokuBoardClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	sudoku_board_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_type_class_add_private (klass, sizeof (SudokuBoardPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_board_get_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_board_set_property;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_board_finalize;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_PREVIOUS_PLAYED_TIME, g_param_spec_double ("previous-played-time", "previous-played-time", "previous-played-time", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_DIFFICULTY_CATEGORY, g_param_spec_enum ("difficulty-category", "difficulty-category", "difficulty-category", TYPE_DIFFICULTY_CATEGORY, DIFFICULTY_CATEGORY_UNKNOWN, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_ROWS, g_param_spec_int ("block-rows", "block-rows", "block-rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BLOCK_COLS, g_param_spec_int ("block-cols", "block-cols", "block-cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_ROWS, g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COLS, g_param_spec_int ("cols", "cols", "cols", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_MAX_VAL, g_param_spec_int ("max-val", "max-val", "max-val", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_BROKEN, g_param_spec_boolean ("broken", "broken", "broken", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FILLED, g_param_spec_int ("filled", "filled", "filled", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_FIXED, g_param_spec_int ("fixed", "fixed", "fixed", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_BOARD_COMPLETE, g_param_spec_boolean ("complete", "complete", "complete", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_signal_new ("completed", TYPE_SUDOKU_BOARD, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 5371 "sudoku-board.c"
}


static void sudoku_board_instance_init (SudokuBoard * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv = SUDOKU_BOARD_GET_PRIVATE (self);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_previous_played_time = (gdouble) 0;
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->_difficulty_category = DIFFICULTY_CATEGORY_UNKNOWN;
#line 5382 "sudoku-board.c"
}


static void sudoku_board_finalize (GObject* obj) {
	SudokuBoard * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 28 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->cells = (g_free (self->cells), NULL);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->is_fixed = (g_free (self->is_fixed), NULL);
#line 30 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_row = (g_free (self->priv->possible_in_row), NULL);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_col = (g_free (self->priv->possible_in_col), NULL);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->possible_in_block = (g_free (self->priv->possible_in_block), NULL);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	self->priv->earmarks = (g_free (self->priv->earmarks), NULL);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->broken_coords);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_col);
#line 89 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_row);
#line 92 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_g_object_unref0 (self->coords_for_block);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	G_OBJECT_CLASS (sudoku_board_parent_class)->finalize (obj);
#line 5412 "sudoku-board.c"
}


GType sudoku_board_get_type (void) {
	static volatile gsize sudoku_board_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_board_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuBoardClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_board_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuBoard), 0, (GInstanceInitFunc) sudoku_board_instance_init, NULL };
		GType sudoku_board_type_id;
		sudoku_board_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuBoard", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_board_type_id__volatile, sudoku_board_type_id);
	}
	return sudoku_board_type_id__volatile;
}


static void _vala_sudoku_board_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_double (value, sudoku_board_get_previous_played_time (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_enum (value, sudoku_board_get_difficulty_category (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_ROWS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_rows (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_COLS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_block_cols (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_ROWS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_rows (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COLS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_cols (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_MAX_VAL:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_max_val (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BROKEN:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_broken (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FILLED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_filled (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FIXED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_int (value, sudoku_board_get_fixed (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COMPLETE:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		g_value_set_boolean (value, sudoku_board_get_complete (self));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5499 "sudoku-board.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5505 "sudoku-board.c"
	}
}


static void _vala_sudoku_board_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuBoard * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_BOARD, SudokuBoard);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (property_id) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_PREVIOUS_PLAYED_TIME:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_previous_played_time (self, g_value_get_double (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_DIFFICULTY_CATEGORY:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_difficulty_category (self, g_value_get_enum (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_ROWS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_block_rows (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_BLOCK_COLS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_block_cols (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_ROWS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_rows (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_COLS:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_cols (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FILLED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_filled (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case SUDOKU_BOARD_FIXED:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		sudoku_board_set_fixed (self, g_value_get_int (value));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5563 "sudoku-board.c"
		default:
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		break;
#line 5569 "sudoku-board.c"
	}
}


GType house_get_type (void) {
	static volatile gsize house_type_id__volatile = 0;
	if (g_once_init_enter (&house_type_id__volatile)) {
		static const GEnumValue values[] = {{HOUSE_ROW, "HOUSE_ROW", "row"}, {HOUSE_COLUMN, "HOUSE_COLUMN", "column"}, {HOUSE_BLOCK, "HOUSE_BLOCK", "block"}, {0, NULL, NULL}};
		GType house_type_id;
		house_type_id = g_enum_register_static ("House", values);
		g_once_init_leave (&house_type_id__volatile, house_type_id);
	}
	return house_type_id__volatile;
}


void coord_init (Coord *self, gint row, gint col) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Coord));
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = row;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).row = _tmp0_;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = col;
#line 553 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).col = _tmp1_;
#line 5599 "sudoku-board.c"
}


gint coord_hash (Coord* coord) {
	gint result = 0;
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
	Coord _tmp2_ = {0};
	gint _tmp3_ = 0;
#line 556 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (coord != NULL, 0);
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.row;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = *coord;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = _tmp2_.col;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp1_ * 33) ^ _tmp3_;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5623 "sudoku-board.c"
}


gboolean coord_equal (Coord* a, Coord* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Coord _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.row;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.row;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp2_ == _tmp4_) {
#line 5648 "sudoku-board.c"
		Coord _tmp5_ = {0};
		gint _tmp6_ = 0;
		Coord _tmp7_ = {0};
		gint _tmp8_ = 0;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp5_ = *a;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = _tmp5_.col;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = *b;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = _tmp7_.col;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp6_ == _tmp8_;
#line 5663 "sudoku-board.c"
	} else {
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5667 "sudoku-board.c"
	}
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5673 "sudoku-board.c"
}


Coord* coord_dup (const Coord* self) {
	Coord* dup;
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Coord, 1);
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Coord));
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5685 "sudoku-board.c"
}


void coord_free (Coord* self) {
#line 545 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5692 "sudoku-board.c"
}


GType coord_get_type (void) {
	static volatile gsize coord_type_id__volatile = 0;
	if (g_once_init_enter (&coord_type_id__volatile)) {
		GType coord_type_id;
		coord_type_id = g_boxed_type_register_static ("Coord", (GBoxedCopyFunc) coord_dup, (GBoxedFreeFunc) coord_free);
		g_once_init_leave (&coord_type_id__volatile, coord_type_id);
	}
	return coord_type_id__volatile;
}


void cell_init (Cell *self, Coord* coord, gint val) {
	Coord _tmp0_ = {0};
	gint _tmp1_ = 0;
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_if_fail (coord != NULL);
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memset (self, 0, sizeof (Cell));
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *coord;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).coord = _tmp0_;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = val;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	(*self).val = _tmp1_;
#line 5722 "sudoku-board.c"
}


gint cell_hash (Cell* cell) {
	gint result = 0;
	Cell _tmp0_ = {0};
	Coord _tmp1_ = {0};
	gint _tmp2_ = 0;
	Cell _tmp3_ = {0};
	gint _tmp4_ = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (cell != NULL, 0);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = *cell;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_.coord;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = coord_hash (&_tmp1_);
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *cell;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.val;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = (_tmp2_ * 33) ^ _tmp4_;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5749 "sudoku-board.c"
}


gboolean cell_equal (Cell* a, Cell* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	Cell _tmp1_ = {0};
	Coord _tmp2_ = {0};
	Cell _tmp3_ = {0};
	Coord _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (a != NULL, FALSE);
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (b != NULL, FALSE);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = *a;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp2_ = _tmp1_.coord;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = *b;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp4_ = _tmp3_.coord;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp5_ = coord_equal (&_tmp2_, &_tmp4_);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp5_) {
#line 5777 "sudoku-board.c"
		Cell _tmp6_ = {0};
		gint _tmp7_ = 0;
		Cell _tmp8_ = {0};
		gint _tmp9_ = 0;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp6_ = *a;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp7_ = _tmp6_.val;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp8_ = *b;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp9_ = _tmp8_.val;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = _tmp7_ == _tmp9_;
#line 5792 "sudoku-board.c"
	} else {
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		_tmp0_ = FALSE;
#line 5796 "sudoku-board.c"
	}
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	result = _tmp0_;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return result;
#line 5802 "sudoku-board.c"
}


Cell* cell_dup (const Cell* self) {
	Cell* dup;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	dup = g_new0 (Cell, 1);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	memcpy (dup, self, sizeof (Cell));
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	return dup;
#line 5814 "sudoku-board.c"
}


void cell_free (Cell* self) {
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_free (self);
#line 5821 "sudoku-board.c"
}


GType cell_get_type (void) {
	static volatile gsize cell_type_id__volatile = 0;
	if (g_once_init_enter (&cell_type_id__volatile)) {
		GType cell_type_id;
		cell_type_id = g_boxed_type_register_static ("Cell", (GBoxedCopyFunc) cell_dup, (GBoxedFreeFunc) cell_free);
		g_once_init_leave (&cell_type_id__volatile, cell_type_id);
	}
	return cell_type_id__volatile;
}


gchar* difficulty_category_to_string (DifficultyCategory self) {
	gchar* result = NULL;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (self) {
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_UNKNOWN:
#line 5842 "sudoku-board.c"
		{
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_ = NULL;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = _ ("Unknown Difficulty");
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = g_strdup (_tmp0_);
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp1_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5854 "sudoku-board.c"
		}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_EASY:
#line 5858 "sudoku-board.c"
		{
			const gchar* _tmp2_ = NULL;
			gchar* _tmp3_ = NULL;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp2_ = _ ("Easy Puzzle");
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp3_;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5870 "sudoku-board.c"
		}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_MEDIUM:
#line 5874 "sudoku-board.c"
		{
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp4_ = _ ("Medium Difficulty");
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp5_ = g_strdup (_tmp4_);
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp5_;
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5886 "sudoku-board.c"
		}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_HARD:
#line 5890 "sudoku-board.c"
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp6_ = _ ("Hard Puzzle");
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp7_ = g_strdup (_tmp6_);
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp7_;
#line 603 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5902 "sudoku-board.c"
		}
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_VERY_HARD:
#line 5906 "sudoku-board.c"
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp8_ = _ ("Very Hard Puzzle");
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp9_ = g_strdup (_tmp8_);
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp9_;
#line 605 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5918 "sudoku-board.c"
		}
		default:
		{
#line 607 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 5924 "sudoku-board.c"
		}
	}
}


gchar* difficulty_category_to_untranslated_string (DifficultyCategory self) {
	gchar* result = NULL;
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	switch (self) {
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_UNKNOWN:
#line 5936 "sudoku-board.c"
		{
			gchar* _tmp0_ = NULL;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp0_ = g_strdup ("Unknown Difficulty");
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp0_;
#line 616 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5945 "sudoku-board.c"
		}
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_EASY:
#line 5949 "sudoku-board.c"
		{
			gchar* _tmp1_ = NULL;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp1_ = g_strdup ("Easy Difficulty");
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp1_;
#line 618 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5958 "sudoku-board.c"
		}
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_MEDIUM:
#line 5962 "sudoku-board.c"
		{
			gchar* _tmp2_ = NULL;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp2_ = g_strdup ("Medium Difficulty");
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp2_;
#line 620 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5971 "sudoku-board.c"
		}
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_HARD:
#line 5975 "sudoku-board.c"
		{
			gchar* _tmp3_ = NULL;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp3_ = g_strdup ("Hard Difficulty");
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp3_;
#line 622 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5984 "sudoku-board.c"
		}
#line 613 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		case DIFFICULTY_CATEGORY_VERY_HARD:
#line 5988 "sudoku-board.c"
		{
			gchar* _tmp4_ = NULL;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			_tmp4_ = g_strdup ("Very Hard Difficulty");
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			result = _tmp4_;
#line 624 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			return result;
#line 5997 "sudoku-board.c"
		}
		default:
		{
#line 626 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
			g_assert_not_reached ();
#line 6003 "sudoku-board.c"
		}
	}
}


DifficultyCategory difficulty_category_from_string (const gchar* input) {
	DifficultyCategory result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label0 = 0;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label1 = 0;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label2 = 0;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label3 = 0;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	static GQuark _tmp2_label4 = 0;
#line 630 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	g_return_val_if_fail (input != NULL, 0);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp0_ = input;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp1_ = _tmp0_;
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Unknown Difficulty")))) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6036 "sudoku-board.c"
			default:
			{
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_UNKNOWN;
#line 635 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6043 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Easy Difficulty")))) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6049 "sudoku-board.c"
			default:
			{
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_EASY;
#line 637 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6056 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("Medium Difficulty")))) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6062 "sudoku-board.c"
			default:
			{
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_MEDIUM;
#line 639 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6069 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("Hard Difficulty")))) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6075 "sudoku-board.c"
			default:
			{
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_HARD;
#line 641 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6082 "sudoku-board.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("Very Hard Difficulty")))) {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6088 "sudoku-board.c"
			default:
			{
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_VERY_HARD;
#line 643 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6095 "sudoku-board.c"
			}
		}
	} else {
#line 632 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
		switch (0) {
#line 6101 "sudoku-board.c"
			default:
			{
#line 645 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				g_warning ("sudoku-board.vala:645: Could not parse difficulty level. Falling back " \
"to Easy difficulty");
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				result = DIFFICULTY_CATEGORY_EASY;
#line 646 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/lib/sudoku-board.vala"
				return result;
#line 6110 "sudoku-board.c"
			}
		}
	}
}


GType difficulty_category_get_type (void) {
	static volatile gsize difficulty_category_type_id__volatile = 0;
	if (g_once_init_enter (&difficulty_category_type_id__volatile)) {
		static const GEnumValue values[] = {{DIFFICULTY_CATEGORY_UNKNOWN, "DIFFICULTY_CATEGORY_UNKNOWN", "unknown"}, {DIFFICULTY_CATEGORY_EASY, "DIFFICULTY_CATEGORY_EASY", "easy"}, {DIFFICULTY_CATEGORY_MEDIUM, "DIFFICULTY_CATEGORY_MEDIUM", "medium"}, {DIFFICULTY_CATEGORY_HARD, "DIFFICULTY_CATEGORY_HARD", "hard"}, {DIFFICULTY_CATEGORY_VERY_HARD, "DIFFICULTY_CATEGORY_VERY_HARD", "very-hard"}, {0, NULL, NULL}};
		GType difficulty_category_type_id;
		difficulty_category_type_id = g_enum_register_static ("DifficultyCategory", values);
		g_once_init_leave (&difficulty_category_type_id__volatile, difficulty_category_type_id);
	}
	return difficulty_category_type_id__volatile;
}



