/* test-equation.c generated by valac 0.32.0.13-d82f, the Vala compiler
 * generated from test-equation.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell.
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>


#define TYPE_TEST_EQUATION (test_equation_get_type ())
#define TEST_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_EQUATION, TestEquation))
#define TEST_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_EQUATION, TestEquationClass))
#define IS_TEST_EQUATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_EQUATION))
#define IS_TEST_EQUATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_EQUATION))
#define TEST_EQUATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_EQUATION, TestEquationClass))

typedef struct _TestEquation TestEquation;
typedef struct _TestEquationClass TestEquationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _TestEquationPrivate TestEquationPrivate;

struct _TestEquation {
	Equation parent_instance;
	TestEquationPrivate * priv;
};

struct _TestEquationClass {
	EquationClass parent_class;
};

struct _TestEquationPrivate {
	gboolean enable_variables;
	gboolean enable_conversions;
};


extern gint number_base;
gint number_base = 10;
extern gint wordlen;
gint wordlen = 32;
extern AngleUnit angle_units;
AngleUnit angle_units = ANGLE_UNIT_DEGREES;
extern gboolean enable_conversions;
gboolean enable_conversions = FALSE;
extern gboolean enable_variables;
gboolean enable_variables = FALSE;
extern gint fail_count;
gint fail_count = 0;
extern gint pass_count;
gint pass_count = 0;
static gpointer test_equation_parent_class = NULL;

gchar* error_code_to_string (ErrorCode _error_);
void test (const gchar* expression, const gchar* expected, ErrorCode expected_error);
GType test_equation_get_type (void) G_GNUC_CONST;
TestEquation* test_equation_new (const gchar* equation, gboolean enable_variables, gboolean enable_conversions);
TestEquation* test_equation_construct (GType object_type, const gchar* equation, gboolean enable_variables, gboolean enable_conversions);
#define TEST_EQUATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST_EQUATION, TestEquationPrivate))
enum  {
	TEST_EQUATION_DUMMY_PROPERTY
};
static gboolean test_equation_real_variable_is_defined (Equation* base, const gchar* name);
static Number* test_equation_real_get_variable (Equation* base, const gchar* name);
static Number* test_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units);
static void test_equation_finalize (GObject* obj);
void test_conversions (void);
void test_equations (void);
void test_base_conversion (void);
void test_precedence (void);
void test_custom_functions (void);
gint _vala_main (gchar** args, int args_length1);


gchar* error_code_to_string (ErrorCode _error_) {
	gchar* result = NULL;
	ErrorCode _tmp0_ = 0;
	ErrorCode _tmp4_ = 0;
	gchar* _tmp5_ = NULL;
#line 22 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = _error_;
#line 22 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (_tmp0_ == ERROR_CODE_MP) {
#line 98 "test-equation.c"
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp1_ = number_get_error ();
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp2_ = _tmp1_;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp3_ = g_strdup_printf ("ErrorCode.MP(\"%s\")", _tmp2_);
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = _tmp3_;
#line 23 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 112 "test-equation.c"
	}
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp4_ = _error_;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp5_ = mp_error_code_to_string (_tmp4_);
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	result = _tmp5_;
#line 25 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return result;
#line 122 "test-equation.c"
}


void test (const gchar* expression, const gchar* expected, ErrorCode expected_error) {
	TestEquation* equation = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	TestEquation* _tmp3_ = NULL;
	TestEquation* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	TestEquation* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	TestEquation* _tmp8_ = NULL;
	AngleUnit _tmp9_ = 0;
	ErrorCode _error_ = 0;
	guint representation_base = 0U;
	Number* _result_ = NULL;
	TestEquation* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	ErrorCode _tmp12_ = 0;
	Number* _tmp13_ = NULL;
	Number* _tmp14_ = NULL;
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_if_fail (expression != NULL);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_if_fail (expected != NULL);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = expression;
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp1_ = enable_variables;
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp2_ = enable_conversions;
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp3_ = test_equation_new (_tmp0_, _tmp1_, _tmp2_);
#line 30 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	equation = _tmp3_;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp4_ = equation;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp5_ = number_base;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((Equation*) _tmp4_)->base = _tmp5_;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp6_ = equation;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp7_ = wordlen;
#line 32 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((Equation*) _tmp6_)->wordlen = _tmp7_;
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp8_ = equation;
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp9_ = angle_units;
#line 33 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((Equation*) _tmp8_)->angle_units = _tmp9_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp10_ = equation;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp13_ = equation_parse ((Equation*) _tmp10_, &_tmp11_, &_tmp12_, NULL, NULL, NULL);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	representation_base = _tmp11_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_error_ = _tmp12_;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_result_ = _tmp13_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp14_ = _result_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (_tmp14_ == NULL) {
#line 192 "test-equation.c"
		ErrorCode _tmp15_ = 0;
		ErrorCode _tmp16_ = 0;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp15_ = _error_;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp16_ = expected_error;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		if (_tmp15_ == _tmp16_) {
#line 201 "test-equation.c"
			gint _tmp17_ = 0;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp17_ = pass_count;
#line 44 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			pass_count = _tmp17_ + 1;
#line 207 "test-equation.c"
		} else {
			ErrorCode _tmp18_ = 0;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp18_ = expected_error;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			if (_tmp18_ == ERROR_CODE_NONE) {
#line 214 "test-equation.c"
				FILE* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				ErrorCode _tmp21_ = 0;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				gint _tmp25_ = 0;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp19_ = stdout;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp20_ = expression;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp21_ = _error_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp22_ = error_code_to_string (_tmp21_);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp23_ = _tmp22_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp24_ = expected;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fprintf (_tmp19_, "*FAIL: '%s' -> error %s, expected result %s\n", _tmp20_, _tmp23_, _tmp24_);
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_g_free0 (_tmp23_);
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp25_ = fail_count;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fail_count = _tmp25_ + 1;
#line 242 "test-equation.c"
			} else {
				FILE* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				ErrorCode _tmp28_ = 0;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				ErrorCode _tmp31_ = 0;
				gchar* _tmp32_ = NULL;
				gchar* _tmp33_ = NULL;
				gint _tmp34_ = 0;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp26_ = stdout;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp27_ = expression;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp28_ = _error_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp29_ = error_code_to_string (_tmp28_);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp30_ = _tmp29_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp31_ = expected_error;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp32_ = error_code_to_string (_tmp31_);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp33_ = _tmp32_;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fprintf (_tmp26_, "*FAIL: '%s' -> error %s, expected error %s\n", _tmp27_, _tmp30_, _tmp33_);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_g_free0 (_tmp33_);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_g_free0 (_tmp30_);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp34_ = fail_count;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fail_count = _tmp34_ + 1;
#line 279 "test-equation.c"
			}
		}
	} else {
		Serializer* serializer = NULL;
		gint _tmp35_ = 0;
		Serializer* _tmp36_ = NULL;
		Serializer* _tmp37_ = NULL;
		guint _tmp38_ = 0U;
		gchar* result_str = NULL;
		Serializer* _tmp39_ = NULL;
		Number* _tmp40_ = NULL;
		gchar* _tmp41_ = NULL;
		ErrorCode _tmp42_ = 0;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp35_ = number_base;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp36_ = serializer_new (DISPLAY_FORMAT_FIXED, _tmp35_, 9);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		serializer = _tmp36_;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp37_ = serializer;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp38_ = representation_base;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		serializer_set_representation_base (_tmp37_, _tmp38_);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp39_ = serializer;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp40_ = _result_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp41_ = serializer_to_string (_tmp39_, _tmp40_);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result_str = _tmp41_;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp42_ = expected_error;
#line 63 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		if (_tmp42_ != ERROR_CODE_NONE) {
#line 317 "test-equation.c"
			FILE* _tmp43_ = NULL;
			const gchar* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			ErrorCode _tmp46_ = 0;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gint _tmp49_ = 0;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp43_ = stdout;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp44_ = expression;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp45_ = result_str;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp46_ = expected_error;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp47_ = error_code_to_string (_tmp46_);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp48_ = _tmp47_;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			fprintf (_tmp43_, "*FAIL: '%s' -> %s, expected error %s\n", _tmp44_, _tmp45_, _tmp48_);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_g_free0 (_tmp48_);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp49_ = fail_count;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			fail_count = _tmp49_ + 1;
#line 345 "test-equation.c"
		} else {
			const gchar* _tmp50_ = NULL;
			const gchar* _tmp51_ = NULL;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp50_ = result_str;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			_tmp51_ = expected;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
			if (g_strcmp0 (_tmp50_, _tmp51_) != 0) {
#line 355 "test-equation.c"
				FILE* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				const gchar* _tmp54_ = NULL;
				const gchar* _tmp55_ = NULL;
				gint _tmp56_ = 0;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp52_ = stdout;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp53_ = expression;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp54_ = result_str;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp55_ = expected;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fprintf (_tmp52_, "*FAIL: '%s' -> '%s', expected '%s'\n", _tmp53_, _tmp54_, _tmp55_);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp56_ = fail_count;
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				fail_count = _tmp56_ + 1;
#line 375 "test-equation.c"
			} else {
				gint _tmp57_ = 0;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				_tmp57_ = pass_count;
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
				pass_count = _tmp57_ + 1;
#line 382 "test-equation.c"
			}
		}
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_g_free0 (result_str);
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_g_object_unref0 (serializer);
#line 389 "test-equation.c"
	}
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_g_object_unref0 (_result_);
#line 28 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_g_object_unref0 (equation);
#line 395 "test-equation.c"
}


TestEquation* test_equation_construct (GType object_type, const gchar* equation, gboolean enable_variables, gboolean enable_conversions) {
	TestEquation * self = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (equation != NULL, NULL);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = equation;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self = (TestEquation*) equation_construct (object_type, _tmp0_);
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp1_ = enable_variables;
#line 89 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self->priv->enable_variables = _tmp1_;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp2_ = enable_conversions;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self->priv->enable_conversions = _tmp2_;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return self;
#line 420 "test-equation.c"
}


TestEquation* test_equation_new (const gchar* equation, gboolean enable_variables, gboolean enable_conversions) {
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return test_equation_construct (TYPE_TEST_EQUATION, equation, enable_variables, enable_conversions);
#line 427 "test-equation.c"
}


static gboolean test_equation_real_variable_is_defined (Equation* base, const gchar* name) {
	TestEquation * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self = (TestEquation*) base;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = self->priv->enable_variables;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (!_tmp0_) {
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = FALSE;
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 449 "test-equation.c"
	}
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp2_ = name;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (g_strcmp0 (_tmp2_, "x") == 0) {
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp1_ = TRUE;
#line 457 "test-equation.c"
	} else {
		const gchar* _tmp3_ = NULL;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp3_ = name;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, "y") == 0;
#line 464 "test-equation.c"
	}
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	result = _tmp1_;
#line 98 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return result;
#line 470 "test-equation.c"
}


static Number* test_equation_real_get_variable (Equation* base, const gchar* name) {
	TestEquation * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self = (TestEquation*) base;
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = self->priv->enable_variables;
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (!_tmp0_) {
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = NULL;
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 492 "test-equation.c"
	}
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp1_ = name;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (g_strcmp0 (_tmp1_, "x") == 0) {
#line 498 "test-equation.c"
		Number* _tmp2_ = NULL;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp2_ = number_new_integer ((gint64) 2);
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = _tmp2_;
#line 107 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 506 "test-equation.c"
	}
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp3_ = name;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (g_strcmp0 (_tmp3_, "y") == 0) {
#line 512 "test-equation.c"
		Number* _tmp4_ = NULL;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp4_ = number_new_integer ((gint64) 3);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = _tmp4_;
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 520 "test-equation.c"
	}
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	result = NULL;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return result;
#line 526 "test-equation.c"
}


static Number* test_equation_real_convert (Equation* base, Number* x, const gchar* x_units, const gchar* z_units) {
	TestEquation * self;
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	UnitManager* _tmp1_ = NULL;
	UnitManager* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	Number* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self = (TestEquation*) base;
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (x != NULL, NULL);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (x_units != NULL, NULL);
#line 114 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_return_val_if_fail (z_units != NULL, NULL);
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = self->priv->enable_conversions;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (!_tmp0_) {
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		result = NULL;
#line 117 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		return result;
#line 557 "test-equation.c"
	}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp1_ = unit_manager_get_default ();
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp2_ = _tmp1_;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp3_ = x;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp4_ = x_units;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp5_ = z_units;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp6_ = unit_manager_convert_by_symbol (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp7_ = _tmp6_;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_g_object_unref0 (_tmp2_);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	result = _tmp7_;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return result;
#line 579 "test-equation.c"
}


static void test_equation_class_init (TestEquationClass * klass) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_equation_parent_class = g_type_class_peek_parent (klass);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	g_type_class_add_private (klass, sizeof (TestEquationPrivate));
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((EquationClass *) klass)->variable_is_defined = test_equation_real_variable_is_defined;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((EquationClass *) klass)->get_variable = test_equation_real_get_variable;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	((EquationClass *) klass)->convert = test_equation_real_convert;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	G_OBJECT_CLASS (klass)->finalize = test_equation_finalize;
#line 596 "test-equation.c"
}


static void test_equation_instance_init (TestEquation * self) {
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self->priv = TEST_EQUATION_GET_PRIVATE (self);
#line 603 "test-equation.c"
}


static void test_equation_finalize (GObject* obj) {
	TestEquation * self;
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TEST_EQUATION, TestEquation);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	G_OBJECT_CLASS (test_equation_parent_class)->finalize (obj);
#line 613 "test-equation.c"
}


GType test_equation_get_type (void) {
	static volatile gsize test_equation_type_id__volatile = 0;
	if (g_once_init_enter (&test_equation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TestEquationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_equation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TestEquation), 0, (GInstanceInitFunc) test_equation_instance_init, NULL };
		GType test_equation_type_id;
		test_equation_type_id = g_type_register_static (TYPE_EQUATION, "TestEquation", &g_define_type_info, 0);
		g_once_init_leave (&test_equation_type_id__volatile, test_equation_type_id);
	}
	return test_equation_type_id__volatile;
}


void test_conversions (void) {
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 32;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_conversions = TRUE;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_variables = FALSE;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100 gradians in degrees", "90", 0);
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 meter in mm", "1000", 0);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1m in mm", "1000", 0);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 inch in cm", "2.54", 0);
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1m² in mm²", "1000000", 0);
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1m³ in mm³", "1000000000", 0);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 kg in pounds", "2.204622622", 0);
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 minute in seconds", "60", 0);
#line 151 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1s in ms", "1000", 0);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100degC in degF", "212", 0);
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0degC in degF", "32", 0);
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 K in degC", "−273.15", 0);
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000 bits in bytes", "125", 0);
#line 163 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000 bits in nibbles", "250", 0);
#line 164 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000 bytes in kilobytes", "1", 0);
#line 165 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 kB in bits", "8000", 0);
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 kB in B", "10000", 0);
#line 167 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 GB in MB", "1000", 0);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100 MB in kilobytes", "100000", 0);
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10000 MB in GB", "10", 0);
#line 170 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000 GB in petabytes", "0.001", 0);
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 GB in MiB", "953.674316406", 0);
#line 172 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 mebibit in B", "131072", 0);
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 kibibytes in b", "81920", 0);
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000 GiB in tebibytes", "0.9765625", 0);
#line 175 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100 MiB in Gib", "0.78125", 0);
#line 176 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 TiB in MiB", "10485760", 0);
#line 177 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 pebibytes in TiB", "10240", 0);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 exbibytes in PiB", "10240", 0);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 zebibytes in EiB", "10240", 0);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 yobibytes in ZiB", "10240", 0);
#line 702 "test-equation.c"
}


void test_equations (void) {
#line 186 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 187 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 32;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_conversions = FALSE;
#line 190 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_variables = TRUE;
#line 192 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 2;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2₁₀", "10", 0);
#line 195 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 8;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("16434824₁₀", "76543210", 0);
#line 198 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 16;
#line 199 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("FF", "FF", 0);
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("18364758544493064720₁₀", "FEDCBA9876543210", 0);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0₂", "0", 0);
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0₈", "0", 0);
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0", "0", 0);
#line 203 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0₁₆", "0", 0);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1₂", "1", 0);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1₈", "1", 0);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1", "1", 0);
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1₁₆", "1", 0);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2₂", "", ERROR_CODE_INVALID);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2₈", "2", 0);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2", "2", 0);
#line 205 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2₁₆", "2", 0);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3₂", "", ERROR_CODE_INVALID);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3₈", "3", 0);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3", "3", 0);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3₁₆", "3", 0);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4₂", "", ERROR_CODE_INVALID);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4₈", "4", 0);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4", "4", 0);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4₁₆", "4", 0);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5₂", "", ERROR_CODE_INVALID);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5₈", "5", 0);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5", "5", 0);
#line 208 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5₁₆", "5", 0);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6₂", "", ERROR_CODE_INVALID);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6₈", "6", 0);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6", "6", 0);
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6₁₆", "6", 0);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("7₂", "", ERROR_CODE_INVALID);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("7₈", "7", 0);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("7", "7", 0);
#line 210 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("7₁₆", "7", 0);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("8₂", "", ERROR_CODE_INVALID);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("8₈", "", ERROR_CODE_INVALID);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("8", "8", 0);
#line 211 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("8₁₆", "8", 0);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("9₂", "", ERROR_CODE_INVALID);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("9₈", "", ERROR_CODE_INVALID);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("9", "9", 0);
#line 212 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("9₁₆", "9", 0);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("A₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("A₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("A", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("A₁₆", "10", 0);
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("B₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("B₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("B", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 214 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("B₁₆", "11", 0);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("C₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("C₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("C", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("C₁₆", "12", 0);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("D₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("D₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("D", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("D₁₆", "13", 0);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("E₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("E₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("E", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("E₁₆", "14", 0);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("F₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("F₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("F", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 218 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("F₁₆", "15", 0);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("a₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("a₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("a", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("a₁₆", "10", 0);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("b₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("b₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("b", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("b₁₆", "11", 0);
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("c₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("c₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("c", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 221 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("c₁₆", "12", 0);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("d₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("d₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("d", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 222 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("d₁₆", "13", 0);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e₁₆", "14", 0);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("f₂", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("f₈", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("f", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("f₁₆", "15", 0);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("+1", "1", 0);
#line 227 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−1", "−1", 0);
#line 228 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("+ 1", "1", 0);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("− 1", "−1", 0);
#line 230 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("++1", "1", ERROR_CODE_INVALID);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−−1", "1", 0);
#line 232 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("255", "255", 0);
#line 233 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("256", "256", 0);
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("½", "0.5", 0);
#line 235 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1½", "1.5", 0);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0°", "0", 0);
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1°", "1", 0);
#line 238 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0°30'", "0.5", 0);
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0°0'1\"", "0.000277778", 0);
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0°0'0.1\"", "0.000027778", 0);
#line 242 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1.00", "1", 0);
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1.01", "1.01", 0);
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("١٢٣٤٥٦٧٨٩٠", "1234567890", 0);
#line 246 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("۱۲۳۴۵۶۷۸۹۰", "1234567890", 0);
#line 279 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2×10^3", "2000", 0);
#line 280 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2×10^−3", "0.002", 0);
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x", "2", 0);
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("y", "3", 0);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("z", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 285 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2y", "6", 0);
#line 286 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("y2", "", ERROR_CODE_INVALID);
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("y 2", "", ERROR_CODE_INVALID);
#line 288 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2z", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("z2", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("z 2", "", ERROR_CODE_UNKNOWN_VARIABLE);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("z(2)", "", ERROR_CODE_UNKNOWN_FUNCTION);
#line 292 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("y²", "9", 0);
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2y²", "18", 0);
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x×y", "6", 0);
#line 295 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("xy", "6", 0);
#line 296 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("yx", "6", 0);
#line 297 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2xy", "12", 0);
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x²y", "12", 0);
#line 299 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("xy²", "18", 0);
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(xy)²", "36", 0);
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2x²y", "24", 0);
#line 302 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2xy²", "36", 0);
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2x²y²", "72", 0);
#line 304 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x²yx²y", "144", 0);
#line 305 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x³+2x²−5", "11", 0);
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2(x+3y)", "22", 0);
#line 307 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x(x+3y)", "22", 0);
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(x+3y)(2x-4y)", "−88", 0);
#line 309 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2x²+2xy−12y²", "−88", 0);
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("π", "3.141592654", 0);
#line 312 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e", "2.718281828", 0);
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("z=99", "99", 0);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("longname=99", "99", 0);
#line 318 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0+0", "0", 0);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1+1", "2", 0);
#line 320 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1+4", "5", 0);
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4+1", "5", 0);
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("40000+0.001", "40000.001", 0);
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0.001+40000", "40000.001", 0);
#line 324 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2-3", "−1", 0);
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2−3", "−1", 0);
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3−2", "1", 0);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("40000−0.001", "39999.999", 0);
#line 328 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0.001−40000", "−39999.999", 0);
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2*3", "6", 0);
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2×3", "6", 0);
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−2×3", "−6", 0);
#line 332 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2×−3", "−6", 0);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−2×−3", "6", 0);
#line 334 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6/3", "2", 0);
#line 335 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6÷3", "2", 0);
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1÷2", "0.5", 0);
#line 337 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−6÷3", "−2", 0);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6÷−3", "−2", 0);
#line 339 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−6÷−3", "2", 0);
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−3)÷(−6)", "0.5", 0);
#line 341 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2÷2", "1", 0);
#line 342 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1203÷1", "1203", 0);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−0÷32352.689", "0", 0);
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1÷4", "0.25", 0);
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1÷3", "0.333333333", 0);
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2÷3", "0.666666667", 0);
#line 347 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1÷0", "", ERROR_CODE_MP);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0÷0", "", ERROR_CODE_MP);
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000000000000000−1000000000000000", "0", 0);
#line 352 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000000000000000÷1000000000000000", "1", 0);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1000000000000000×0.000000000000001", "1", 0);
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1−0.9−0.1", "0", 0);
#line 357 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1+2×3", "7", 0);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1+(2×3)", "7", 0);
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(1+2)×3", "9", 0);
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(1+2×3)", "7", 0);
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2(1+1)", "4", 0);
#line 362 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4÷2(1+1)", "4", 0);
#line 365 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100%", "1", 0);
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1%", "0.01", 0);
#line 367 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100+1%", "101", 0);
#line 368 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100−1%", "99", 0);
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100×1%", "1", 0);
#line 370 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100÷1%", "10000", 0);
#line 373 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0!", "1", 0);
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1!", "1", 0);
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5!", "120", 0);
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("69!", "1711224524281413113724683388812728390922705448935203693936480409232572" \
"79754140647424000000000000000", 0);
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−1!", "−1", 0);
#line 378 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−1)!", "", ERROR_CODE_MP);
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−(1!)", "−1", 0);
#line 380 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3.5!", "11.631728397", 0);
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(-2)!", "", ERROR_CODE_MP);
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(-10.9)!", "", ERROR_CODE_MP);
#line 384 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(-10.0)!", "", ERROR_CODE_MP);
#line 387 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2²", "4", 0);
#line 388 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2³", "8", 0);
#line 389 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2¹⁰", "1024", 0);
#line 390 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(1+2)²", "9", 0);
#line 391 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(x)²", "4", 0);
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|1−3|²", "4", 0);
#line 393 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|x|²", "4", 0);
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0^0", "0", ERROR_CODE_MP);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0^0.5", "0", 0);
#line 397 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^0", "1", 0);
#line 398 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^1", "2", 0);
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^2", "4", 0);
#line 400 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2⁻¹", "0.5", 0);
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2⁻", "", ERROR_CODE_MP);
#line 402 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^−1", "0.5", 0);
#line 403 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^(−1)", "0.5", 0);
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x⁻¹", "0.5", 0);
#line 405 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−10^2", "−100", 0);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−10)^2", "100", 0);
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−(10^2)", "−100", 0);
#line 408 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^100", "1267650600228229401496703205376", 0);
#line 409 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4^3^2", "262144", 0);
#line 410 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4^(3^2)", "262144", 0);
#line 411 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(4^3)^2", "4096", 0);
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√4", "2", 0);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√4−2", "0", 0);
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("∛8", "2", 0);
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("∜16", "2", 0);
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("₃√8", "2", 0);
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("₁₀√1024", "2", 0);
#line 418 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√(2+2)", "2", 0);
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2√4", "4", 0);
#line 420 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2×√4", "4", 0);
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("Sqrt (4)", "2", 0);
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("Sqrt (2)", "1.414213562", 0);
#line 423 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("Sqrt (-1)", "i", 0);
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4^0.5", "2", 0);
#line 425 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2^0.5", "1.414213562", 0);
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("₃√−8", "−2", 0);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−8)^(1÷3)", "−2", 0);
#line 428 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e^(−0.5)", "0.60653066", 0);
#line 430 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 mod 7", "0", 0);
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6 mod 7", "6", 0);
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("7 mod 7", "0", 0);
#line 433 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("8 mod 7", "1", 0);
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−1 mod 7", "6", 0);
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("21 mod 9", "3", 0);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("21 mod -9", "−6", 0);
#line 438 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("-21 mod 9", "6", 0);
#line 439 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("-21 mod -9", "−3", 0);
#line 441 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sgn 0", "0", 0);
#line 442 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sgn 3", "1", 0);
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sgn −3", "−1", 0);
#line 444 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊3⌋", "3", 0);
#line 445 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈3⌉", "3", 0);
#line 446 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[3]", "3", 0);
#line 447 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊−3⌋", "−3", 0);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈−3⌉", "−3", 0);
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[−3]", "−3", 0);
#line 450 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊3.2⌋", "3", 0);
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈3.2⌉", "4", 0);
#line 452 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[3.2]", "3", 0);
#line 453 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊−3.2⌋", "−4", 0);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈−3.2⌉", "−3", 0);
#line 455 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[−3.2]", "−3", 0);
#line 456 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊3.5⌋", "3", 0);
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈3.5⌉", "4", 0);
#line 458 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[3.5]", "4", 0);
#line 459 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊−3.5⌋", "−4", 0);
#line 460 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈−3.5⌉", "−3", 0);
#line 461 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[−3.5]", "−4", 0);
#line 462 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊3.7⌋", "3", 0);
#line 463 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈3.7⌉", "4", 0);
#line 464 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[3.7]", "4", 0);
#line 465 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌊−3.7⌋", "−4", 0);
#line 466 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("⌈−3.7⌉", "−3", 0);
#line 467 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("[−3.7]", "−4", 0);
#line 468 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("{3.2}", "0.2", 0);
#line 469 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("{−3.2}", "0.8", 0);
#line 471 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|1|", "1", 0);
#line 472 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|−1|", "1", 0);
#line 473 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|3−5|", "2", 0);
#line 474 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|x|", "2", 0);
#line 475 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("abs 1", "1", 0);
#line 476 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("abs (−1)", "1", 0);
#line 478 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log 0", "", ERROR_CODE_MP);
#line 479 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log 1", "0", 0);
#line 480 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log 2", "0.301029996", 0);
#line 481 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log 10", "1", 0);
#line 482 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log₁₀ 10", "1", 0);
#line 483 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log₂ 2", "1", 0);
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2 log 2", "0.602059991", 0);
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ln 0", "", ERROR_CODE_MP);
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ln 1", "0", 0);
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ln 2", "0.693147181", 0);
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ln e", "1", 0);
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2 ln 2", "1.386294361", 0);
#line 492 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 0", "0", 0);
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 45 − 1÷√2", "0", 0);
#line 495 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 20 + sin(−20)", "0", 0);
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 90", "1", 0);
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 180", "0", 0);
#line 498 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2 sin 90", "2", 0);
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin²45", "0.5", 0);
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 0", "1", 0);
#line 502 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 45 − 1÷√2", "0", 0);
#line 503 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 20 − cos (−20)", "0", 0);
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 90", "0", 0);
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 180", "−1", 0);
#line 506 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2 cos 0", "2", 0);
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos²45", "0.5", 0);
#line 509 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tan 0", "0", 0);
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tan 10 − sin 10÷cos 10", "0", 0);
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tan 90", "", ERROR_CODE_MP);
#line 512 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tan 10", "0.176326981", 0);
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tan²10", "0.031091204", 0);
#line 515 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos⁻¹ 0", "90", 0);
#line 516 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos⁻¹ 1", "0", 0);
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos⁻¹ (−1)", "180", 0);
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos⁻¹ (1÷√2)", "45", 0);
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("acos 0", "90", 0);
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("acos 1", "0", 0);
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin⁻¹ 0", "0", 0);
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin⁻¹ 1", "90", 0);
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin⁻¹ (−1)", "−90", 0);
#line 525 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin⁻¹ (1÷√2)", "45", 0);
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("asin 0", "0", 0);
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("asin 1", "90", 0);
#line 529 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cosh 0", "1", 0);
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cosh 10 − (e^10 + e^−10)÷2", "0", 0);
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sinh 0", "0", 0);
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sinh 10 − (e^10 − e^−10)÷2", "0", 0);
#line 534 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sinh (−10) + sinh 10", "0", 0);
#line 536 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cosh² (−5) − sinh² (−5)", "1", 0);
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tanh 0", "0", 0);
#line 538 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("tanh 10 − sinh 10 ÷ cosh 10", "0", 0);
#line 540 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("atanh 0", "0", 0);
#line 541 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("atanh (1÷10) − 0.5 ln(11÷9)", "0", 0);
#line 543 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 544 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 90", "1", 0);
#line 546 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_RADIANS;
#line 547 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin (π÷2)", "1", 0);
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_GRADIANS;
#line 550 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 100", "1", 0);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i", "i", 0);
#line 555 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("−i", "−i", 0);
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("2i", "2i", 0);
#line 557 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1+i", "1+i", 0);
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i+1", "1+i", 0);
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1−i", "1−i", 0);
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i−1", "−1+i", 0);
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i×i", "−1", 0);
#line 562 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i÷i", "1", 0);
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1÷i", "−i", 0);
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i^2", "−1", 0);
#line 565 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−1)^(1/2)", "i", 0);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|i|", "1", 0);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("|3+4i|", "5", 0);
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg 0", "", ERROR_CODE_MP);
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg 1", "0", 0);
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg (1+i)", "45", 0);
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg i", "90", 0);
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg (−1+i)", "135", 0);
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg −1", "180", 0);
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg (1+−i)", "−45", 0);
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg −i", "−90", 0);
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("arg (−1−i)", "−135", 0);
#line 577 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("i⁻¹", "−i", 0);
#line 578 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√−1", "i", 0);
#line 579 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−1)^0.5", "i", 0);
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√−4", "2i", 0);
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("e^iπ", "−1", 0);
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log (−10) − (1 + πi÷ln(10))", "0", 0);
#line 583 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ln (−e) − (1 + πi)", "0", 0);
#line 584 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin(iπ÷4) − i×sinh(π÷4)", "0", 0);
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos(iπ÷4) − cosh(π÷4)", "0", 0);
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 and 0", "0", 0);
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 and 0", "0", 0);
#line 590 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 and 1", "0", 0);
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 and 1", "1", 0);
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3 and 5", "1", 0);
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 or 0", "0", 0);
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 or 0", "1", 0);
#line 596 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 or 1", "1", 0);
#line 597 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 or 1", "1", 0);
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3 or 5", "7", 0);
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 xor 0", "0", 0);
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 xor 0", "1", 0);
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("0 xor 1", "1", 0);
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 xor 1", "0", 0);
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3 xor 5", "6", 0);
#line 606 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 16;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ones 1", "FFFFFFFE", 0);
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("ones 7FFFFFFF", "80000000", 0);
#line 609 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("twos 1", "FFFFFFFF", 0);
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("twos 7FFFFFFF", "80000001", 0);
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("~7A₁₆", "FFFFFF85", 0);
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 2;
#line 614 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 4;
#line 615 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1100∧1010", "1000", 0);
#line 616 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1100∨1010", "1110", 0);
#line 617 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1100⊻1010", "110", 0);
#line 618 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1100⊕1010", "110", 0);
#line 1539 "test-equation.c"
}


void test_base_conversion (void) {
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 32;
#line 630 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 631 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_conversions = TRUE;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_variables = TRUE;
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in bin", "1010₂", 0);
#line 635 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in oct", "12₈", 0);
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in dec", "10", 0);
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in hex", "A₁₆", 0);
#line 638 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in binary", "1010₂", 0);
#line 639 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in octal", "12₈", 0);
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in decimal", "10", 0);
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in hexadecimal", "A₁₆", 0);
#line 643 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1010₂ in dec", "10", 0);
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("12₈ in dec", "10", 0);
#line 645 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 in dec", "10", 0);
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("A₁₆ in dec", "10", 0);
#line 648 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x in bin", "10₂", 0);
#line 649 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x in oct", "2₈", 0);
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x in dec", "2", 0);
#line 651 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("x in hex", "2₁₆", 0);
#line 1586 "test-equation.c"
}


void test_precedence (void) {
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 657 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 32;
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 659 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_conversions = TRUE;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_variables = TRUE;
#line 662 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("1 + 2 - 3 * 4 / 5", "0.6", 0);
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 mod 4 / 2", "1", 0);
#line 664 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("20 / 10 mod 3", "2", 0);
#line 665 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("12 / 3 √4", "8", 0);
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("√5!", "10.95445115", 0);
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4 ^ sin 30", "2", 0);
#line 668 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4 ^ (sin 30)", "2", 0);
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4 ^ sin (30)", "2", 0);
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin (30) ^ 4", "0.0625", 0);
#line 671 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 30 ^ 4", "0.0625", 0);
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin (30 ^ 4)", "0", 0);
#line 674 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 / - 2", "−5", 0);
#line 675 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 * - 2", "−20", 0);
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("10 ^ -2", "0.01", 0);
#line 677 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("-10 ^ 2", "−100", 0);
#line 678 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin (-30)", "−0.5", 0);
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin - 30", "−0.5", 0);
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6 + 3!", "12", 0);
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4 * 3!", "24", 0);
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("100 mod 3!", "4", 0);
#line 684 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("5! mod 7", "1", 0);
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("24 / 3!", "4", 0);
#line 686 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("4! / 6", "4", 0);
#line 687 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("cos 5!", "−0.5", 0);
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sin 6!", "0", 0);
#line 689 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("- 4!", "−24", 0);
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3! ^ 3", "216", 0);
#line 691 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("3 ^ 3!", "729", 0);
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(−√3)^2", "3", 0);
#line 1659 "test-equation.c"
}


void test_custom_functions (void) {
	FunctionManager* function_manager = NULL;
	FunctionManager* _tmp0_ = NULL;
#line 697 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	number_base = 10;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	wordlen = 32;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	angle_units = ANGLE_UNIT_DEGREES;
#line 700 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_conversions = FALSE;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	enable_variables = TRUE;
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = function_manager_get_default_function_manager ();
#line 703 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager = _tmp0_;
#line 704 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(x;y;z)=x+y+z", "0", 0);
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(2;3;5)", "10", 0);
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(x;y;z)=x+y-z", "0", 0);
#line 707 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(2;3;5)", "0", 0);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(x;y;z)=abs(x-y)+abs(y-z)+abs(x-z)", "0", 0);
#line 709 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(1;2;3)", "4", 0);
#line 710 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("func(x;y;z)", "0", ERROR_CODE_INVALID);
#line 711 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("test(x;y)=func(x;y;x)+func(y;x;y)", "0", 0);
#line 712 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("6*test(3;5)+log10", "49", 0);
#line 713 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("test(test(5;6);9)", "20", 0);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log(test(8;9))", "0.602059991", 0);
#line 715 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(8)", "0", ERROR_CODE_UNKNOWN_FUNCTION);
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum", "0", ERROR_CODE_UNKNOWN_VARIABLE);
#line 717 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(x;y)=x+y", "0", 0);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("(3+2)*10 + 5^2 - sum(7;8)", "60", 0);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(abc;xyz;pqr)=abc*xyz*pqr", "0", 0);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(1;0;1)", "0", 0);
#line 721 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(4;5;6)", "120", 0);
#line 722 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(dummy(1;2;3);dummy(1;2;3);dummy(1;2;3))", "216", 0);
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(10;5.687;100)", "5687", 0);
#line 724 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("dummy(10;5.687;1)", "56.87", 0);
#line 725 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("diff(x,y)=x-y", "0", ERROR_CODE_INVALID);
#line 726 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("abcd(x;y;z) = (floor((x+y+z)/z)+frac((x+y+z)/z))*z", "0", 0);
#line 727 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("abcd(4;5;6)", "15", 0);
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("abcd(2.9;91;9.1)", "103", 0);
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("log(dummy(1;5;2))", "1", 0);
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "8", 0);
#line 731 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "sum");
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "8", ERROR_CODE_UNKNOWN_FUNCTION);
#line 733 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(x;y)=x+y+1", "0", 0);
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test ("sum(sum(sum(1;1);sum(1;1));sum(sum(1;1);sum(1;1)))", "15", 0);
#line 736 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "func");
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "test");
#line 738 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "sum");
#line 739 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "dummy");
#line 740 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	function_manager_delete (function_manager, "abcd");
#line 695 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_g_object_unref0 (function_manager);
#line 1754 "test-equation.c"
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp7_ = 0;
#line 745 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	setlocale (LC_ALL, "C");
#line 747 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_conversions ();
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_equations ();
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_base_conversion ();
#line 750 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_precedence ();
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	test_custom_functions ();
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp0_ = fail_count;
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	if (_tmp0_ == 0) {
#line 1778 "test-equation.c"
		FILE* _tmp1_ = NULL;
		gint _tmp2_ = 0;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp1_ = stdout;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp2_ = pass_count;
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		fprintf (_tmp1_, "Passed all %i tests\n", _tmp2_);
#line 1787 "test-equation.c"
	} else {
		FILE* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp3_ = stdout;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp4_ = fail_count;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp5_ = pass_count;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		_tmp6_ = fail_count;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
		fprintf (_tmp3_, "Failed %i/%d tests\n", _tmp4_, _tmp5_ + _tmp6_);
#line 1803 "test-equation.c"
	}
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	_tmp7_ = fail_count;
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	result = _tmp7_;
#line 758 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return result;
#line 1811 "test-equation.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 743 "/home/mcatanzaro/src/jhbuild/checkout/gnome-calculator/tests/test-equation.vala"
	return _vala_main (argv, argc);
#line 1821 "test-equation.c"
}



