!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeedit_close
  use cubetools_parameters
  use cubetools_structure
  use cubesyntax_keyval_types
  use cubeadm_identifier
  use cubeedit_messaging
  !
  public :: close
  private
  !
  type :: close_comm_t
     type(option_t), pointer :: comm
     type(value_strg_comm_t) :: edid
     type(identifier_opt_t)  :: as
   contains
     procedure, public  :: register => cubeedit_close_comm_register
     procedure, private :: parse    => cubeedit_close_comm_parse
     procedure, private :: main     => cubeedit_close_comm_main
  end type close_comm_t
  type(close_comm_t) :: close
  !
  type close_user_t
     type(value_strg_user_t) :: edid
     type(identifier_user_t) :: as
   contains
     procedure, private :: toprog => cubeedit_close_user_toprog
  end type close_user_t
  !
  type :: close_prog_t
     character(len=base_l) :: edid = strg_unk
     character(len=base_l) :: ouid = strg_unk
   contains
     procedure, private :: act => cubeedit_close_prog_act
  end type close_prog_t
  !
contains
  !
  subroutine cubeedit_close_command(line,error)
    !-------------------------------------------------------------------
    ! Support routine for command CLOSE
    !-------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(close_user_t) :: user
    character(len=*), parameter :: rname='CLOSE>COMMAND'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call close%parse(line,user,error)
    if (error) return
    call close%main(user,error)
    if (error) return
  end subroutine cubeedit_close_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeedit_close_comm_register(comm,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(close_comm_t), intent(inout) :: comm
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>COMM>REGISTER'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'CLOSE','[editedid]',&
         'Close the editing mode for the given cube',&
         'By default, the output cube family name will be set to editedid.&
         & Its flags will be set to “edited,cube” when the cube is created&
         & from scratch, or to “edited” followed by the original flags for&
         & cubes created as copies with the /LIKE key. The output cubeid can&
         be customized using the /AS key.',&
         cubeedit_close_command,&
         comm%comm,&
         error)
    if (error) return
    call comm%edid%register(&
         'EDITEDID',&
         'Temporary identifier of the edited cube',&
         strg_star,&
         code_arg_optional,&
         error)
    if (error) return
    call comm%as%register(&
         'Output cube identifier',&
         changeflags,&
         error)
    if (error) return
  end subroutine cubeedit_close_comm_register
  !
  subroutine cubeedit_close_comm_parse(comm,line,user,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(close_comm_t), intent(in)    :: comm
    character(len=*),    intent(in)    :: line
    type(close_user_t),  intent(out)   :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>COMM>PARSE'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call comm%edid%parse(line,comm%comm,user%edid,error)
    if (error) return
    call close%as%parse(line,user%as,error)
    if (error) return
  end subroutine cubeedit_close_comm_parse
  !
  subroutine cubeedit_close_comm_main(comm,user,error)
    !-------------------------------------------------------------------
    ! 
    !-------------------------------------------------------------------
    class(close_comm_t), intent(in)    :: comm
    type(close_user_t),  intent(in)    :: user
    logical,             intent(inout) :: error
    !
    type(close_prog_t) :: prog
    character(len=*), parameter :: rname='CLOSE>COMM>MAIN'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%act(error)
    if (error) return
  end subroutine cubeedit_close_comm_main
  !
  !------------------------------------------------------------------------
  !
  subroutine cubeedit_close_user_toprog(user,comm,prog,error)
    use cubeedit_opened_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(close_user_t), intent(in)    :: user
    type(close_comm_t),  intent(in)    :: comm    
    type(close_prog_t),  intent(out)   :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>USER>TOPROG'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call opened%get_editedid(user%edid%val,prog%edid,error)
    if (error) return
    if (user%as%do) then
       prog%ouid = user%as%identifier
    else
       prog%ouid = prog%edid
    endif
  end subroutine cubeedit_close_user_toprog
  !
  !------------------------------------------------------------------------
  !
  subroutine cubeedit_close_prog_act(prog,error)
    use cubeedit_opened_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(close_prog_t), intent(in)    :: prog
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='CLOSE>PROG>ACT'
    !
    call cubeedit_message(edseve%trace,rname,'Welcome')
    !
    call opened%close(prog%edid,prog%ouid,error)
    if (error) return
  end subroutine cubeedit_close_prog_act
end module cubeedit_close
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
