import re

# Args to vtc are: extra compile flags

def f( name, opts ):
  opts.extra_hc_opts = '-fno-warn-incomplete-patterns'

def normalise_type_vars(s):
  """
  Normalise away the trailing digits from type variable OccNames
  in hole fits error messages as these tend to be non-deterministic.
  """
  return re.sub(r'([a-z])[0-9]+', r'\1', s)

setTestOpts(f)

test('tc001', normal, compile, [''])
test('tc002', normal, compile, [''])
test('tc003', normal, compile, [''])
test('tc004', normal, compile, [''])
test('tc005', normal, compile, [''])
test('tc006', normal, compile, [''])
test('tc007', normal, compile, [''])
test('tc008', normal, compile, [''])
test('tc009', normal, compile, [''])
test('tc010', normal, compile, [''])
test('tc011', normal, compile, [''])
test('tc012', normal, compile, [''])
test('tc013', normal, compile, [''])
test('tc014', normal, compile, [''])
test('tc015', normal, compile, [''])
test('tc016', normal, compile, [''])
test('tc017', normal, compile, [''])
test('tc018', normal, compile, [''])
test('tc019', normal, compile, [''])
test('tc020', normal, compile, [''])
test('tc021', normal, compile, [''])
test('tc022', normal, compile, [''])
test('tc023', normal, compile, [''])
test('tc024', normal, compile, [''])
test('tc025', normal, compile, [''])
test('tc026', normal, compile, [''])
test('tc027', normal, compile, [''])
test('tc028', normal, compile, [''])
test('tc029', normal, compile, [''])
test('tc030', normal, compile, [''])
test('tc031', normal, compile, [''])
test('tc032', normal, compile, [''])
test('tc033', normal, compile, [''])
test('tc034', normal, compile, [''])
test('tc035', normal, compile, [''])
test('tc036', normal, compile, [''])
test('tc037', normal, compile, [''])
test('tc038', normal, compile, [''])
test('tc039', normal, compile, [''])
test('tc040', normal, compile, [''])
test('tc041', normal, compile, [''])
test('tc042', normal, compile, [''])
test('tc043', normal, compile, [''])
test('tc044', normal, compile, [''])
test('tc045', normal, compile, [''])
test('tc046', normal, compile, [''])
test('tc047', normal, compile, [''])
test('tc048', normal, compile, [''])
test('tc049', normal, compile, [''])
test('tc050', normal, compile, [''])
test('tc051', normal, compile, [''])
test('tc052', normal, compile, [''])
test('tc053', normal, compile, [''])
test('tc054', normal, compile, [''])
test('tc055', normal, compile, [''])
test('tc056', normal, compile, [''])
test('tc057', normal, compile, [''])
test('tc058', normal, compile, [''])
test('tc059', normal, compile, [''])
test('tc060', normal, compile, [''])
test('tc061', normal, compile, [''])
test('tc062', normal, compile, [''])
test('tc063', normal, compile, [''])
test('tc064', normal, compile, [''])
test('tc065', normal, compile, [''])
test('tc066', normal, compile, [''])
test('tc067', normal, compile, [''])
test('tc068', normal, compile, [''])
test('tc069', normal, compile, [''])
test('tc070', normal, compile, [''])
test('tc073', normal, compile, [''])
test('tc074', normal, compile, [''])
test('tc076', normal, compile, [''])
test('tc077', normal, compile, [''])
test('tc078', normal, compile, [''])
test('tc079', normal, compile, [''])
test('tc080', normal, compile, [''])
test('tc081', normal, compile, [''])
test('tc082', normal, compile, [''])
test('tc084', normal, compile, [''])
test('tc085', normal, compile, [''])
test('tc086', normal, compile, [''])
test('tc087', normal, compile, [''])
test('tc088', normal, compile, [''])
test('tc089', normal, compile, [''])
test('tc090', normal, compile, [''])
test('tc091', normal, compile, [''])
test('tc092', normal, compile, [''])
test('tc093', normal, compile, [''])
test('tc094', normal, compile, [''])
test('tc095', normal, compile, [''])
test('tc096', normal, compile, [''])
test('tc097', normal, compile, [''])
test('tc098', normal, compile, [''])
test('tc099', normal, compile, [''])
test('tc100', normal, compile, [''])
test('tc101', normal, compile, [''])
test('tc102', normal, compile, [''])
# tc103 free
test('tc104', normal, compile, [''])
test('tc105', normal, compile, [''])
test('tc106', normal, compile, [''])
test('tc107', normal, compile, [''])
test('tc108', normal, compile, [''])
test('tc109', normal, compile, [''])
test('tc111', normal, compile, [''])
test('tc112', normal, compile, [''])
test('tc113', normal, compile, [''])
test('tc114', normal, compile, [''])
test('tc115', normal, compile, [''])
test('tc116', normal, compile, [''])
test('tc117', normal, compile, [''])
test('tc118', normal, compile, [''])
test('tc119', normal, compile, [''])
test('tc120', normal, compile, [''])
test('tc121', normal, compile, [''])
test('tc122', normal, compile, [''])
test('tc123', normal, compile, [''])
test('tc124', normal, compile, [''])
test('tc125', normal, compile, [''])
test('tc126', normal, compile, [''])
test('tc127', normal, compile, [''])
test('tc128', normal, compile, [''])
test('tc129', normal, compile, [''])
test('tc130', normal, compile, [''])
test('tc131', normal, compile, [''])
test('tc132', normal, compile, [''])
test('tc133', normal, compile, [''])

# tc134 tested result type signatures, which aren't supported any more
# test('tc134', normal, compile_fail, [''])

test('tc135', normal, compile, [''])
test('tc136', normal, compile, [''])
test('tc137', normal, compile, [''])
test('tc140', normal, compile, [''])
test('tc141', normal, compile_fail, [''])
test('tc142', normal, compile, [''])
test('tc143', normal, compile, [''])
test('tc144', normal, compile, [''])
test('tc145', normal, compile, [''])
test('tc146', normal, compile, [''])
test('tc147', normal, compile, [''])
test('tc148', normal, compile, [''])
test('tc149', normal, compile, [''])
test('tc150', normal, compile, [''])
test('tc151', normal, compile, [''])
test('tc152', normal, compile, [''])
test('tc153', normal, compile, [''])
test('tc154', normal, compile, [''])
test('tc155', normal, compile, [''])
test('tc156', normal, compile, [''])
test('tc157', normal, compile, [''])
test('tc158', normal, compile, [''])
test('tc159', normal, compile_and_run, [''])
test('tc160', normal, compile, [''])
test('tc161', normal, compile, [''])
test('tc162', normal, compile, [''])
test('tc163', normal, compile, [''])
test('tc164', normal, compile, [''])
test('tc165', normal, compile, [''])
test('tc166', normal, compile, [''])
test('tc167', normal, compile, [''])
test('tc169', normal, compile, [''])

test('tc170', [extra_files(['Tc170_Aux.hs'])], makefile_test, [])

test('tc171', normal, compile, [''])
test('tc172', normal, compile, [''])

# The point about this test is that it compiles Tc173a and Tc173b *separately*
test('tc173', [extra_files(['Tc173a.hs', 'Tc173b.hs'])], makefile_test, [])

test('tc174', normal, compile, [''])
test('tc175', normal, compile, [''])
test('tc176', normal, compile, [''])
test('tc177', normal, compile, [''])
test('tc178', normal, compile, [''])
test('tc179', normal, compile, [''])
test('tc180', normal, compile, [''])
test('tc181', normal, compile, [''])
test('tc182', normal, compile, [''])
test('tc183', normal, compile, [''])
test('tc184', normal, compile, [''])
test('tc185', normal, compile, [''])
test('tc186', normal, compile, [''])
test('tc187', normal, compile, [''])
test('tc188', normal, compile, [''])
test('tc189', normal, compile, [''])
test('tc190', normal, compile, [''])
test('tc192', normal, compile, [''])
test('tc193', normal, compile, [''])
test('tc194', normal, compile, [''])
test('tc195', normal, compile, [''])
test('tc196', normal, compile, [''])
test('tc197', normal, compile, [''])
test('tc198', normal, compile, [''])
test('tc199', normal, compile, [''])
test('tc200', normal, compile, [''])
test('tc201', normal, compile, [''])
test('tc202', normal, compile, [''])
test('tc203', normal, compile, [''])
test('tc204', normal, compile, [''])
test('tc205', normal, compile, [''])
test('tc206', normal, compile, [''])
test('tc207', normal, compile, [''])
test('tc208', normal, compile, [''])
test('tc209', normal, compile, [''])
test('tc210', normal, compile, [''])
test('tc211', normal, compile, [''])
test('tc212', normal, compile, [''])
test('tc213', normal, compile, [''])
test('tc214', normal, compile, [''])
test('tc215', normal, compile, [''])

# This one is very delicate, but I don't think the result really matters
test('tc216', normal, compile, [''])

test('tc217', normal, compile, [''])
test('tc218', normal, compile, [''])
test('tc219', normal, compile, [''])
test('tc221', normal, compile, [''])
test('tc222', normal, compile, [''])
test('tc223', normal, compile, [''])
test('tc224', normal, compile, [''])
test('tc225', normal, compile, [''])
test('tc226', normal, compile, [''])
test('tc227', normal, compile, [''])
test('tc228', normal, compile, [''])
test('tc229', normal, compile, [''])
test('tc230', normal, compile, [''])

test('tc231', normalise_version('ghc-internal', 'base','ghc-prim'), compile_fail, [''])
# Could go either way (see comments in the test itself)

test('tc232', normal, compile, [''])
test('tc233', normal, compile, [''])
test('tc234', normal, compile, [''])
test('tc235', normal, compile, [''])
test('tc236', normal, compile, [''])
test('tc237', normal, compile, [''])
test('tc238', normal, compile, [''])

test('tc239', [extra_files(['Tc239_Help.hs'])], multimod_compile, ['tc239', '-v0'])

test('tc240', normal, compile, [''])
test('tc241', normal, compile, [''])
test('tc242', normal, compile, [''])
test('tc243', normal, compile, [''])
test('tc244', normal, compile, [''])
test('tc245', [extra_files(['Tc245_A.hs'])], makefile_test, [])
test('tc246', normal, compile, [''])
test('tc247', normal, compile, [''])
test('tc248', normal, compile, [''])

test('FD4', normal, compile, [''])

test('faxen', normal, compile, [''])
test('T816', normal, compile, [''])
test('T1495', normal, compile, [''])
test('T2045', normal, compile, [''])   # Needs -fhpc
test('T2478', normal, compile, [''])
test('T2433', [], multimod_compile, ['T2433', '-v0'])
test('T2494', normal, compile_fail, [''])
test('T2494-2', normal, compile, [''])
test('T2497', normal, compile, [''])


# Omitting temporarily
test('syn-perf', normal, compile, ['-freduction-depth=30'])
test('syn-perf2', normal, compile, [''])

test('LoopOfTheDay1', normal, compile, [''])
test('LoopOfTheDay2', normal, compile, [''])
test('LoopOfTheDay3', normal, compile, [''])

test('T1470', normal, compile, [''])
test('T2572', normal, compile, [''])
test('T2735', normal, compile, [''])
test('T2799', normal, compile, [''])
test('T3219', normal, compile, [''])
test('T3342', normal, compile, [''])
test('T3346', normal, compile, [''])
test('T3409', normal, compile, [''])
test('T3955', normal, compile, [''])
test('PolyRec', normal, compile, [''])
test('twins', normal, compile, [''])

test('T2412', [], makefile_test, [])

test('T2846', normal, compile, [''])
test('T4284', normal, compile, [''])
test('T2683', normal, compile, [''])
test('T3696', normal, compile, [''])
test('T1123', normal, compile, [''])
test('T3692', normal, compile, [''])
test('T700',  normal, compile, [''])
test('T4361', normal, compile, [''])
test('T4355', normal, compile, [''])
test('T1634', normal, compile, [''])
test('T4401', normal, compile, [''])
test('T4404', normal, compile, ['-Wall'])
test('HasKey', normal, compile, [''])
test('T4418', normal, compile, [''])
test('T4444', normal, compile, [''])
test('T4498', normal, compile, [''])
test('T4524', normal, compile, [''])
test('T4917', normal, compile, [''])

test('T4912', [], multimod_compile, ['T4912', '-v0'])

test('T4952', normal, compile, [''])
test('T4969', normal, compile, [''])
test('T5120', normal, compile, [''])
test('mc18', normal, compile, [''])
test('tc249', normal, compile, [''])
test('tc250', normal, compile, [''])
test('tc251', [extra_files(['Tc251_Help.hs'])], multi_compile, ['tc251', [('Tc251_Help.hs', '')], '-v0'])
test('tc252', normal, compile, [''])
test('tc253', normal, compile, [''])
test('tc254', normal, compile, [''])
test('tc255', normal, compile, [''])
test('tc256', normal, compile, [''])
test('tc257', normal, compile, [''])
test('tc258', normal, compile, [''])
test('tc259', normal, compile, [''])
test('tc260', normal, compile, [''])
test('tc261', normal, compile, [''])
test('tc262', normal, compile, [''])
test('tc263', [extra_files(['Tc263_Help.hs'])], multimod_compile, ['tc263', '-v0'])
test('tc265', normal, compile, [''])
test('tc266', [extra_files(['Tc266.hs', 'Tc266a.hs', 'Tc266.hs-boot'])], makefile_test, [])
test('Tc267', [extra_files(['Tc267a.hs', 'Tc267b.hs', 'Tc267a.hs-boot', 'Tc267b.hs-boot'])], makefile_test, [])
test('tc268', normal, compile, [''])
test('tc269', normal, compile, [''])
test('tc270', normal, compile, [''])
test('Tc271', [extra_files(['Tc271a.hs', 'Tc271.hs', 'Tc271.hs-boot'])], makefile_test, [])

test('GivenOverlapping', normal, compile, [''])
test('GivenTypeSynonym', normal, compile, [''])
test('T3018', normal, compile, [''])
test('T5032', normal, compile, [''])
test('T2357', normal, compile, [''])
test('T5481', normal, compile_fail, [''])
test('T3743', normal, compile, [''])
test('T5490', normal, compile, [''])
test('T5514', normal, compile, [''])
test('T5581', normal, compile, [''])
test('T5655', normal, compile, [''])
test('T21515', normal, compile, [''])
test('T21473', normal, compile, [''])
test('T5643', normal, compile, [''])
test('T5595', normal, compile, [''])
test('T5676', normal, compile, [''])
test('T4310', normal, compile, [''])
test('T3108', normal, compile, [''])

test('T5792',normal, makefile_test, [])

test('PolytypeDecomp', normal, compile_fail, [''])
test('T6011', normal, compile, [''])
test('T6055', normal, compile, [''])
test('DfltProb1', normal, compile, ['-O'])
# Add -O for DfltProb1 to expose #11291
test('DfltProb2', normal, compile, [''])
test('T6134', normal, compile, [''])
test('T6018', [], multimod_compile, ['T6018', ''])
test('TcLambdaCase', [], compile, [''])
test('T7147', normal, compile, [''])
test('T7171',normal, makefile_test, [])
test('T7173', normal, compile, [''])
test('T7196', normal, compile, [''])
test('T7050', normal, compile, [''])
test('T7312', normal, compile, [''])
test('T7384', normal, compile, [''])
test('T7451', normal, compile, [''])
test('holes', normalise_version('ghc-internal', 'base'), compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('holes2', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('holes3', normalise_version('ghc-internal', 'base'), compile_fail, ['-fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('hole_constraints', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('hole_constraints_nested', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('valid_hole_fits', extra_files(['ValidHoleFits.hs']),
    multimod_compile, ['valid_hole_fits','-fdefer-type-errors -fno-max-valid-hole-fits'])
test('local_hole_fits', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('subsumption_sort_hole_fits', normalise_version('ghc-internal', 'base'), compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -fsort-by-subsumption-hole-fits'])
test('valid_hole_fits_interactions', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('refinement_hole_fits', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -fno-max-refinement-hole-fits -frefinement-level-hole-fits=2'])
test('abstract_refinement_hole_fits', normalise_errmsg_fun(normalise_type_vars), compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -fno-max-refinement-hole-fits -frefinement-level-hole-fits=2 -fabstract-refinement-hole-fits -funclutter-valid-hole-fits'])
test('free_monad_hole_fits', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -fno-max-refinement-hole-fits -frefinement-level-hole-fits=2 -funclutter-valid-hole-fits'])
test('constraint_hole_fits', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -fno-max-refinement-hole-fits -frefinement-level-hole-fits=2 -funclutter-valid-hole-fits'])
test('type_in_type_hole_fits', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('T15370', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits -funclutter-valid-hole-fits'])
test('T25180', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('T7408', normal, compile, [''])
test('UnboxStrictPrimitiveFields', normal, compile, [''])
test('T7503a', normal, compile, [''])
test('T7541', normal, compile, [''])
test('T7562', normal, compile, [''])
test('T7641', normal, compile, [''])
test('T7827', normal, compile, [''])
test('T7875', normal, compile, [''])
test('T7268', normal, compile, [''])
test('T7888', normal, compile, [''])
test('T7891', normal, compile, [''])
test('T7903', normal, compile, [''])
test('TcTypeNatSimple', normal, compile, [''])
test('TcTypeSymbolSimple', normal, compile, [''])
test('TcCoercibleCompile', [], compile, [''])
test('T8392', normal, compile, [''])
test('T8474', normal, compile, [''])
test('T8563', normal, compile, [''])
test('T8565', normal, compile, [''])
test('T8644', normal, compile, [''])
test('TcStaticPointers01', normal, compile, [''])
test('TcStaticPointers02', normal, compile, [''])
test('T8762', normal, compile, [''])
test('MutRec', normal, compile, [''])
test('T8856', normal, compile, [''])
test('T9569a', normal, compile_fail, [''])
test('T9569b', normal, compile, [''])
test('T9117', normal, compile, [''])
test('T9117_2', normal, compile, [''])
test('T9117_3', normal, compile, [''])
test('T9708', expect_broken(9708), compile, [''])
test('T9404', normal, compile, [''])
test('T9404b', normal, compile, [''])
test('T7220', normal, compile, [''])
test('T7220a', normal, compile, [''])
test('T9151', normal, compile, [''])
test('T9497a', normal, compile, ['-fdefer-typed-holes'])
test('T9497b', normal, compile, ['-fdefer-typed-holes -fno-warn-typed-holes'])
test('T9497c', normal, compile, ['-fdefer-type-errors -fno-warn-typed-holes'])
test('T7643', normal, compile, [''])
test('T9834', normal, compile, [''])
test('T9892', normal, compile, [''])
test('T9939', normal, compile, ['-Wredundant-constraints'])
test('T9973', normal, compile, [''])
test('T9971', normal, compile, [''])
test('T10031', normal, compile, [''])
test('T10184', expect_broken(10184), compile, [''])
test('T10072', normal, compile_fail, [''])
test('T10100', normal, compile, [''])
test('T10156', normal, compile, [''])
test('T10177', normal, compile, [''])
test('T10185', expect_broken(10185), compile, [''])
test('T10195', normal, compile, [''])
test('T10109', normal, compile, [''])
test('T10283', normal, compile, [''])
test('TcCustomSolverSuper', normal, compile, [''])
test('T10335', normal, compile, [''])
test('Improvement', normal, compile, [''])
test('T10009', normal, compile, [''])
test('T10390', normal, compile, [''])
test('T22519', normal, compile, [''])
test('T8555', normal, compile, [''])
test('T8799', normal, compile, [''])
test('T10432', normal, compile, [''])
test('T10423', normal, compile, [''])
test('T10489', unless(compiler_debugged(), skip), compile, [''])
test('T10348', normal, compile, [''])
test('T10494', normal, compile, [''])
test('T10493', normal, compile, [''])
test('T10428', normal, compile, [''])
test('RepArrow', normal, compile, [''])
test('T10504', normal, multimod_compile, ['T10504', '-O -v0'])
test('T10562', normal, compile, [''])
test('T10564', normal, compile, [''])
test('Vta1', normal, compile, [''])
test('Vta2', normal, compile, [''])
test('VtaCoerce', normal, compile, [''])
test('PushHRIf', normal, compile, [''])
test('T10632', normal, compile, ['-Wredundant-constraints'])
test('T10642', normal, compile, [''])
test('T10744', normal, compile, [''])
test('update-existential', normal, compile, [''])
test('T10347', normal, compile, [''])
test('T11056', normal, compile, [''])
test('T10770a', expect_broken(10770), compile, [''])
test('T10770b', expect_broken(10770), compile, [''])
test('T10935', normal, compile, [''])
test('T10971a', normal, compile, [''])
test('T11062', [extra_files(['T11062.hs', 'T11062.hs-boot', 'T11062a.hs'])], multimod_compile, ['T11062', '-v0'])
test('T11237', normal, compile, [''])
test('T10592', normal, compile, [''])
test('T11305', normal, compile, [''])
test('T11254', normal, compile, [''])
test('T11379', normal, compile, [''])
test('T11480', normal, compile, [''])
test('RebindHR', normal, compile, [''])
test('RebindNegate', normal, compile, [''])
test('T11319', normal, compile, [''])
test('T11397', normal, compile, [''])
test('T11458', normal, compile, [''])
test('T11506', normal, compile, [''])
test('T11524', normal, compile, [''])
test('T11552', normal, compile, [''])
test('T11246', normal, compile, [''])
test('T11608', normal, compile, [''])
test('T11401', normal, compile, [''])
test('T11699', normal, compile, [''])
test('T11512', normal, compile, [''])
test('T11754', normal, compile, [''])
test('T11766', normal, compile, [''])
test('T11811', normal, compile, [''])
test('T11793', normal, compile, [''])
test('T11348', normal, compile, [''])
test('T11947', normal, compile, [''])
test('T11982a', expect_broken(11982), compile, [''])
test('T11982b', expect_broken(11982), compile, [''])
test('T11982c', normal, compile, [''])
test('T12045a', normal, compile, [''])
test('T12064', [], multimod_compile, ['T12064', '-v0'])
test('ExPat', normal, compile, [''])
test('ExPatFail', normal, compile_fail, [''])
test('SigTyVars', normal, compile, [''])
test('T12069', normal, compile, [''])
test('T11700', normal, compile, [''])
test('T11339', normal, compile_fail, [''])
test('T11339b', normal, compile, [''])
test('T11339c', normal, compile, [''])
test('T11339d', normal, compile, [''])
test('T11974', normal, compile, [''])
test('T12067', [], multimod_compile, ['T12067', '-v0'])
test('T12104', normal, compile, ['-fdefer-type-errors'])
test('T12185', normal, compile, [''])
test('T12133', normal, compile, [''])
test('T12381', normal, compile, [''])
test('T12082', normal, compile, [''])
test('T10635', normal, compile, [''])
test('T12170b', normal, compile, [''])
test('T12466', normal, compile, [''])
test('T12466a', normal, compile, [''])
test('T12644', normal, compile, [''])
test('T12427a', normal, compile_fail, [''])
test('T12427b', normal, compile, [''])
test('T12507', normal, compile, [''])
test('T12734', normal, compile, [''])
test('T12734a', normal, compile_fail, [''])
test('T12763', normalise_version('ghc-internal', 'base'), compile, [''])
test('T12785a', normal, compile, [''])
test('T12797', normal, compile, [''])
test('T12850', normal, compile, [''])
test('T12911', normal, compile, [''])
test('T12925', normal, compile, [''])
test('T12919', normal, compile, [''])
test('T12936', normal, compile, [''])
test('T13050', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('T13083', normal, compile, [''])
test('T11723', normal, compile, [''])
test('T12987', normal, compile, [''])
test('T11736', normal, compile, [''])
test('T13248', expect_broken(13248), compile, [''])
test('T12923_1', normal, compile, [''])
test('T21208', normal, compile, [''])
test('T12923_2', normal, compile, [''])
test('T12923_3', normal, compile, [''])
test('T13381', normal, compile_fail, [''])
test('T13337', normal, compile, [''])
test('T13343', normal, compile, [''])
test('T13458', normal, compile, [''])
test('T13490', normal, compile, [''])
test('T13474', normal, compile, [''])
test('T13524', normal, compile, [''])
test('T20602', normal, compile, [''])
test('T20231', normal, compile, [''])
test('T20582', normal, compile, [''])
test('T13509', normal, compile, [''])
test('T13526', normal, compile, [''])
test('T13594', normal, compile_fail, [''])
test('T13603', normal, compile, [''])
test('T13333', normal, compile, [''])
test('T13585', [extra_files(['T13585.hs', 'T13585a.hs', 'T13585b.hs'])], makefile_test, [])
test('T13651', normal, compile_fail, [''])
test('T13651a', normal, compile, [''])
test('T13680', normal, compile, [''])
test('T13785', normal, compile, [''])
test('T13804', normal, compile, [''])
test('T13822', normal, compile, [''])
test('T13848', normal, compile, [''])
test('T13879', normal, compile, [''])
test('T13881', normal, compile, [''])
test('T18851d', normal, compile, [''])
test('T13915a', expect_broken(15245), multimod_compile, ['T13915a', '-v0'])
test('T13915b', expect_broken(15245), compile, [''])
test('T13984', normal, compile, [''])
test('T14128', normal, multimod_compile, ['T14128Main', '-v0'])
test('T14149', normal, compile_fail, [''])
test('T14154', normal, compile, [''])
test('T14158', normal, compile, [''])
test('T13943', normal, compile, ['-fsolve-constant-dicts'])
test('T14333', normal, compile, [''])
test('T14363', normal, compile, [''])
test('T14363a', normal, compile, [''])
test('T7169', normal, compile, [''])
test('T14396', [extra_files(['T14396.hs', 'T14396.hs-boot', 'T14396a.hs', 'T14396b.hs', 'T14396f.hs'])], multimod_compile, ['T14396', '-v0'])
test('T14434', [], makefile_test, [])
test('MissingExportList01', normal, compile, [''])
test('MissingExportList02', normal, compile, [''])
test('T14451', normal, compile, [''])
test('T14488', normal, compile, [''])
test('T14590', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
# We omit the hpc/profasm ways because this test checks the
# desugarer's output and these ways add some
# annotations/ticks that prevent it from giving the exact
# output we expect (T13032.stderr).
test('T13032', omit_ways(['hpc', 'profasm']), compile, [''])
test('T14273', normal, compile, ['-fdefer-type-errors -fno-max-valid-hole-fits'])
test('T14366', normal, compile, [''])
test('T14732', normal, compile, [''])
test('T14774', [ grep_errmsg(r'p1D') ], compile, ['-ddump-simpl -dsuppress-uniques'])
    # T14774: check that there are no occurrences of the superclss selector p1D
test('T14763', normal, compile, [''])
test('T14811', normal, compile, [''])
test('T14934', [extra_files(['T14934.hs', 'T14934a.hs'])], makefile_test, [])
test('T13643', normal, compile, [''])
test('SplitWD', normal, compile, [''])
test('T14441', req_th, compile, [''])
test('T15079', normal, compile, [''])
test('T15050', normal, compile, [''])
test('T14735', normal, compile, [''])
test('T15180', normal, compile, [''])
test('T15232', normal, compile, [''])
test('T15788', normal, compile, [''])
test('T15807a', normal, compile, [''])
test('T13833', normal, compile, [''])
test('T14185', expect_broken(14185), compile, [''])

def onlyHsParLocs(x):
    """
    We only want to check that all the parentheses are present with the correct location,
    not compare the entire typechecked AST.
    Located (HsPar GhcTc) are pretty printed with the form
      (EpaSpan { T15242.hs:6:5-41 })
      (AnnListItem
       [])
      (EpaComments
       []))
     (HsPar
    This function tries to extract all such location infos from the typechecked AST.
    Note: It is applied to the expected result too, so it also needs the "(HsPar" and
    appropriate spacing.
    """
    ls = x.split("\n")
    filteredLines = (loc.strip() for (loc,hspar) in zip(ls,ls[5:])
                      if hspar.strip().startswith("(HsPar")
                        and not "<no location info>" in loc)
    return '\n'.join(filteredLines)
test('T15242', normalise_errmsg_fun(onlyHsParLocs), compile, [''])
test('T15431', normal, compile, [''])
test('T15431a', normal, compile, [''])
test('T15428', normal, compile, [''])
test('T15412', normal, compile, [''])
test('T15473', normal, compile_fail, [''])
test('T15499', normal, compile, [''])
test('T15586', normal, compile, [''])
test('T15368', normal, compile, ['-fdefer-type-errors'])
test('T15645', normal, compile, [''])
test('T15646',
     compile_timeout_multiplier(0.01),
     # 0.01 may seem tiny (1 is timeout after 300s, so this is 3 seconds),
     # but if this test regresses, it will take about 10 seconds to finish.
     compile, [''])
test('T15778', normal, compile, [''])
test('T14761c', expect_broken_for(16540, ['hpc', 'profasm', 'optasm']), compile, [''])
test('T16008', normal, compile, [''])
test('T16033', normal, compile, [''])
test('T16141', normal, compile, ['-O'])
test('T15549a', normal, compile, [''])
test('T15549b', normal, compile, [''])
test('T16188', normal, compile, [''])
test('T16204a', normal, compile, [''])
test('T16204b', normal, compile, [''])
test('T20668', normal, compile, [''])
test('T16225', normal, compile, [''])
test('T13951', normal, compile, [''])
test('T16312', normal, compile, ['-O'])
test('T20443a', normal, compile, [''])
test('T16411', normal, compile, [''])
test('T16609', normal, compile, [''])
test('T16827', normal, compile, [''])
test('T505', normal, compile, [''])
test('T12928', normal, compile, [''])
test('UnliftedNewtypesGnd', normal, compile, [''])
test('UnliftedNewtypesUnassociatedFamily', normal, compile, [''])
test('UnliftedNewtypesUnifySig', normal, compile, [''])
test('UnliftedNewtypesForall', normal, compile, [''])
test('UnlifNewUnify', normal, compile, [''])
test('UnliftedNewtypesLPFamily', normal, compile, [''])
test('UnliftedNewtypesDifficultUnification', normal, compile, [''])
test('LevPolyResult', normal, compile, [''])
test('T16832', normal, ghci_script, ['T16832.script'])
test('T15772', normal, compile, [''])
test('T16995', normal, compile, [''])
test('T17007', normal, compile, [''])
test('T17067', normal, compile, [''])
test('T17202', normal, compile, [''])
test('T15839a', normal, compile, [''])
test('T15839b', normal, compile, [''])
test('T16502b', normal, compile, [''])
test('T17343', exit_code(1), compile_and_run, [''])
test('T17566', [extra_files(['T17566a.hs'])], makefile_test, [])
test('T12760', unless(compiler_debugged(), skip), compile, ['-O'])
test('T13142', normal, compile, ['-O2'])
test('T17710', normal, compile, [''])
test('T17792', normal, compile, [''])
test('T17024', normal, compile, [''])
test('T19186', normal, compile, [''])
test('T17021a', normal, compile, [''])
test('T17723', [], makefile_test, [])
test('T17772', normal, compile, [''])
test('T19665', normal, compile, [''])
test('T18005', normal, compile, [''])
test('T18023', normal, compile, [''])
test('T18036', normal, compile, [''])
test('T18036a', normal, compile, [''])
test('T18036b', normal, compile, [''])
test('T19682', normal, compile, [''])
test('T19682b', normal, compile, [''])
test('T17873', normal, compile, [''])
test('T18129', expect_broken(18129), compile, [''])
test('T18185', normal, compile, [''])
test('T19042', normal, compile, [''])
test('ExplicitSpecificityA1', normal, compile, [''])
test('ExplicitSpecificityA2', normal, compile, [''])
test('ExplicitSpecificity4', normal, compile, [''])
test('TcSpecPragmas', normal, compile, [''])
test('RuleEqs', normal, compile, [''])
test('T17775-viewpats-a', normal, compile, [''])
test('T17775-viewpats-b', normal, compile_fail, [''])
test('T17775-viewpats-c', normal, compile_fail, [''])
test('T17775-viewpats-d', normal, compile_fail, [''])
test('T18118', normal, multimod_compile, ['T18118', '-v0'])
test('T18412', normal, compile, [''])
test('T18470', normal, compile, [''])
test('T18308', normal, compile, [''])
test('T20922', normal, compile, [''])
test('T18323', normal, compile, [''])
test('T19677', normal, compile, [''])
test('T18585', normal, compile, [''])
test('T18831', normal, compile, [''])
test('T18920', normal, compile, [''])
test('T18939_Compile', normal, compile, [''])
test('T19107', normal, compile, [''])
test('T15942', normal, compile, [''])
test('T17562b', normal, compile, [''])
test('T17567StupidThetaB', normal, compile, [''])
test('ClassDefaultInHsBoot', [extra_files(['ClassDefaultInHsBootA1.hs','ClassDefaultInHsBootA2.hs','ClassDefaultInHsBootA2.hs-boot','ClassDefaultInHsBootA3.hs'])], multimod_compile, ['ClassDefaultInHsBoot', '-v0'])
test('T17812', normal, compile, [''])
test('T17186', normal, compile, [''])
test('CbvOverlap', normal, compile, [''])
test('InstanceGivenOverlap', normal, compile, [''])
test('InstanceGivenOverlap2', expect_broken(20076), compile_fail, [''])
test('T19044', normal, compile, [''])
test('T19052', normal, compile, [''])
test('LocalGivenEqs', normal, compile, [''])
test('LocalGivenEqs2', normal, compile_fail, [''])
test('T18891', normal, compile, [''])

test('TyAppPat_Existential', normal, compile, [''])
test('TyAppPat_ExistentialMulti', normal, compile, [''])
test('TyAppPat_KindDependency', normal, compile, [''])
test('TyAppPat_Universal', normal, compile, [''])
test('TyAppPat_Mixed', normal, compile, [''])
test('TyAppPat_TH', normal, compile, [''])
test('TyAppPat_UniversalMulti1', normal, compile, [''])
test('TyAppPat_UniversalMulti2', normal, compile, [''])
test('TyAppPat_UniversalMulti3', normal, compile, [''])
test('TyAppPat_UniversalNested', normal, compile, [''])
test('TyAppPat_Wildcard', normal, compile, [''])
test('TyAppPat_Tricky', normal, compile, [''])

test('T18998', normal, compile, [''])
test('T18998b', normal, compile, [''])
# Ignore stderr as otherwise we see a warning due to grep closing GHC's stdout before
# GHC has finished writing to it.
test('InlinePatSyn_InlinableBuilder', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_InlinableMatcher', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_InlineBuilder', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_InlineMatcher', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_NoInlineBuilder', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_NoInlineMatcher', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_ExplicitBidiBuilder', [ignore_stderr], makefile_test, [])
test('InlinePatSyn_ExplicitBidiMatcher', [ignore_stderr], makefile_test, [])
test('T18467', normal, compile, [''])

test('T19315', normal, compile, [''])

test('T19535', normal, compile, [''])
test('T19738', normal, compile, [''])
test('T19742', normal, compile, [''])
test('T19775', normal, compile, [''])
test('T17817b', normal, compile, [''])
test('T20033', normal, compile, [''])
test('TypeRepCon', normal, compile, ['-Woverlapping-patterns'])
test('T20181', normal, compile, [''])
test('T20241', normal, compile, [''])
test('T20187a', normal, compile, ['-Wredundant-strictness-flags'])
test('T20187b', normal, compile, ['-Wredundant-strictness-flags'])
test('T20356', normal, compile, [''])
test('T20584', normal, compile, [''])
test('T21558', normal, compile, ['-w'])
test('T20584b', normal, compile, [''])
test('T20588b', [extra_files(['T20588b.hs', 'T20588b.hs-boot', 'T20588b_aux.hs'])], multimod_compile, ['T20588b_aux.hs', '-v0'])
test('T20588d', [extra_files(['T20588d.hs', 'T20588d.hs-boot', 'T20588d_aux.hs'])], multimod_compile, ['T20588d_aux.hs', '-v0'])
test('T20661', [extra_files(['T20661.hs', 'T20661.hs-boot', 'T20661_aux.hs'])], multimod_compile, ['T20661_aux.hs', '-v0'])
test('T20873', normal, compile, [''])
test('T20873b', [extra_files(['T20873b_aux.hs'])], multimod_compile, ['T20873b', '-v0'])
test('T20873c', normal, compile, [''])
test('StaticPtrTypeFamily', normal, compile, [''])
test('T20946', normal, compile, [''])
test('T20996', normal, compile, [''])
test('T20732', normal, compile, [''])
test('T21703', normal, compile, [''])
test('T21010', [extra_files(['T21010A.hs', 'T21010B.hs'])], multimod_compile, ['T21010.hs', '-v0'])
test('FunDepOrigin1', normal, compile, [''])
test('FloatFDs', normal, compile, [''])
test('ImplicitParamFDs', normal, compile, [''])
test('T18406b', normalise_version('ghc-internal', 'base'), compile, ['-ddump-tc -fprint-explicit-foralls -dsuppress-uniques -fprint-typechecker-elaboration'])
test('T18529', normalise_version('ghc-internal', 'base'), compile, ['-ddump-tc -fprint-explicit-foralls -dsuppress-uniques -fprint-typechecker-elaboration'])
test('T21023', normalise_version('ghc-internal', 'base'), compile, ['-ddump-types'])
test('T21205', normal, compile, ['-O0'])
test('T21323', normal, compile, [''])
test('T21315', normal, compile, ['-Wredundant-constraints'])
test('T21328', normal, compile, [''])
test('T21516', normal, compile, [''])
test('T21519', normal, compile, [''])
test('T21519a', normal, compile, [''])
test('T21583', normal, compile, [''])
test('T2595', normal, compile, [''])
test('T3632', normal, compile, [''])
test('T10808', normal, compile, [''])
test('T10856', normal, compile, [''])
test('T16501', normal, compile, [''])
test('T18311', normal, compile, [''])
test('T18802', normal, compile, [''])
test('T18802b', normal, compile, [''])
test('T21289', normal, compile, [''])
test('HardRecordUpdate', normal, compile, [''])
test('T21548a', normal, compile, [''])
test('DeepSubsumption01', normal, compile, [''])
test('DeepSubsumption02', normal, compile, [''])
test('DeepSubsumption03', normal, compile, [''])
test('DeepSubsumption04', normal, compile, [''])
test('DeepSubsumption05', normal, compile, [''])
test('DeepSubsumption06', normal, compile, ['-XHaskell98'])
test('DeepSubsumption07', normal, compile, ['-XHaskell2010'])
test('DeepSubsumption08', normal, compile, [''])
test('DeepSubsumption09', normal, compile, [''])
test('T26225', normal, compile, [''])
test('T26225b', normal, compile, [''])
test('T21765', normal, compile, [''])
test('T21951a', normal, compile, ['-Wredundant-strictness-flags'])
test('T21951b', normal, compile, ['-Wredundant-strictness-flags'])
test('DataToTagSolving', normal, compile, [''])
test('T21550', normal, compile, [''])
test('T22141f', normal, compile, [''])
test('T22141g', normal, compile, [''])
test('T22310', normal, compile, [''])
test('T22331', normal, compile, [''])
test('T22516', normal, compile, [''])
test('T22647', normal, compile, [''])
test('T19577', normal, compile, [''])
test('T22383', normal, compile, [''])
test('T21501', normal, compile, [''])
test('T22924', normal, compile, [''])
test('T22985a', normal, compile, ['-O'])
test('T22985b', normal, compile, [''])
test('T23018', normal, compile, [''])
test('T21909', normal, compile, [''])
test('T21909b', normal, compile, [''])
test('T21443', normal, compile, [''])
test('T22194', normal, compile, [''])
test('T25744', normal, compile, [''])
test('T26030', normal, compile, [''])
test('QualifiedRecordUpdate',
    [ extra_files(['QualifiedRecordUpdate_aux.hs']) ]
    , multimod_compile, ['QualifiedRecordUpdate', '-v0'])
test('CoerceToVDQ', normal, compile, ['-dlint'])
test('T22762', normal, compile, ['-dlint'])
test('T23171', normal, compile, [''])
test('T23192', normal, compile, [''])
test('T23199', normal, compile, [''])
test('T23156', normal, compile, [''])
test('T23543', normal, compile, [''])
test('T22560a', normal, compile, [''])
test('T22560b', normal, compile, [''])
test('T22560c', normal, compile, [''])
test('T22560d', extra_files(['T22560d.hs']), ghci_script, ['T22560d.script'])
test('T22560e', normal, compile, [''])
test('T23514b', normal, compile, [''])
test('T23514c', normal, compile, [''])
test('T22537', normal, compile, [''])
test('T26277', normal, compile, [''])
test('T18986a', normal, compile, [''])
test('T18986b', normal, compile, [''])
test('T23413', normal, compile, [''])
test('TcIncompleteRecSel', normal, compile, ['-Wincomplete-record-selectors'])
test('InstanceWarnings', normal, multimod_compile, ['InstanceWarnings', ''])
test('T23861', normal, compile, [''])
test('T23918', normal, compile, [''])
test('T17564', normal, compile, [''])
test('T24146', normal, compile, [''])
test('T22788', normal, compile, [''])
test('T21003', normal, compile, [''])
test('T21206', normal, compile, [''])
test('T17594a', req_th, compile, [''])
test('T17594f', normal, compile, [''])
test('WarnDefaultedExceptionContext', normal, compile, ['-Wdefaulted-exception-context'])
test('T24470b', normal, compile, [''])
test('T24566', [], makefile_test, [])
test('T23764', normal, compile, [''])
test('T23739a', normal, compile, [''])
test('T24810', normal, compile, [''])
test('T24887', normal, compile, [''])
test('T24938a', normal, compile, [''])
test('T25094', normal, compile, [''])
test('T25029', normal, compile, [''])
test('T25125', normal, compile, [''])
test('T24845a', normal, compile, [''])
test('T23501a', normal, compile, [''])
test('T23501b', normal, compile, [''])
test('T25266', normal, compile, [''])
test('T25266a', normal, compile_fail, [''])
test('T25266b', normal, compile, [''])
test('T25597', normal, compile, [''])
test('T25960', normal, compile, [''])
test('T26020', normal, compile, [''])
test('T26020a', [extra_files(['T26020a_help.hs'])], multimod_compile, ['T26020a', '-v0'])
test('T25992', normal, compile, [''])
test('T14010', normal, compile, [''])
test('T26256a', normal, compile, [''])
test('T25992a', normal, compile, [''])
test('T26154', [extra_files(['T26154_A.hs', 'T26154_B.hs', 'T26154_B.hs-boot', 'T26154_Other.hs'])], multimod_compile, ['T26154', '-v0'])
test('T26346', normal, compile, [''])
test('T26358', expect_broken(26358), compile, [''])
test('T26345', normal, compile, [''])
test('T26376', normal, compile, [''])
test('T26457', normal, compile, [''])
