/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "framedir.hh"
#include <iostream>

using namespace std;

int 
main(int argc, const char* argv[]) {
    FrameDir d;
    for (int i=1 ; i<argc ; i++) {
	if (string(argv[i]) == "-d") d.setDebug(1);
        d.add(argv[i]);
    }

    //----------------------------------  Dump the times
    Time tStart(0), tStop(0);
    for (FrameDir::file_iterator i=d.begin() ; i != d.end() ; i++) {
        if (!tStart) {
	    tStart = i->getStartTime();
	} else if (!Almost(i->getStartTime(), tStop)) {
	    cout << tStart.getS() << "-" << tStop.getS() << endl;
	    tStart = i->getStartTime();
	}
	tStop  = i->getEndTime();
    }

    //----------------------------------- Print the last line
    if (!Almost(tStart, tStop)) {
        cout << tStart.getS() <<  "-" << tStop.getS() << endl;
    }
}
