#ifndef LSCSEGFIND_HH
#define LSCSEGFIND_HH

#include "SegList.hh"

class LSCSegFind : public LockSegList {
public:
  enum in_mode {
    kUnknown,
    kFile,
    kWeb,
    kDataBase
  };
public:
  LSCSegFind(void);
  LSCSegFind(const std::string& type, const std::string& ifo, 
	     const Time& start=Time(0), const Time& end=Time(0));  
  ~LSCSegFind(void);
  void buildQuery(void);
  void query(void);
  void reset(void);
  void setDebug(int lvl);
  void setIfo(const std::string& ifo);
  void setRange(const Time& start, const Time& end);
  void setSource(in_mode sm, const std::string& source);
  void setType(const std::string& mType);
  void setUrl(const std::string& url);

private:
  Time mStartGPS;
  Time mEndGPS;
  in_mode mMode;
  std::string mSource;
  std::string mIfo;
  std::string mType;
  std::string mUrl;
  std::string mTmpFile;
  std::string mQuery;
  int  mDebug;
};

#endif // LSCSEGFIND_HH
