/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "web/xmlform.hh"
#include "web/webxmledit.hh"
#include "goption.hh"
#include <unistd.h>
#include <string>
#include <iostream>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <cstdlib>

   using namespace std;
   using namespace web;


   const char* const help_text = 
   "usage: webxmledit [-d 'basedir'] [-e 'ext'] [-t 'title'] \\\n"
   "                  [-p 'port'] [-l 'logfile'] [-fv]\n"
   "       -d 'basedir' : base directory of the XML files (default '.')\n"
   "       -e 'ext' : specifies the file extension (default 'xml')\n"
   "       -t 'title' : title of web page\n"
   "       -p 'port' : specifies a port number other than 80\n"
   "       -l 'logfile' : specifies a log file\n"
   "       -f : don't fork\n"
   "       -v : verbose";


   int main (int argn, char** argv)
   {
      gdsbase::option_string opt (argn, argv, "d:e:t:p:l:fvh");
      if (opt.help()) {
         cout << help_text << endl;
         return 0;
      }
      // base directory
      string basedir = ".";
      opt.getOpt ('d', basedir);
      // file extension
      string ext = "xml";
      opt.getOpt ('e', ext);
      // title
      string title = "XML Parameter Configuration";
      opt.getOpt ('t', title);
      // port
      string port = "80";
      opt.getOpt ('p', port);
   
      // log file
      string logfile;
      ostream* log = 0;
      if (opt.getOpt ('l', logfile)) {
         log = new ofstream (logfile.c_str(), ios::out | ios::app);
         if (!*log) {
            cerr << "Error opening log file" << endl;
            delete log;
            exit (1);
         }
      }
   
      // fork if background
      if (!opt.opt ('f')) {
         pid_t pid = fork();
         if (pid == -1) {
            cerr << "Fork error: Unable to start background process" << endl;
            exit (1);
         }
         // quit if parent
         else if (pid != 0) {
            exit (0);
         }
         // become session leader
         setsid ();
      }
   
      // silence output if not verbose
      if (!opt.opt ('v')) {
         int i = ::open ("/dev/null", 2);
         (void) dup2 (i, 1);
         (void) dup2 (i, 2);   
      }
   
      // start server
      const char* _argv[4] = {0, 0, 0, 0};
      _argv[0] = argv[0];
      _argv[1] = "-p";
      _argv[2] = port.c_str();
      xmlform_server server (3, (char**)_argv, title.c_str(),
                           basedir.c_str(), ext.c_str());
      server.SetLog (log);
      server.Listen();
      cerr << "Server terminated unexpectedly" << endl;
   }

