/*----------------------------------------------------------------------*/
/*                                                         	         	*/
/* Module Name: monweb							                              */
/*                                                         	         	*/
/* Module Description: web server class for monitor data and provide    */
/* graphical representation. It requires the 'graph' utility of the     */
/* plotutils package.	                                             	*/
/*                                                                      */
/* Revision History:					                                 		*/
/* Rel   Date     Programmer  	Comments	                      			*/
/* 0.1	4Jan02   D. Sigg    	First release	          	     		      */
/* 0.2  15July02  Sz. Marka   Graphics support                          */
/*                                                                      */
/* Documentation References:				                                 */
/*	Man Pages: webmon.html			                                       */
/*	References: none				                                          */
/*                                                                  		*/
/* Author Information:			                              				*/
/* Name          Telephone       Fax             e-mail 	          	   */
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	   */
/* Szabi Marka   (626) 395-2005                  smarka@ligo.caltech.edu*/
/*                                                         	          	*/
/*                                                         	          	*/
/*                      -------------------                             */
/*                                                         	          	*/
/*                             LIGO				                          	*/
/*                                                         	          	*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.   	*/
/*                                                         		         */
/*                     (C) The LIGO Project, 1999.	                 		*/
/*                                                                   	*/
/*                                                                   	*/
/* Caltech				MIT		   	                                 	*/
/* LIGO Project MS 51-33		LIGO Project NW-17 161		               */
/* Pasadena CA 91125			Cambridge MA 01239 		                     */
/*                                                         	         	*/
/* LIGO Hanford Observatory		LIGO Livingston Observatory         	*/
/* P.O. Box 1970 S9-02			19100 LIGO Lane Rd.		                  */
/* Richland WA 99352			Livingston, LA 70754	                      	*/
/*                                                         	         	*/
/*----------------------------------------------------------------------*/

#ifndef _LIGO_WEBVIEW_H
#define _LIGO_WEBVIEW_H

#include "web/monweb.hh"
#include <cstdlib>
#include <cmath>
#include <stdio.h>


/** @name Web server for displaying montitor data
    This web server displays data from the DMT monitors which 
    are exported by monitor API. Result pages are created 
    dynamically.

    \begin{verbatim}
    usage: webview [-p 'port'] [-l 'logfile'] [-fv]
           -p 'port' : specifies a port number  (an integer within the 3999 < p < 10000 range) 
           -l 'logfile' : specifies a log file
           -f : don't fork
           -v : verbose
    \end{verbatim}

    @memo Data monitor web server
    @author Written January 2002 by Daniel Sigg
    @version 1.0
 ************************************************************************/

#endif // _LIGO_WEBVIEW_H
