/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "PConfig.h"
#include "web/webview.hh"
#include "web/monweb.hh"
#include "goption.hh"
#include <unistd.h>
#include <iostream>
#include <fstream>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>

   using namespace std;
   using namespace web;

   const int portmin(4000), portmax(10000);

   static std::ostream&
   usage(std::ostream& out) {
      out << "usage: webview [-p 'port'] [-l 'logfile'] [-fv]" << endl
	  << "       -p 'port' : specifies a port number (within the range "
	  << portmin << " <= p < " << portmax << ")" << endl
	  << "       -l 'logfile' : specifies a directory/log file" << endl
	  << "       -f : will fork" << endl
	  << "       -v : verbose" << endl;
      return out;
   }

   int main (int argn, char** argv)
   {
      gdsbase::option_string opt (argn, argv, "p:l:fvh");
   
      string portnum;
      opt.getOpt ('p', portnum);
      int pn = (int) floor(atof(portnum.c_str()));
   
      if (opt.help()) {
         usage(cout);
         return 0;
      }

   	// silence output if not verbose
      if (!opt.opt ('v')) {
         //cout << "WebView is silent!" << endl;  
         int i = ::open ("/dev/null", 2);
         (void) dup2 (i, 1);
         //(void) dup2 (i, 2);  
      }
      else  {
         cout << "WebView is verbose!" << endl;
      }
   
      // exit if port is not specified or the range is wrong
      if (!opt.opt ('p')) {
         cerr << "Port error: A port number must be specified!" << endl;
         exit (1);
      }
      else if ( ( pn<portmin ) || ( pn >= portmax ) ) {
         cerr << "Port error: The port number must be within the range "
	      << portmin << " <= p < " << portmax << " range!" << endl;
         exit (1);
      }
      else {
         cout << "WebView is listening on port # : " << pn << endl; 
      }
   
      // log file
      string logfile;
      ofstream* log = 0;
      if (opt.getOpt ('l', logfile)) {
         log = new ofstream (logfile.c_str(), ios::out | ios::app);
         if (!*log) {
            cerr << "Error opening log file" << endl;
            delete log;
            exit (1);
         }
         cout << "WebView logs are going into: " << logfile << endl; 
      }
   
      // fork if background
      if (opt.opt ('f')) {
         pid_t pid = fork();
         if (pid == -1) {
            cerr << "Fork error: Unable to start background process" << endl;
            exit (1);
         }
         // quit if parent
         else if (pid != 0) {
            exit (0);
         }
         // become session leader
         setsid ();
         cout << "WebView is forked!" << endl; 
      }
   
#if defined (P__DARWIN)
      signal(SIGCHLD, SIG_DFL);
#else
      signal(SIGCLD, SIG_DFL);
#endif

      // start server
      strcpy(argv[1],"-p");
      strcpy(argv[2],portnum.c_str());
      argv[3]=argv[argn];
      argn=3;
   
      monweb_server server (argn, argv);
      server.SetLog (log);
      server.Listen();
      cerr << "Server terminated unexpectedly" << endl;
      if (log) {
	  log->close();
	  delete log;
      }
   }
