/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "TrigWriter.hh"
#include "TrigProc.hh"
#include "lmsg/ErrorList.hh"

namespace trig {

    TrigWriter::TrigWriter(void) 
	: mDebug(0)
    {
    }

    TrigWriter::~TrigWriter(void) {
    }

    bool
    TrigWriter::empty(const Time& t) const {
	return !getNSegs(t) && !getNTrigs(t);
    }

    lmsg::index_type
    TrigWriter::getDebug(void) const {
	return mDebug;
    }
    Time 
    TrigWriter::getEarly(void) const {
	return Time(0);
    }

    int 
    TrigWriter::getNSegs(const Time& t) const {
	return 0;
    }

    int 
    TrigWriter::getNTrigs(const Time& t) const {
	return 0;
    }

    void
    TrigWriter::setDebug(lmsg::index_type d) {
	mDebug = d;
    }

    lmsg::error_type
    TrigWriter::setProcess(const trig::TrigProc& p) {
	mProcess = p;
	return lmsg::OK;
    }

} // namespace trig
