/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "NameMsg.hh"
#include "lmsg/TransInput.hh"
#include "lmsg/TransOutput.hh"
#include <netinet/in.h>

using namespace std;
using namespace lmsg;

//======================================  Default constructor
NameData::NameData(void) {
}

//======================================  Data constructor
NameData::NameData(const string& Name, const MsgAddr& Addr, NameProcs PType)
  : mName(Name), mAddr(Addr), mPType(PType)
{
}

//======================================  Destructor
NameData::~NameData(void) {}

//======================================  Name data size
size_type 
NameData::size(void) const {
    return sizeof(short) + mName.size() + sizeof(mAddr) + sizeof(mPType);
}
 
//======================================  Set the address field
void
NameData::setAddr(const MsgAddr& addr) {
    mAddr = addr;
}

//======================================  Fix incomplete Addresses
void 
NameData::fixAddr(const MsgAddr& from) {
    if (!mAddr.getIPAddr() || mAddr.getIPAddr() == INADDR_LOOPBACK) {
        mAddr.setIPAddr(from.getIPAddr());
    }
}

//======================================  Data input function
TransInput& 
operator>>(TransInput& in, NameData& nd) {
    string name;
    MsgAddr addr;
    int type;
    in >> name >> addr >> type;
    nd = NameData(name, addr, NameProcs(type));
    return in;
}

//======================================  Data output function
TransOutput& 
operator<<(TransOutput& out, const NameData& nd) {
    out << nd.refName() << nd.getAddr() << int(nd.getPType());
    return out;
}


//======================================  DataMsg templates
template<class T, unsigned int MsgID>
void 
DataMsg<T,MsgID>::getData(TransOutput& out) const {
    out << mData;
}

template<class T, unsigned int MsgID>
void 
DataMsg<T,MsgID>::setData(TransInput& in) {
    in >> mData;
}

template class lmsg::DataMsg<NameData, m_addName>;
template class lmsg::DataMsg<NameData, m_lookup>;
template class lmsg::DataMsg<NameData, m_remName>;
template class lmsg::DataMsg<NameData, m_status>;
template class lmsg::DataMsg<NameData, m_index>;
template class lmsg::DataMsg<int,      m_IDget>;
