#include <time.h>
#include "MonIndex.hh"
#include "MonClient.hh"

MonIndex::Entry::Entry(const std::string& Type, const std::string& Comment)
  : mType(Type), mComment(Comment)
{
}

MonIndex::Entry::Entry(const Entry& x)
  : mType(x.mType), mComment(x.mComment) 
{
}

MonIndex::Entry::~Entry(void) {
}

const char* 
MonIndex::Entry::getType(void) const {
    return mType.c_str();
}

const char* 
MonIndex::Entry::getComment(void) const {
    return mComment.c_str();
}

MonIndex::MonIndex(void) {
}

MonIndex::MonIndex(MonClient& mc) {
    setIndex(mc);
}

MonIndex::MonIndex(const char* Server) {
    setIndex(Server);
}

MonIndex::~MonIndex(void) {
    clear();
}

void
MonIndex::clear(void) {
    mIndex.clear();
}

bool 
MonIndex::exists(const std::string& Name) const {
    return find(Name) != end();
}

const char* 
MonIndex::getComment(const std::string& Name) const {
    const_index_iterator iter = find(Name);
    if (iter != end()) return getComment(iter);
    else return "";
}

const char* 
MonIndex::getComment(const_index_iterator& iter) const {
    return iter->second.getComment();
}

const char* 
MonIndex::getName(const_index_iterator& iter) const {
    return iter->first.c_str();
}

const char* 
MonIndex::getType(const std::string& name) const {
    const_index_iterator iter = find(std::string(name));
    if (iter != end()) return getType(iter);
    else return "";
}

const char* 
MonIndex::getType(const_index_iterator& iter) const {
    return iter->second.getType();
}

bool 
MonIndex::setIndex(const char* Server) {
    MonClient mc(Server);
    return setIndex(mc);
}

bool 
MonIndex::setIndex(MonClient& mc) {
    std::string Index;
    lmsg::error_type err = mc.getIndex(Index);
    int len = Index.length();
    for (int inx=0 ; inx < len ; ) {
        int lName = Index.substr(inx).find(";");
	std::string Name(Index.substr(inx,lName));
	inx += lName+1;

        int lType = Index.substr(inx).find(";");
	std::string Type(Index.substr(inx,lType));
	inx += lType+1;

        int lComm = Index.substr(inx).find("\n");
	std::string Comment(Index.substr(inx,lComm));
	inx += lComm+1;
	mIndex[Name] = Entry(Type, Comment);
    }
    return (err == 0);
}
