#include "AlarmData.hh"
#include <fnmatch.h>

using namespace std;

//======================================  Alarm handler
long AlarmHandle::mNext(0);

AlarmHandle 
AlarmHandle::getUnique(void) {
    return AlarmHandle(++mNext);
}

//======================================  Alarm ID methods
AlarmID::AlarmID(const string& ID, const string& Monitor) 
  : mMonitor(Monitor), mAlarmID(ID)
{}

AlarmID::~AlarmID(void) {
}

AlarmID& 
AlarmID::operator=(const AlarmID& x) {
    mMonitor = x.mMonitor;
    mAlarmID = x.mAlarmID;
    return *this;
}

bool
AlarmID::match(const AlarmID& id) const {
    return (!fnmatch(id.mMonitor.c_str(), mMonitor.c_str(), 0) &&
	    !fnmatch(id.mAlarmID.c_str(), mAlarmID.c_str(), 0));
}

void
AlarmID::setAlarm(const string& id) {
    mAlarmID = id;
}

void
AlarmID::setMonitor(const string& mon) {
    mMonitor = mon;
}

//======================================  AlarmData class implementation
AlarmData::AlarmData(void)
  : mTimeout(0.0), mStart(0), mSeverity(0), mFlags(kNone)
{}

AlarmData::AlarmData(const AlarmData& x)
  : AlarmID(x)
{
    operator=(x);
}

AlarmData::AlarmData(const string& Monitor, const string& ID, Interval timeout,
		     int severe, const string& desc, const string& params) 
  : AlarmID(ID, Monitor), mTimeout(timeout), mSeverity(severe), mFlags(kNone),
    mParams(params)
{
    setDescription(desc);
}

AlarmData &
AlarmData::operator=(const AlarmData& x) {
    AlarmID::operator=(x);
    mTimeout  = x.mTimeout;
    mStart    = x.mStart;
    mSeverity = x.mSeverity;
    mFlags    = x.mFlags;
    mDescribe = x.mDescribe;
    mParams   = x.mParams;
    mWebFile  = x.mWebFile;
    mMultiMedia = x.mMultiMedia;
    return *this;
}

bool
AlarmData::operator==(const AlarmData& x) {
    return AlarmID::operator==(*this) && (mParams == x.mParams);
}

void 
AlarmData::addParameter(const string& param) {
    if (!mParams.empty()) mParams += " ";
    if (param.find(" ") >= param.npos) {
	mParams += param;
    } else {
        mParams += "\"";
	mParams += param;
        mParams += "\"";
    }
}

void 
AlarmData::clearParameters(void) {
    mParams.erase();
}

void 
AlarmData::clearFlags(flag_t flags) {
    mFlags &= ~flags;
}

void 
AlarmData::jamFlags(flag_t flags) {
    mFlags |= flags;
}

void 
AlarmData::minSeverity(int severe) {
    if (severe < mSeverity) mSeverity = severe;
    if (mSeverity < 0) mSeverity = 0;
}

void 
AlarmData::prolong(Interval dT) {
    mTimeout += dT;
}

void 
AlarmData::setAcknowledge(bool onoff) {
    if (onoff) mFlags |= kAcknowledged;
    else       mFlags &= ~kAcknowledged;
}

void 
AlarmData::setDescription(const string& desc) {
    if      (desc.substr(0,7) == "file://") mWebFile  = desc;
    else if (desc.substr(0,7) == "http://") mWebFile  = desc;
    else                                    mDescribe = desc;
}

void 
AlarmData::setMultiMedia(const string& param) {
    mMultiMedia = param;
}

void 
AlarmData::setParameters(const string& param) {
    mParams = param;
}

void 
AlarmData::setStartTime(const Time& t) {
    mStart = t;
}

void 
AlarmData::setTimeout(Interval dt) {
    mTimeout = dt;
}


void 
AlarmData::setWebFile(const string& param) {
    mWebFile = param;
}


