/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "DQ_Bit.hh"

using namespace std;

/**  The %DQ_TestValid tool tests whether input tseries j\have valid data 
  *  (i.e. Whether the dataValid flag is zero). The DQ_TestValid function
  *  returns true if all input channels have valid data.
  *  \brief Test bit patterns in an input channel.
  */
class DQ_TestValid : public DQ_bit {
public:
   /**  A null init() function is supplied - there is no intialization 
     *  needed for The function as defined.
     */
   void init(void) {
   }

   /**  This function evaluates the data valid conditions. Each of the 
     *  the input time series (data[i]) are tested using the TSeries::isGood()
     *  method. If any Series is empty or has a dataValid error, the function 
     *  returns false. Otherwise the function true.
     *  \brief Test the data validity
     *  \param data Contains a vector of time series (TSeries) instances to 
     *              be tested.
     *  \returns True if data in all input series are valid.
     */
   bool bit_value(const tser_vect& data) {
      size_t N=data.size();
      if (!N) return false;
      for (size_t i=0; i<N; i++) {
	 if (data[i].empty() || !data[i].isGood()) return false;
      }
      return true; 
   }
   
private:
};

//======================================  Define the dynamic load entry point
DQ_PLUGIN(DQ_TestValid)
