#ifndef LockStatus_HH
#define LockStatus_HH

#include "DaccAPI.hh"
#include "Interval.hh"
#include "Time.hh"

// const char* const kH1LockChannel = "H1:LSC-LA_State_Bits_Read";
// const char* const kH2LockChannel = "H2:LSC-LA_State_Bits_Read";
// const char* const kL1LockChannel = "L1:LSC-LA_State_Bits_Read";
const char* const kH1LockChannel = "H1:IFO-SV_STATE_VECTOR";
const char* const kH2LockChannel = "H2:IFO-SV_STATE_VECTOR";
const char* const kL1LockChannel = "L1:IFO-SV_STATE_VECTOR";
// const char* const kH1MCLockChannel = "H1:IOO-MC_LOCK";
// const char* const kH2MCLockChannel = "H2:IOO-MC_LOCK";
// const char* const kL1MCLockChannel = "L1:IOO-MC_LOCK";

class LockStatus {
public:
	enum SiteType {
	kLHO = 0,
	kLLO = 1
	};

	enum LockType {
	kInvalid = -1,
	kH1 = 0,
	kH2 = 1,
	kL1 = 2,
	kH1MC = 3,
	kH2MC = 4,
	kL1MC = 5
	};
	
	enum StatusType {
	kNonLock = 0,
	kLost = 1,
	kGained = 2,
	kLock = 3
	};

private:
	std::string fName[6];
	Time fStart[6];
	Interval fWait;
	StatusType fLock[6];
	bool fStable[6];
	SiteType fSite;

public:
	LockStatus() : fWait (Interval(10.0)) {
		for ( int i = 0; i < 6; ++i ) {
			fLock[i] = kNonLock;
			fStable[i] = false;
		}
	}
	~LockStatus() {
	}

	Time GetLockStartTime ( LockType ifo ) const {
		return fStart[ifo];
	}
	
	int GetLockStatus ( int ifo ) const;
	
	bool IsStable ( int ifo ) const;

	void Check ( const DaccAPI& dacc );

	void SetWait ( const float t ) {
		fWait = Interval ( (double)t );
	}

	void Register ( DaccAPI& dacc, int s );

private:
	void CheckLockStatus ( const DaccAPI& dacc, LockType ifo );
	bool CheckLockBits ( const int* data, LockType ifo );
};

#endif
