//
//  Function FOM3unknown:  Helper function for PulsarMon.  Reads an
//  FSpectrum "psd" and copies Ellipticity for unknown pulsar at 1kpc, 1 year IT into a second
//  FSpectrum "out".
//
///////////////////////////////////////////////////////////////////////////

#include "FOM3unknown.hh"
#include <cmath>
using namespace std;

void FOM3unknown(FSpectrum& out, FSpectrum& psd)
{
	//----- Set FSpectrum out equal to FSpectrum psd.
	out = psd;
       
	//----- Initialize items necessary to prepare the integrand.
	int nsteps = out.getNStep();
	double low_freq = out.getLowFreq();
	double f_step = out.getFStep();
     	float *data = new float[nsteps + 1];
	float *datafreq = new float[nsteps + 1];

	//----- Copy data from out object to data array.
	out.getData(nsteps + 1, data);
	

         for (int i = 0; i < (nsteps + 1); i++)
         { 
          datafreq[i]=low_freq+f_step*i;
         }

       	 for (int i = 0; i < (nsteps + 1); i++)
     	  {
	   
      	  data[i] = 9.5e-6 * pow(datafreq[i]/1000,-2) *data[i]/1e-23 /pow(365*60*60*24,0.5);
        }
        
        // cerr<<data[1000]<<""<<"ellipt"<<endl;

	//----- Send data back to FSpectrum object.
	out.setData(nsteps + 1, data);
	
        delete [] data;
        delete [] datafreq;
}
