#ifndef PSLFILTER_HH
#define PSLFILTER_HH

#include "TSeries.hh"
#include "autopipe.hh"
#include <string>

class PSLfilter : public auto_pipe {
public:
  PSLfilter(void);
  explicit PSLfilter(const std::string& name);
  PSLfilter(const std::string& name, const Pipe& p, Interval tSettle=0.0);
  ~PSLfilter(void);
  Interval getDelay(void) const;
  const char* getName(void) const;
  const char* getQuip(void) const;
  Interval getSettle(void) const;
  bool isNull(void) const;
  void setName(const std::string& name);
  void setQuip(const std::string& quip);
  void setSettle(Interval t);
private:
  std::string mName;
  std::string mQuip;
  Interval    mSettle;
};

//======================================  Inline PSLfilter methods.
inline Interval
PSLfilter::getSettle(void) const {
    return mSettle;
}

inline const char*
PSLfilter::getName(void) const {
    return mName.c_str();
}

inline const char*
PSLfilter::getQuip(void) const {
    if (mQuip.empty()) return mName.c_str();
    return mQuip.c_str();
}

#endif
