#include "PSLCorr.hh"
#include "PSLChan.hh"

using namespace std;

//======================================  Frequency Band constructor
PSLCorr::PSLCorr(const string& name, const PSLChan* chan, const PSLChan* chanB)
  : mName(name), mChanA(chan), mChanB(chanB), mCorr(-1.0), mBmin(0.0), 
  mBmax(0.0), mAmin(0.0), mAmax(0.0), mDmax(0.0), mFmin(0.0), mFmax(0.0),
  mDebug(0)
{}

//======================================  Copy constructor
PSLCorr::PSLCorr(const PSLCorr& x)
  : mName(x.mName), mChanA(x.mChanA), mChanB(x.mChanB), mCorr(x.mCorr), 
    mBmin(x.mBmin), mBmax(x.mBmax), mAmin(x.mAmin), mAmax(x.mAmax), 
  mDmax(x.mDmax), mFmin(x.mFmin), mFmax(x.mFmax), mDebug(x.mDebug)
{}

//======================================  Frequency Band constructor
PSLCorr::~PSLCorr(void) {
}

//======================================  Frequency Band constructor
bool 
PSLCorr::crunch(void) {

    //----------------------------------  Get the band coherence
    //   Note that coherence within a bin is combined a
    //       |Sum(i; x[i] * ~y[i])|^2 / (|Sum(i; x[i])|^2 * |Sum(i; y[i])|^2) 
    if (mBmin == mBmax) {
        mBmin = 0;
	mBmax = mChanA->refFSeries().getHighFreq();
    }
    FSeries fsa(mChanA->refFSeries().extract(mBmin, mBmax));
    FSeries fsb(mChanB->refFSeries().extract(mBmin, mBmax));
    fComplex corr = fsa * fsb;
    mCorr = corr.MagSq() / (fsa.Power() * fsb.Power());

    //----------------------------------  Look for a trigger
    bool trig(false);
    if (mAmin != mAmax && (mCorr < mAmin || mCorr >= mAmax)) {
        trig = true;
    } else if (mLast < 0.0) {

    } else if (mDmax != 0 && (mCorr-mLast > mDmax || mLast-mCorr > mDmax)) {
        trig = true;
    } else if (mCorr < mLast*mFmin) {
        trig = true;
    } else if (mFmax != 0 && mCorr > mLast*mFmax) {
        trig = true;
    }
    return trig;
}

//======================================  get Channel names
const char*
PSLCorr::getChannelA(void) const {
    if (!mChanA) return "";
    return mChanA->getChannel();
}

const char*
PSLCorr::getChannelB(void) const {
    if (!mChanB) return "";
    return mChanB->getChannel();
}

//======================================  Reset
void 
PSLCorr::reset(void) {
    mLast = mCorr;
}

//======================================  Specify frequency band
void 
PSLCorr::setBand(double Flow, double Fhigh) {
    mBmin = Flow;
    mBmax = Fhigh;
    // cout << "Band low,high = " << mBmin << ", " << mBmax << endl;
}

//======================================  Specify Enable condition name
void
PSLCorr::setEnableCond(const string& str) {
    mEnableCond = str;
}

//======================================  Specify frequency band
void 
PSLCorr::setTrend(const string& trend) {
    mTrend = trend;
}

//======================================  Set absolute limits
void 
PSLCorr::setAbsLimit(double Alow, double Ahigh) {
    mAmin = Alow;
    mAmax = Ahigh;
}

//======================================  Set difference limit
void 
PSLCorr::setDeltLimit(double Dmax) {
    mDmax = Dmax;
}

//======================================  Set fractional limit(s)
void 
PSLCorr::setFracLimit(double Fmax) {
    mFmax = Fmax;
    mFmin = 1.0/mFmax;
}

void 
PSLCorr::setFracLimit(double Fmin, double Fmax) {
    mFmax = Fmax;
    mFmin = Fmin;
}
