/* -*- mode: c++; c-basic-offset: 3; -*- */
#include "spline_psd.hh"
#include "spline.hh"
#include "lcl_array.hh"
#include "DVecType.hh"
#include <stdexcept>

using namespace std;
using namespace containers;

containers::PSD
spline_psd(const containers::PSD& psd, double dF) {
  if (psd.empty() || !psd.single_sided())
    throw std::runtime_error("psd not valid for spline_psd interpolation");
  size_t nPoints = psd.getNStep() + 1;
  lcl_array<double> rowFreq(nPoints);
  double f0    = psd.getLowFreq();
  double rowDf = psd.getFStep();
  for (size_t i=0; i<nPoints; ++i) rowFreq[i] = f0 + double(i) * rowDf;

  // interpolate to desired horizontal resolution, copy to display matrix
  lcl_array<double> rowYp(nPoints);
  size_t nInterp = rowDf * double(nPoints - 1) / dF + 1;
  lcl_array<double> freax(nInterp);
  for (size_t i=0; i<nInterp; ++i) freax[i] = f0 + double(i) * dF;
  
  DVectD dvd(nInterp);
  const double* rowY = dynamic_cast<const DVectD&>(psd.refDVect()).refTData();
  spline_pchip_set(nPoints, rowFreq, rowY, rowYp);
  spline_pchip_val(nPoints, rowFreq, rowY, rowYp,
		   nInterp, freax, dvd.refTData());
  containers::PSD out;
  static_cast<fSeries&>(out) = fSeries(f0, dF, psd.getStartTime(),
				       psd.getDt(), dvd);
  return out;
}
