#ifndef AGGLOM_CLUSTER_TREE_HH
#define AGGLOM_CLUSTER_TREE_HH
#include <vector>
#include <string>

const size_t ACT_null_id=~0;

/**  Agglomerative clustering tree.
 */
class AgglomClusterTree {
public:
   AgglomClusterTree(size_t N, double distances[], 
		     const std::string& method="single");
   size_t cluster(const std::string& method, double cutoff, 
		  std::vector<size_t>& clust) const;
   struct glom {
      glom(size_t l1=0, size_t l2=0, double d=-1);
      size_t _link1;
      size_t _link2;
      double _distance;
   };
private:
   std::vector<glom> _tree;
};
#endif // !defined(AGGLOM_CLUSTER_TREE_HH)
