/***************************************************************************
    File        : Parameter.cpp
    Description : Implements the class Parameter
 ---------------------------------------------------------------------------
    Begin       : Tue Mar 22 2005
    Author(s)   : Roberto Grosso
 ***************************************************************************/
 
#include "Parameter.h"


// ReadParameters
//  Read the Noise Floor parameters from file
void
gwd::Parameter::ReadParameters(const std::string& filename)
{
  int count = 0;
  std::ifstream theFile;
  std::string channelname;
  double frequency;
  double samplerate;

  theFile.open(filename.c_str(),std::ios::in);
  if (!(theFile.is_open()) || theFile.fail())
  {
    char buf[1024];
    sprintf(buf,"can't open file %s",filename.c_str());
    std::cout << "ERROR: " << buf << std::endl;
  }
  else
  {
    // read Sensor mode
    while(!theFile.eof())
    {
      // Read one complete line at a time
      char buffer[1024];
      theFile.getline(buffer,1024);

      // Check if it is an empty line
      if (buffer[0] == '\n')
        continue;

      // remove leading empty spaces
      char* tmpch = &buffer[0];
      while (*tmpch == ' ')
        tmpch++;
      // Check if it is an empty line, a zero or a comment line
      if (*tmpch == '\n' || *tmpch == '\0' || *tmpch == '#')
        continue;

      // Read the parameters
      //string s = "34 22";
      std::string keyword;
      std::string eqs;
      bool flag = false;
      std::string s = tmpch;
      std::istringstream ins; // Declare an input string stream.  
      ins.str(s);        // Specify string to read.
      ins >> keyword;     // Reads the integers from the string.
      if (keyword == "DETECTOR")
      { if (!(ins >> eqs) || !(ins >> mDetectorSite)) flag = true; }
      else if (keyword == "CHANNEL")
      {
        if (!(ins >> eqs) || !(ins >> channelname) || !(ins >> samplerate)) flag = true;
        else
        {
          mChannel.push_back(channelname);
          mChannelSampleRate.push_back(samplerate);
        }
      }
      else if (keyword == "NOTCH_FILTER_ORDER")
      { if (!(ins >> eqs) || !(ins >> mOrderNotchFilter)) flag = true; }
      else if (keyword == "UPDATE_WHITENING_FILTER")
      { if (!(ins >> eqs) || !(ins >> mUpdateWhiteFlt)) flag = true; }  
      else if (keyword == "ORDER_WHITENING_FILTER")
      { if (!(ins >> eqs) || !(ins >> mOrderWhiteFilter)) flag = true; }
      else if (keyword == "FREQUENCIES_PSD")
      { if (!(ins >> eqs) || !(ins >> mNoOfFreqPsd)) flag = true; }
      else if (keyword == "SIZE_PSD")
      { if (!(ins >> eqs) || !(ins >> mSizePsd)) flag = true; }
      else if (keyword == "RM_FILTER_FOR_WHITENING_FILTER")
      { if (!(ins >> eqs) || !(ins >> mRMSizeForWhiteningFlt)) flag = true; }
      else if (keyword == "SIZE_RM_FILTER")
      { if (!(ins >> eqs) || !(ins >> mWindowSizeRunningMedian)) flag = true; }
      else if (keyword == "FLT_ORDER")
      { if (!(ins >> eqs) || !(ins >> mFltOrder)) flag = true; }
      else if (keyword == "CUTOFF_FREQ")
      { if (!(ins >> eqs) || !(ins >> mUpperCutoffFreq)) flag = true; }
      else if (keyword == "BAND_FLT_ORDER")
      { if (!(ins >> eqs) || !(ins >> mBandFltOrder)) flag = true; }
      else if (keyword == "BAND_FREQ")
      {
        if (!(ins >> eqs) || !(ins >> frequency)) flag = true;
        else mFreqBand.push_back(frequency);
      }
      else if (keyword == "TIME_STRIDE")
      { if (!(ins >> eqs) || !(ins >> mTimeStride)) flag = true; }
      else if (keyword == "OVERSAMPLE_FACTOR")
      { if (!(ins >> eqs) || !(ins >> mOverSamplingFactor)) flag = true; }
      else
      {
        std::cout << "ERROR: unknown keyword " << keyword << " in parameter file: " << filename << std::endl;
        exit(1);
      }

      if (flag)
      {
        std::string message = "Check sintax for paramter " + keyword + "  in parameter file " + filename;
        std::cout << message << std::endl;
        exit(1);
      }
      else
        count++;
    }
  }
  theFile.close();

  // Set auxiliary variables
  mNoChannels  = mChannel.size();
  mFreqBand.push_back(mUpperCutoffFreq);
  mNoFreqBands = mFreqBand.size();
  // sort frequencies to avoid user input error
  std::sort(mFreqBand.begin(),mFreqBand.end());
  
  // Find out name of main channel
  for (int ii = 0; ii < (int)mNoChannels; ii++)
  {
    if (mChannel[ii] == "H1:LSC-DARM_ERR" || mChannel[ii] == "H2:LSC-DARM_ERR")
    { 
      if (mDetectorSite != "HA")
      {
        std::cout << "ERROR: detector site: " << mDetectorSite << " and main channel: " << mChannel[ii] << " are wrong" << std::endl;
        exit(1);
      }
      mMainChannel.push_back(mChannel[ii]);
    }
    else if (mChannel[ii] == "L1:LSC-DARM_ERR")
    {
      if (mDetectorSite != "LA")
      {
        std::cout << "ERROR: detector site: " << mDetectorSite << " and main channel: " << mChannel[ii] << " are wrong" << std::endl;
        exit(1);
      }
      mMainChannel.push_back(mChannel[ii]);
    }
  }
}

