/***************************************************************************
    File        : Exception.h
    Description : base class for exception and error handling
 ---------------------------------------------------------------------------
    Begin       : Mon Sep 17 2001
    Author(s)   : Roberto Grosso
 ***************************************************************************/



#ifndef __EXCEPTION_H
#define __EXCEPTION_H

// Libs
#include <cstdio>
#include <string>


namespace gwd {



class Exception {
public:
  // Constructors
  Exception() {}
  
  // Desctructors
  virtual ~Exception() { }

  //! Set the error message.
  void SetErrorMessage(std::string& errm) { mErrorText = errm; }
  //! Print the error message.
  void GetErrorMessage(std::string& errm) { errm = mErrorText; }
  const char* GetErrorMessage() { return mErrorText.c_str(); }

private:
  //! The error text.
  std::string mErrorText;
};

} // namsespace gwd


#endif // __EXCEPTION_H
