// $Id: InspiralMon.hh 3120 2004-12-10 19:36:57Z duncan.brown $

#include "DMTServer.hh"
#include "TSeries.hh"
#include "FixedLenTS.hh"
#include "Histogram1.hh"
#include "TriggerFiles.hh"
#include <string>
#include <map>

class InspiralMon : public DMTServer {
public:
  InspiralMon(int argc, const char* argv[]);
  ~InspiralMon(void);
  void ProcessData(const Time& t);
private:

  // name of the monitor
  std::string mIFOName;

  // update parameters
  Interval mDelay;              // time shift for testing
  Time mLastUpdate;             // time of last update
  Interval mLength;             // length of time series
  Interval mStep;               // dt for time series
  TriggerFiles mTrigFiles;      // input trigger files

  // data to server to dmt viewer
  FixedLenTS mTS_A;             // analyzed data
  FixedLenTS mTS_N;             // number of triggers
  FixedLenTS mTS_D;             // optimal distance
  FixedLenTS mTS_T_mean;        // mean triggers snr
  FixedLenTS mTS_T_max;         // max trigger snr
  FixedLenTS mTS_T_min;         // min trigger snr

  // inspiral parameters
  double mMinSnr;               // minimum snr (threshold)
  double mMaxSnr;               // max snr for histogram
  double mMaxChiSq;             // max chisq for histogram
  double mChisqBins;            // number of chisq binsa
  double mChisqDeltaSq;         // chisq deltasq value

  // histogram data
  typedef std::multimap< unsigned long, float, std::less< unsigned long > > 
    mmsnr_t;
  mmsnr_t    mSnrSqData;         // trigger time and snr
  mmsnr_t    mChiSqData;         // trigger time and chi
  Histogram1 mSHist2;            // last 2 hours
  Histogram1 mSHist6;            // last 6 hours
  Histogram1 mSHist12;           // last 12 hours
  Histogram1 mCHist2;            // last 2 hours
  Histogram1 mCHist6;            // last 6 hours
  Histogram1 mCHist12;           // last 12 hours
};

