#include "UniformNoise.hh"
#include "Time.hh"
#include "constant.hh"
#include "rndm.hh"
#include <math.h>

//-------------------------------------  UniformNoise Constructor.
UniformNoise::UniformNoise(double Freq, const Interval& dT, const Time& t0)
  : mT0(t0), mTc(t0), mFny(Freq)
{
    mFny = Freq;
    mTl  = t0 + dT;
}

//-------------------------------------  Frequency domain template bin.
fComplex 
UniformNoise::Fspace(double Freq, double dF) const {
    double rn = twopi*Rndm();
    return fComplex(::cos(rn), ::sin(rn));
}

//-------------------------------------  Time domain template bin.
double 
UniformNoise::Tspace(const Time& t0) const {
    return Ampl(t0)*(2.0*Rndm() - 1.0);
}

//-------------------------------------  Get the t0.
Time 
UniformNoise::getT0(void) const {
    return mT0;
}

//-------------------------------------  Get the End time.
Time
UniformNoise::getTEnd(void) const {
    return mTl;
}

//-------------------------------------  Get the Critical time.
Time
UniformNoise::getTc(void) const {
    return mTc;
}

//-------------------------------------  Time versus Frequency.
Time
UniformNoise::TvsF(double f) const {
    return mT0;
}

//-------------------------------------  Waveform Frequency.
double
UniformNoise::freq(const Time& t) const {
    return mFny/2.0;
}

//-------------------------------------  Waveform Phase angle.
double
UniformNoise::phi(const Time& t) const {
    return 0.0;
}

//-------------------------------------  Amplitude.
double 
UniformNoise::Ampl(const Time& t) const {
    return 1.0;
}
