#include "Chirp.hh"
#include "Interval.hh"
#include <iostream>
#include <math.h>

//--------------------------------------  Return heterodyned F(t)
Chirp::Complex
Chirp::Tspace(const Time& t, double f0) const {
    Complex r;
    double dT  = (t - getTc());
    double Xt  = Tspace(t);
    r.setMArg(1.0, f0*dT);
    r *= Xt;
    return r;
}
