#include <time.h>
#include "xml/XsilTSeries.hh"		// Associated header file
//=============  gds header files
#include "DVector.hh"		// DVector data container (shouldn't be nec.)
//=============  GNU C++ header Files
#include <cstring>
#include <cstdlib>
#include <iostream>

   using namespace std;
namespace xml {


/*-----------------------------------------------------------------------*/
/*   TSeries write function                                              */
/*-----------------------------------------------------------------------*/
   std::ostream& 
   xsilTSeries::write (std::ostream &os) const {
    //==========  Too many calls require the number of points. Get it once here
      int Npts = fData->getNSample();
    //==========  Start the Data object (& write the "channel" name)
      if (!fData->getName()) {
         os << xsilDataBegin("DMT TSeries","TimeSeries",fLevel)<<endl;
         os << xsilParameter<string>("Channel","channel","DMT TSeries",1,
                              fLevel+1)<<endl;
      } 
      else {
         os << xsilDataBegin("DMT TSeries", "TimeSeries",fLevel)<<endl;
         os << xsilParameter<string>("Channel","channel",fData->getName(), 1,
                              fLevel+1)<<endl;
      }
    //==========  Parameters common to both ligolw & TSeries
      os << xsilTime("t0",fData->getStartTime().getS(),
                    fData->getStartTime().getN(), fLevel+1)<<endl;
      os << xsilParameter<double>("dt","s",double(fData->getTStep()), 1,
                           fLevel+1)<<endl;
      os << xsilParameter<float>("f0","Hz",fData->getF0(), 1, 
                           fLevel+1)<<endl;
      os << xsilParameter<int>("N",Npts, 1, fLevel+1)<<endl;
    //==========  Parameters found only in TSeries
      os << xsilTime("EndTime",fData->getEndTime().getS(),
                    fData->getEndTime().getN(), fLevel+1)<<endl;
      os << xsilParameter<double>("Interval","s",double(fData->getInterval()),1,
                           fLevel+1)<<endl;
      os << xsilParameter<double>("AverageValue",fData->getAverage(), 1,
                           fLevel+1)<<endl;
      os << xsilParameter<double>("Maximum",fData->getMaximum(),1, 
                           fLevel+1)<<endl;
      os << xsilParameter<double>("Minimum",fData->getMinimum(), 1,
                           fLevel+1)<<endl;
      os << xsilParameter<int>("Status",fData->getStatus(), 1,
                           fLevel+1)<<endl;
    //====================  Write Subtype,data array-- complex data
      if (fData->refDVect()->getType() == DVector::t_complex ||
         fData->refDVect()->getType() == DVector::t_dcomplex) {
         os << xsilParameter<int>("Subtype",int(1), 1, fLevel+1)<<endl;
      //:KLUDGE: DMT uses different complex #'s from xsil, so we convert via pointers
      //:KLUDGE: In the future, DMT might switch to C++ complex #'s.
         fComplex *temp = new fComplex[Npts];
         fData->getData(Npts,temp);
         std::complex<float> *data = new std::complex<float>[Npts];
         for (int i=0; i<Npts; ++i) {
	     data[i] = std::complex<float>(temp[i].Real(), temp[i].Imag());
	 }
         delete[] temp;
         os << xsilDataEnd<std::complex<float> >(Npts,data, fLevel)<<endl;
         delete[] data;
      //===================  Write Subtype, data array-- float data
      } 
      else {
         os << xsilParameter<int>("Subtype",int(0), 1, fLevel+1)<<endl;
         float *data = new float[Npts];
         fData->getData(Npts,data);
         os << xsilDataEnd<float>(Npts, data, fLevel);
         delete[] data;
      }
      return os;
   }

/*************************************************************************
 ** Xsil handler methods                                                **
 *************************************************************************/

//////////////////////////////////////////////////////////////////////////
//                                                                      //
// xsilHandlerUnknown                                                   //
//                                                                      //
// Handles unknown records                                              //
//                                                                      //
//////////////////////////////////////////////////////////////////////////
   class xsilHandlerLdasTimeData : public xsilHandler {
   protected:
      xsilHandlerTSeries&	fParent;
   
   public:
      /// Constructor
      xsilHandlerLdasTimeData (xsilHandlerTSeries& parent)
      : fParent (parent){
      }
      /// data callback (calls parent)
      virtual bool DataHandler (const std::string& name,
                        int type, void* x, int size, 
                        int dim1, int dim2 = 0, int dim3 = 0,
                        int dim4 = 0) {
         return fParent.DataHandler (name, type, x, size, 
                              dim1, dim2, dim3, dim4); }
   };



/*-----------------------------------------------------------------------*/
/*   xsilHandlerTSeries                                                  */
/*                                                                       */
/*   Handles TSeries records                                             */
/*-----------------------------------------------------------------------*/
   xsilHandlerTSeries::
   xsilHandlerTSeries(vector<TSeries> *vts,const attrlist *attr, 
                     bool ignore, bool ldas)
   : xsilHandler(ignore), fLdasIHaveToBeDifferent (ldas), fObjects(vts),
   fName(""),fSubtype(-1),fSec(0),fNsec(0),fDt(0),fF0(0),fStatus(0),
   fComplex(false),fData(0),fDim1(0),fDim2(0) 
   {
      // LDAS: get channel name and time from container name
      if (fLdasIHaveToBeDifferent) {
         string n = fName;
         for (int i = 0; i < 5; ++i) {
            bool esc = false;
            int pos;
            for (pos = 0; (pos < (int)n.length()) &&
                ((n[pos] != ':') || esc); ++pos) {
               esc = (n[pos] == '\\');
            }
            switch (i) {
               // channel name
               case 0:
                  {
                     fName = n.substr (0, pos);
                     string::size_type p;
                     while ((p = fName.find ("\\:")) != string::npos) {
                        fName.erase (p, 1);
                     }
                     break;
                  }
               // GPS sec
               case 3:
                  {
                     fSec =  atol (n.substr (0, pos).c_str());
                     break;
                  }
               // GPS sec
               case 4:
                  {
                     fNsec =  atol (n.substr (0, pos).c_str());
                     break;
                  }
               // garbage
               default:
                  {
                     break;
                  }
            }
            n.erase (0, pos);
            if (!n.empty()) n.erase (0, 1);
         }
      }
   }

//__________________________________________________________________________
   xsilHandlerTSeries::~xsilHandlerTSeries() {
      if (fDim1 && fSec && (fDim2 <= 0)) {
         if (!fComplex) {
            Time tm(fSec,fNsec);
            TSeries ts(tm, Interval(fDt), (TSeries::size_type) fDim1, fData);
            ts.setName(fName.c_str());
            ts.setF0(fF0);
            ts.setStatus( (TSeries::stat_type) fStatus);
            fObjects->push_back(ts);
            delete [] fData;
            fData = 0;
         } 
         else {
            cerr <<"Data is complex.  Can't parse this..."<<endl;
            cerr <<"Stats: Time="<<fSec<<","<<fNsec<<"\t Name="<<fName
               <<"\t Dim1="<<fDim1<<"\t Dim2="<<fDim2<<endl;
         }
      } 
      else {
         cerr <<"Something's wrong with TSeries data-- can't send up..."<<endl;
      }
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const int& p, int N) {
      if (strcasecmp (name.c_str(), "Subtype") == 0) {
         fSubtype = p;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "Status") == 0) {
         fStatus = p;
         return true;
      } 
      else 
         return false;
   }

//__________________________________________________________________________
#ifndef __CINT__
   bool xsilHandlerTSeries::HandleParameter(const std::string& name, 
                     const attrlist& attr,
                     const long long& p, int N) {
      if (strcasecmp (name.c_str(), "N") == 0) 
         return true;
      else 
         return false;
   }
#endif //__CINT__

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const float& p, int N) {
      if (strcasecmp (name.c_str(), "F0") == 0) {
         fF0 = p;
         return true;
      } 
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const double& p, int N) {
      if ((strcasecmp (name.c_str(), "dt") == 0) && 
         !fLdasIHaveToBeDifferent) {
         fDt = p;
         return true;
      } 
      //==== LDAS ====
      else if ((strncasecmp (name.c_str(), "sampleRate", 10) == 0) &&
              fLdasIHaveToBeDifferent) {
         if (p > 0) fDt = 1. / p;
	 return true;
      }
      else if ((strncasecmp (name.c_str(), "timeOffset", 10) == 0) &&
              fLdasIHaveToBeDifferent) {
         Time t0 (fSec, fNsec);
         t0 += Interval (p);
         fSec = t0.getS();
         fNsec = t0.getN();
	 return true;
      }
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleParameter(const std::string& name, 
                     const attrlist& attr, 
                     const std::string& p) {
      if (strcasecmp (name.c_str(), "Channel") == 0) {
         fName = p;
         return true;
      } 
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleTime 
   (const std::string& name, const attrlist& attr, 
   unsigned long sec, unsigned long nsec) {
      if (strcasecmp (name.c_str(), "t0") == 0) {
         fSec = sec;
         fNsec = nsec;
         return true;
      } 
      else if (strcasecmp (name.c_str(), "EndTime") == 0) 
         return true;
      else 
         return false;
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleData (const std::string& name,float* x, 
                     int dim1, int dim2, int dim3,
                     int dim4) {
      if (fData) delete [] fData;
      fDim1 = dim1;
      fDim2 = dim2;
      fData = x;
      fComplex = false;
      return true; 
   }

//__________________________________________________________________________
   bool xsilHandlerTSeries::HandleData (const std::string& name,
                     std::complex<float>* x, int dim1, 
                     int dim2, int dim3, int dim4) {
      if (fData) delete [] fData;
      fDim1 = dim1;
      fDim2 = dim2;
      fData = (float*)x;
      fComplex = true;
      return true; 
   }

//______________________________________________________________________________
   xsilHandler* xsilHandlerTSeries::GetHandler (const attrlist& attr) 
   {
      if (fLdasIHaveToBeDifferent) {
         return new xsilHandlerLdasTimeData (*this);
      }
      else {
         return xsilHandler::GetHandler (attr); 
      }
   }


/*-----------------------------------------------------------------------*/
/*   xsilHandlerQueryTSeries                                             */
/*                                                                       */
/*   Handler query for option array                                      */
/*-----------------------------------------------------------------------*/
   xsilHandler* xsilHandlerQueryTSeries::GetHandler(const attrlist& attr) {
      attrlist::const_iterator ti = attr.find (xmlType);
      if ((ti != attr.end()) && 
         (strcasecmp (ti->second.c_str(), "TimeSeries") == 0)) {
         return new (nothrow) xsilHandlerTSeries(fObjects,&attr,false);
      } 
      else if ((ti != attr.end()) &&
              (strcasecmp (ti->second.c_str(), "LDASTimeSeries") == 0)) {
         return new (nothrow) xsilHandlerTSeries(fObjects,&attr,false,true);
      }
      else {
         return 0;
      }
   }


} // namespace xml
