/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    Stand alone application to create a shared memory partition.
//
//    Syntax:
//       smrepair <name> [-nbuf <nbuf>] [-lbuf <lbuf>]
//
//       <name>    name of the partition to be created
//       <nbuf>    number of buffers 
//       <lbuf>    length of each buffer in bytes.
//
#include <string>
#include <cstdlib>
#include <iostream>
#include "lsmp.hh"

using namespace std;

int 
main(int argc, const char* argv[]) {
    const char* name = getenv("LIGOSMPART");
    int bufmode = -1; //  negative is unset;
    int keep    = -1;

    //-------------------------------  Get the command line arguments
    bool argerr = false;
    for (int i=1; i<argc; i++) {
	string argi = argv[i];
        if ((i == argc-1) && (*argv[i] != '-') && (*argv[i] != '?')) {
	    name = argv[i];
	}
	else if (argi == "--bufmode") {
	    bufmode = strtol(argv[++i], 0, 0);
	}
	else if (argi == "--keep") {
	    keep = 1;
	}
	else if (argi == "--nokeep") {
	    keep = 0;
	}
	else {
	    cerr << argv[0] << ": Invalid argument " << argv[i] << endl;
	    argerr = true;
	}
    }
    if (!name) argerr = true;

    //-------------------------------  Print an error message if appropriate.
    if (argerr) {
        cerr << argv[0] << ": Make the shared memory consumer and buffer "
	     << "data structures consistent" << endl;
	cerr << "Syntax:" << endl;
	cerr << argv[0] << " [--[no]keep] [--bufmode <n>] <partition-name>" 
	     << endl;
	exit(1);
    }

    //-------------------------------  Do the dirty work. Make sure the 
    //                                 partition isn't deleted immediately 
    LSMP_ACCESS *part = new LSMP_ACCESS(name);

    if (!part) {
        cerr << "Failed to construct partition " << name << " accessor." 
	     << endl;
	return 1;
    } else if (!part->valid()) {
        cerr << "Unable to attach partition " << name 
	     << ": " << part-> Error() << "." << endl;
	return 2;
    }
    else {
	if (bufmode >= 0) part->bufmode(bufmode);
	if (keep >= 0)    part->keep(keep);
	part->Repair();
    }
    delete part;
    exit(0);
}
