/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "lsmp_con.hh"
#include "lvshmapi.h"

//====================================  Get a consumer
lvshm_handle
lvshm_init(const char* name, lvshm_mask mask) {
    LSMP_CON* cons = new LSMP_CON(name, 0, mask);
    return cons;
}

//====================================  Get  the next available buffer
const char* 
lvshm_getNextBuffer(lvshm_handle handle, int flags) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  int lcflags = 0;
  if ((flags & LVSHM_NOWAIT) != 0) lcflags |= NOWAIT;
  return cons->get_buffer(flags);
}

//====================================  Get  the next available buffer
const char* 
lvshm_getBufferByGPS(lvshm_handle handle, lvshm_dataID gps) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  return cons->find_dataID(gps);
}

//====================================  Get the data address
const char* 
lvshm_dataAddress(lvshm_handle handle) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  return cons->getBuffAddr();
}

//====================================  Get the data length 
int 
lvshm_dataLength(lvshm_handle handle) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  return cons->getLength();
}

//====================================  Get the data GPS
lvshm_dataID 
lvshm_bufferGPS(lvshm_handle handle) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  return cons->getEvtID();
}

//====================================  Get the GPS of the latest buffer
lvshm_dataID 
lvshm_latestGPS(lvshm_handle handle) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  return cons->latest_evtID();
}

//====================================  Get the data GPS
void 
lvshm_releaseDataBuffer(lvshm_handle handle) {
  LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
  cons->free_buffer();
}

//====================================  Deaccess/close the consumer.
void 
lvshm_deaccess(lvshm_handle handle) {
   LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
   delete cons;
}

//====================================  Flush all current buffers
void 
lvshm_flush(lvshm_handle handle) {
   LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
   cons->free_buffer();
   while (cons->get_buffer(NOWAIT)) {
     cons->free_buffer();
   }
}

//====================================  Set the wait time.
void 
lvshm_setWaitTime(lvshm_handle handle, double wait) {
   LSMP_CON* cons = reinterpret_cast<LSMP_CON*>(handle);
   cons->setTimeout(wait);
}
