/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef LMSG_UDPSOCKET_HH
#define LMSG_UDPSOCKET_HH
#include "lmsg/Socket.hh"

namespace lmsg {
  class SocketPool;

  /**  Class to manipulate UDP sockets.
    *  @memo Socket class.
    *  @author  John Zweizig
    *  @version 1.1; Modified April 21, 2000
    *  @ingroup IO_lmsg
    */
  class UDPSocket : public Socket {
  public:
    /**  Allocate a UDP socket and bind it to the specified address. If 
      *  no address pointer is specified, an unused port address will be 
      *  allocated.
      *  @memo Construct a socket.
      *  @param addr Pointer to the address to which the socket will be bound.
      */
    UDPSocket(const MsgAddr* addr=0);

    /**  Release the socket and delete all asociated storage.
      *  @memo Destructor
      */
    virtual ~UDPSocket(void);
  };
} // namespace lmsg

#endif // LMSG_UDPSOCKET_HH
