#include "lmsg/MsgAddr.hh"
//
//   The Solaris 8 header files seem to generate inconsistent code if
//   _POSIX_C_SOURCE is defined!
#if defined(sun) && defined(_POSIX_C_SOURCE)
#undef _POSIX_C_SOURCE
#endif
#include "sockutil.h"
#include <arpa/inet.h>
#include <stdio.h>
#include <string>
#include <iostream>

using namespace lmsg;
using namespace std;

MsgAddr 
MsgAddr::findIPHost(const std::string& HostID) {
    string Host;
    MsgAddr::ipport_t port=0;
    MsgAddr::ipport_t sbid=0;

    //----------------------------------  Get the port number if specified
    bool xPort(false), xSbID(false);
    for (const char* p=HostID.c_str(); *p; p++) {
        if (*p == ':') {
	    if (xPort || xSbID) break;
	    xPort = true;
	} else if (*p == '[') {
	    if (xSbID) break;
	    xSbID = true;
	} else if (*p == ']') {
	    break;
	} else if (xSbID) {
	    if (*p < '0' || *p > '9') break;
	    sbid *= 10;
	    sbid += *p - '0';
	} else if (xPort) {
	    if (*p < '0' || *p > '9') break;
	    port *= 10;
	    port += *p - '0';
	} else {
	    Host += *p;
	}
    }

    //----------------------------------  Get the IP address
    MsgAddr::ipaddr_t addr=0;
    if (!Host.empty()) {
        struct in_addr iaddr;
	int rc = nslookup(Host.c_str(), &iaddr);
        if (!rc) addr = ntohl(iaddr.s_addr);
    }
    return MsgAddr(addr, port, sbid);
}

string 
MsgAddr::getIPName(void) const {
    string retline;

    //----------------------------------  Get the IP address
    in_addr ipaddr;
    ipaddr.s_addr = htonl(getIPAddr());

    //----------------------------------  Get the IP name
    char hostname[256];
    int rc = nsilookup(&ipaddr, hostname);
    if (rc) inet_ntop(AF_INET, &ip_addr, hostname, sizeof(hostname));
    return string(hostname);
}

ostream& 
operator<<(ostream& out, const MsgAddr& addr) {
    return out << addr.getIPName() << ":" << addr.getIPPort() 
	       << "[" << addr.getSubProcess() << "]";
}
