#ifndef MSGTYPES_HH
#define MSGTYPES_HH
#include <string>

namespace lmsg {
  typedef unsigned long error_type;
  typedef          long index_type;
  typedef unsigned long mask_type;
  typedef unsigned long size_type;
  typedef double        wtime_type;

  typedef unsigned int  gps_export_type;

  //------------------------------------  Deprecated
  typedef error_type error_t;

  /**  Get the descriptive test corresponding to the lmsg error code.
    *  \brief Get descriptive error string.
    *  \param err Error code.
    *  \returns Descriptive text string.
    */
  std::string lmsg_error_string(error_type err);

  /**  print the error message plus the error code string to stderr.
    *  \brief Get descriptive error string.
    *  \param msg Contextual message printed before the error text.
    *  \param err Error code.
    */
  void put_lmsg_error(const std::string& msg, error_type err);
}

#endif  //  MSGTYPES_HH
