/* -*- mode: c++; c-basic-offset: 3; -*- */

#ifndef JSON_STACK_HH
#define JSON_STACK_HH

#include <json/value.h>
#include <stdexcept>
#include <string>
#include <vector>

class jsonStack {
public:
  jsonStack(void);
  jsonStack(const std::string& file);
  size_t depth(void) const;
  bool empty(void) const;
  size_t fetch_data(const std::string name, bool& value) const;
  size_t fetch_data(const std::string name, double& value) const;
  size_t fetch_data(const std::string name, std::string& value) const;
  size_t fetch_data(const std::string name, std::vector<bool>& value);
  size_t fetch_data(const std::string name, std::vector<double>& value);
  size_t fetch_data(const std::string name, std::vector<std::string>& value);
  bool iterate(void);
  bool isArray(void) const;
  bool isStruct(void) const;
  size_t length(void) const;
  bool parse(const std::string& file);
  bool push_element(void);
  bool push_element(const std::string& name);
  bool push_element(const Json::Value& val);
  bool pop(void);
  const Json::Value& value(void) const;
private:
  Json::Value& value(void);
private:
  enum eltype {
    k_element,
    k_array,
    k_structure
  };

  struct stack_element {
    stack_element(void);
    stack_element(const Json::Value& se);
    Json::Value _value;
    eltype      _type;
    Json::ArrayIndex _size;
    Json::ArrayIndex _iter;
  };
  std::vector<stack_element> _stack;
  size_t _stack_size;
};

//======================================  Inline functions
inline size_t
jsonStack::depth(void) const {
  return _stack.size();
}

inline bool
jsonStack::empty(void) const {
  return _stack.empty();
}

inline const Json::Value&
jsonStack::value(void) const {
  if (empty()) throw std::runtime_error("Operation on empty json stack");
  return _stack.back()._value;
}

inline Json::Value& 
jsonStack::value(void) {
  if (empty()) throw std::runtime_error("Operation on empty json stack");
  return _stack.back()._value;
}

#endif     // !defined(JSON_STACK_HH)
