#include "html/size.hh"
#include "html/writer.hh"

//======================================  Specify a size
html::size::size(int Size)
  : mType(kDelta), mSize(Size)
{
  if (!mSize) mType = kDefault;
}

//======================================  Size destructor
html::size::~size(void) {}

//======================================  Clone a size specifier
html::size*
html::size::clone(void) const {
    return new size(*this);
}

//======================================  Internal numeric conversion.
static void 
puti(std::string& x, int n, int w=0, int r=10, char p=' ') {
    int d=n/r;
    if (d) puti(x,d,w-1,r,p);
    else   for (int i=1 ; i<w ; i++) x += p;
    x += "0123456789ABCDEF"[n%r];
}


//======================================  Test for default size.
bool 
html::size::isDefault(void) const {
    return mType == kDefault;
}

//======================================  Print attribute list
void 
html::size::putAttr(writer& w) const {
    std::string txt;
    switch (mType) {
    case kDefault:
        break;
    case kDelta:
        if (mSize > 0) {
	    txt = "+";
	    puti(txt, mSize);
	} else {
	    txt = "+";
	    puti(txt, mSize);
	}
	w.text(txt);
        break;
    case kPoints:
        puti(txt, mSize);
	txt += "pt";
	w.text(txt);
    }
}

//======================================  Set size to default.
void 
html::size::setDefault(void) {
    mType = kDefault;
    mSize = 0;
}

//======================================  Set relative size
void 
html::size::setRelative(int Size) {
    mType = kDelta;
    mSize = Size;
}


//======================================  Set size in points
void 
html::size::setSize(int Size) {
    mType = kPoints;
    mSize = Size;
}
