/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef HTML_GENATTR_HH
#define HTML_GENATTR_HH

#include "html/Attrib.hh"
#include <string>

namespace html {
  class writer;

  /**  The Generic attribute class allows specification of attributes that 
    *  may have a string value.
    *  @memo Generic attribute class
    *  @author John Zweizig
    *  @version 1.1; Last modified August 23, 2005
    *  @ingroup IO_html
    */
  class genAttr : public attrib {
  public:
    /** Value constructor.
      */
    genAttr(const std::string& value);

    /** Destructor.
      */
    virtual ~genAttr(void);

    /**  Clone a generic attribute object.
      *  @memo Clone a genAttr.
      */
    virtual genAttr* clone(void) const;

    /**  Test whether the default value is specified. The default value of 
      *  the generic attribute is assumed to be the null string.
      *  @memo Test for default value.
      *  @return true if the return value is the default.
      */
    virtual bool isDefault(void) const;

    /**  Test whether this attribute has a value specified. This method is 
      *  supplies the virtual metod of the attrib API and is always true.
      *  @memo Test for attribute with a value.
      *  @return true for genAttr
      */
    virtual bool hasArg(void) const;

    /**  Write the attribute value.
      */
    virtual void putAttr(writer& w) const;

    /**  Set the attribute value.
      */
    virtual void setValue(const std::string& value);

    /**  Compare the attribute with another generic attribute.
      */
    bool operator==(const genAttr& x) const;

  private:
    std::string mValue;
  };

}

#endif //  HTML_GENATTR_HH
