/* -*- mode: c++; c-basic-offset: 4; -*- */
#include "html/boolAttr.hh"

//======================================  Constructor
html::boolAttr::boolAttr(bool value)
  : mValue(value)
{}

//======================================  Destructor
html::boolAttr::~boolAttr(void) {}

//======================================  Clone this attribute
html::boolAttr* 
html::boolAttr::clone(void) const {
    return new boolAttr(*this);
}

//======================================  Test for default
bool 
html::boolAttr::isDefault(void) const {
    return !mValue;
}

//======================================  Keyword only attribute
bool 
html::boolAttr::hasArg(void) const {
    return false;
}

//======================================  No data
void 
html::boolAttr::putAttr(writer& w) const {
}

//======================================  Set boolean value
void 
html::boolAttr::setValue(bool value) {
    mValue = value;
}

//======================================  Assignment operator
bool 
html::boolAttr::operator==(const boolAttr& x) const {
    return mValue == x.mValue;
}
