#include "html/Attrib.hh"
#include "html/writer.hh"

//======================================  Construct a null attribute
html::attrib::attrib(void)
{}

//======================================  Copy an attribute
html::attrib::attrib(const attrib& x) 
{}

//======================================  Destroy an attribute
html::attrib::~attrib(void) 
{}

//======================================  set up for writing
void
html::attrib::setWrite(writer& w) const {
}

//======================================  Test for default attribute
bool 
html::attrib::hasArg(void) const {
    return true;
}

//======================================
bool 
html::attrib::isDefault(void) const {
    return false;
}

//======================================  Describe the attribute
void 
html::attrib::putAttr(writer& w) const {
}

//======================================  Construct an empty attribute list
html::attList::attList(void) {
}

//======================================  Copy an attribute list
html::attList::attList(const attList& x) 
  : mList(x.mList)
{
    for (attr_iter i=mList.begin() ; i != mList.end() ; i++) {
        i->second = (i->second)->clone();
    }
}

//======================================  Attribute list destructor
html::attList::~attList(void) {
    clear();
}

//======================================  Add a specified attribute.
html::attrib& 
html::attList::addAttr(const std::string& name, const attrib& a) {
    mList[name] = a.clone();
    return *mList[name];
}

//======================================  Add a specified attribute.
html::attrib& 
html::attList::repAttr(const std::string& name, const attrib& a) {
    attr_iter p = mList.find(name);
    if (p == mList.end()) return addAttr(name, a);
    delete p->second;
    p->second = a.clone();
    return *(p->second);
}

//======================================  Clear the attribute list
void
html::attList::clear(void) {
    for (attr_iter i=mList.begin() ; i != mList.end() ; i++) delete i->second;
    mList.clear();
}

//======================================  Test if attribute exists
bool
html::attList::exists(const std::string& name) const {
    return mList.find(name) != mList.end();
}

//======================================  Test if attribute exists
const html::attrib&
html::attList::find(const std::string& name) const {
    return *(mList.find(name)->second);
}

//======================================  Remove an attribute
bool
html::attList::isDefault(void) const {
    for (const_attr_iter i=mList.begin() ; i != mList.end() ; i++) {
        if (!i->second->isDefault()) return false;
    }
    return true;
}

//======================================  Remove an attribute
void
html::attList::merge(const attList& x) {
    for (const_attr_iter i=x.mList.begin() ; i != x.mList.end() ; i++) {
        attr_iter j = mList.find(i->first);
	if (j == mList.end()) {
	    addAttr(i->first, *(i->second));
	} else if (j->second->isDefault()) {
	    mList.erase(j);
	    addAttr(i->first, *(i->second));
	}
    }
}

//======================================  Remove an attribute
void 
html::attList::remAttr(const std::string& name) {
    delete mList[name];
    mList.erase(name);
}

//======================================  Put tag string to html writer
void 
html::attList::putAttr(writer& w) const {
    for (const_attr_iter i=mList.begin() ; i != mList.end() ; i++) {
        if (!(i->second)->isDefault()) {
	    w.text(" ");
	    w.text(i->first);
	    if ((i->second)->hasArg()) {
	        w.text("=");
		(i->second)->putAttr(w);
	    }
	}
    }
}

//======================================  Set up writer for further processing
void 
html::attList::setWrite(writer& w) const {
}
