/* -*- mode: c++; c-basic-offset: 3; -*- */
#ifndef FRAMEXMIT_MATCHIF_HH
#define FRAMEXMIT_MATCHIF_HH
#include <vector>
#include <netinet/in.h>
#include <net/if.h>

namespace framexmit {

   struct interface_t {
      char		name[IFNAMSIZ];
      in_addr_t		addr;
   };
   typedef std::vector<interface_t> interfaceList;
   typedef interfaceList::iterator  iflist_iter;

  /**  Build a list of network addresses.
    *  \brief Build network interface list.
    *  \param sock  Socket number.
    *  \param iList Interface number.
    */
  bool getInterfaces (int sock, interfaceList& iList);

  /**  Find the host address on the interface that routes to the address 
    *  specified by \a net.
    *  \brief Find address for network. 
    *  \param sock   Socket number.
    *  \param net    Address on the network to be bound to.
    *  \param i_addr IP address.
    */
  bool matchInterface (int sock, const char* net, in_addr& i_addr);
}

#endif
