#ifndef _GDS_FRAMEXMIT_H
#define _GDS_FRAMEXMIT_H
/*----------------------------------------------------------------------*/
/*                                                         		*/
/* Module Name: framexmit						*/
/*                                                         		*/
/* Module Description: API for broadcasting frames			*/
/*		       implements a reliable UDP/IP broadcast for	*/
/*                     large data sets over high speed links		*/
/*                                                         		*/
/* Module Arguments: none				   		*/
/*                                                         		*/
/* Revision History:					   		*/
/* Rel   Date     Programmer  	Comments				*/
/* 1.0	 10Aug99  D. Sigg    	First release		   		*/
/*                                                         		*/
/* Documentation References:						*/
/*	Man Pages: doc/index.html (use doc++)				*/
/*	References: none						*/
/*                                                         		*/
/* Author Information:							*/
/* Name          Telephone       Fax             e-mail 		*/
/* Daniel Sigg   (509) 372-8132  (509) 372-8137  sigg_d@ligo.mit.edu	*/
/*                                                         		*/
/* Code Compilation and Runtime Specifications:				*/
/*	Code Compiled on: Ultra-Enterprise, Solaris 5.7			*/
/*	Compiler Used: egcs-1.1.2					*/
/*	Runtime environment: sparc/solaris				*/
/*                                                         		*/
/* Code Standards Conformance:						*/
/*	Code Conforms to: LIGO standards.	OK			*/
/*			  Lint.			TBD			*/
/*			  ANSI			OK			*/
/*			  POSIX			OK			*/
/*									*/
/* Known Bugs, Limitations, Caveats:					*/
/*								 	*/
/*									*/
/*                                                         		*/
/*                      -------------------                             */
/*                                                         		*/
/*                             LIGO					*/
/*                                                         		*/
/*        THE LASER INTERFEROMETER GRAVITATIONAL WAVE OBSERVATORY.	*/
/*                                                         		*/
/*                     (C) The LIGO Project, 1996.			*/
/*                                                         		*/
/*                                                         		*/
/* California Institute of Technology			   		*/
/* LIGO Project MS 51-33				   		*/
/* Pasadena CA 91125					   		*/
/*                                                         		*/
/* Massachusetts Institute of Technology		   		*/
/* LIGO Project MS NW17-161				   		*/
/* Cambridge MA 01239					   		*/
/*                                                         		*/
/* LIGO Hanford Observatory				   		*/
/* P.O. Box 1970 S9-02					   		*/
/* Richland WA 99352					   		*/
/*                                                         		*/
/* LIGO Livingston Observatory		   				*/
/* 19100 LIGO Lane Rd.					   		*/
/* Livingston, LA 70754					   		*/
/*                                                         		*/
/*----------------------------------------------------------------------*/

// include files
#include "framexmit/framesend.hh"
#include "framexmit/framerecv.hh"

/** \defgroup IO_frxmit Frame broadcast API
  * \section frxmit_intro Introduction
  * This API implements a reliable UDP/IP broadcast transfer. This API
  * is intended to broadcast frame data from a frame builder machine
  * to the on-line Data Monitoring Tools over gigabit ethernet.
  * The main features are:
  * <ul>
  *   <li>UDP/IP broadcast protocol using propritary packets</li>
  *   <li>optmized for high speed links and bulk data transfer </li>
  *   <li>reliable; uses UDP/IP retransmission packets</li>
  *   <li>quality of service implemented in the receiver</li>
  *   <li>simple buffer management</li>
  *   <li>one transmitter / any number of receivers</li>
  *   <li>all handshaking hidden from the user; join at any time</li>
  *   <li>no complicated start-up procedures</li>
  * </ul>
  *
  * \section frxmit_api Send and receive APIs
  * <ul>
  *   <li> Framexmit defaults: frameSend
  *   <li> Send frame data: frameSend
  *   <li> Receive frame data: frameRecv
  * </ul>
  *
  * \section frxmit_examples Examples
  * Example of a transmitter:
  * <a href="sndtest.cc.pdf">sndtest.cc</a>
  *
  * Example of a receiver:
  * <a href="rcvtest.cc.pdf">rcvtest.cc</a>
  *
  * \section frxmit_download Download
  *
  * Get version 2.0 from <a href="../Download/framexmit-2_0.tar.gz">here</a>
  *
  * Get version 3.0 from <a href="../Download/framexmit-3_0.tar.gz">here</a>
  *
  * Get version 3.1 from <a href="../Download/framexmit-3_1.tar.gz">here</a>
  *
  * \brief Frame broadcast API
  * \author Written August 1999, by Daniel Sigg
  * \version 3.2
  ************************************************************************/

#endif // _GDS_FRAMEXMIT_H
