#include "swapframe.hh"
#include <time.h>
#include <stdexcept>
#include <cstring>
#include <string>

using namespace std;

//======================================  Default SwapFrame constructor
SwapFrame::SwapFrame(void) {
    int test=1;
    mBigEnd = *(char*)&test == 0;
}

//======================================  SwapFrame destructor
SwapFrame::~SwapFrame(void) {}

//======================================  Swap bytes in a Frame
void
SwapFrame::Swap(char* frame, int len) {
    mPtr  = frame;
    mLeft = len;
    for (int i=0 ; i< MAXID ; i++) mTable[i] = 0;

    if (procFileHdr()) return;

    while (mLeft > 0) {
        short ID = SwapHdr();
	if (ID <= 0 || ID >= MAXID) {
	    throw runtime_error("Bad structure type"); 
	} else if (ID == 1) {
	    procSH();
	} else if (ID == 2) {
	    procSE();
	} else if (ID == mVectID) {
	    mLastID =-1;
	    procVect();
	} else {
	    mLastID =-1;
	    const int* dPtr = mTable[ID];
	    if (!dPtr) throw runtime_error("Structure not defined");
	    int nEnt = *dPtr++;
	    for (int i=0 ; i<nEnt ; i++) {
	        switch (*dPtr++) {
		case kChar:
		    Bump(*dPtr++);
		    break;
		case kString:
		    SwapString(*dPtr++);
		    break;
		case kShort:
		    SwapShort(*dPtr++);
		    break;
		case kPtr:
		    SwapShort(2*(*dPtr++));
		    break;
		case kInt:
		    SwapInt(*dPtr++);
		    break;
		case kDouble:
		    SwapDouble(*dPtr++);
		    break;
		}
	    }
	}
    }
}

//======================================  Swap a file header
bool 
SwapFrame::procFileHdr() {
    if (strcmp(mPtr, "IGWD")) throw runtime_error("Not an IGWD frame");
    Bump(12);
    if (*(short*)mPtr == 0x1234) return true;
    SwapShort();
    SwapInt();
    SwapDouble();
    SwapInt();
    SwapDouble();
    Bump(2);
    return false;
}

//======================================  Swap the SH block
void 
SwapFrame::procSH(void) {
    const char* name = mPtr + 2;
    SwapString();
    short classID;
    SwapShort();
    memcpy((char*)&classID, mPtr-2, 2);
    mLastID = classID;
    if (!strcmp(name, "FrVect")) mVectID = mLastID;
    SwapString();
    if (mLastID > MAXID) throw runtime_error("ID is too large");
    if (!mTable[mLastID]) mTable[mLastID] = new int[MAXTABLE];
    *mTable[mLastID] = 0;
}

//======================================  Swap the SE block
void 
SwapFrame::procSE(void) {
    if (mLastID <= 0) throw runtime_error("SE not after SH");
    SwapString();
    string type = mPtr + 2;
    SwapString(2);
    if (mLastID == mVectID) return;

    //----------------------------------  Get the data type
    wType tCode(kNone);
    if (type == "INT_2U" || type == "INT_2S") {
        tCode = kShort;
    } else if (type == "STRING") {
        tCode = kString;
    } else if (type == "INT_4U" || type == "INT_4S") {
        tCode = kInt;
    } else if (type == "INT_8U" || type == "INT_8S") {
        tCode = kDouble;
    } else if (type == "REAL_4") {
        tCode = kInt;
    } else if (type == "REAL_8") {
        tCode = kDouble;
    } else if (type.substr(0,10) == "PTR_STRUCT") {
        tCode = kPtr;
    } else {
        throw runtime_error("Unrecognized type");
    }

    int* tbl = mTable[mLastID];
    int l = *tbl;
    if (!l || (tbl[l+l-1] != tCode)) {
        tbl[0]++;
        tbl[l+l+1] = tCode;
        tbl[l+l+2] = 1; 
    } else  {
        tbl[l+l]++;
    }
}

//======================================  Swap an FrVect
void 
SwapFrame::procVect(void) {
    SwapString();  // name
    SwapShort(2);  // compress & type
    SwapInt(2);    // nData & nBytes
    int nBytes;
    memcpy(&nBytes, mPtr-4, 4);
    Bump(nBytes);
    SwapInt();     // nDim
    int nDim;
    memcpy(&nDim, mPtr-4, 4);
    SwapInt(nDim); // nx
    SwapDouble(nDim+nDim);  // dx & startx
    SwapString(nDim+1); //UnitX and UnitY
    SwapShort(2); // next
}

//======================================  Swap a double
void 
SwapFrame::SwapShort(int N) {
    while (N--) {
        char t  = *mPtr;
	mPtr[0] = mPtr[1];
	mPtr[1] = t;
	Bump(2);
    }
}

//======================================  Swap an int
void 
SwapFrame::SwapDouble(int N) {
    while (N--) {
        char t  = *mPtr;
	mPtr[0] = mPtr[7];
	mPtr[7] = t;
        t       = mPtr[1];
	mPtr[1] = mPtr[6];
	mPtr[6] = t;
        t       = mPtr[2];
	mPtr[2] = mPtr[5];
	mPtr[5] = t;
        t       = mPtr[3];
	mPtr[3] = mPtr[4];
	mPtr[4] = t;
	Bump(8);
    }
}

//======================================  Swap a shot int
void 
SwapFrame::SwapInt(int N) {
    while (N--) {
        char t  = *mPtr;
	mPtr[0] = mPtr[3];
	mPtr[3] = t;
        t       = mPtr[1];
	mPtr[1] = mPtr[2];
	mPtr[2] = t;
	Bump(4);
    }
}

//======================================  Swap a string
void 
SwapFrame::SwapString(int N) {
    short l(0);
    while (N--) {
        SwapShort();
	memcpy((char*)&l, mPtr-2, 2);
	Bump(l);
    }
}

//======================================  Swap a structure header
short
SwapFrame::SwapHdr(void) {
    SwapInt(1);
    SwapShort(2);
    short id;
    memcpy((char*)&id, mPtr-4, 2);
    return id;
}
