/* -*- mode: c++; c-basic-offset: 4; -*- */
#ifndef CHECKFRAME_HH
#define CHECKFRAME_HH

#include "FrameF.hh"

#define MaxID 32

/**  Check a frame file for consistency with the structure defined for 
  *  IGWD frame files. Fatal errors are flagged with BadFile exceptions.
  *  Other ugliness is printed using the ErrorOut method.
  *  @memo Check a frame file.
  *  @author John Zweizig
  *  @version 1.0; Modified April 17,2000
  *  @ingroup IO_futils
  */
class CheckFrame {
  public:
    /**  Construc a Frame checker.
      *  @memo Checker constructor.
      */
    CheckFrame(std::istream& in);

    /**  Destructor
      */
    virtual ~CheckFrame(void);

    /**  Print an error message to the desired location. By default this
      *  method prints to cout, but the method may be substituted with
      *  other methods.
      *  @memo Write an error message
      *  @param error Error message string.
      */
    virtual void ErrorOut(const std::string& error);

    /**  Scan through a frame file, checking for consistency with the 
      *  IGWD frame specification.
      */
    void Check(void);

    /**  Specify that an ID is to be processed by procID.
      */
    void    setProcess(int ID);

    /**  Process an SH record.
      */
    void    procSH(void);

    /**  Process one of the selected structure types.
     */
    virtual void procID(void);

  private:
    FrameF  mFile;
    int     mDebug;
    bool    mProcID[MaxID];
    bool    mDefID[MaxID];
    int     mInstCt[MaxID];
    int     mEOFrID;
    int     mEOFID;
};

#endif   //  CHECKFRAME_HH


