#include "framedir.hh"
#include "Time.hh"
#include <stdlib.h>
#include <unistd.h>
#include <iostream>
#include <iomanip>
#include <fstream>
#include <vector>

   using namespace std;

   // frame series entry
   class fdir_entry {
   public:
      bool		gps;
      bool		valid;
      FrameDir::gps_t 	timebeg;
      int 		duration;
      FrameDir::gps_t 	timeend;
      int 		gap;
      fdir_entry (FrameDir::gps_t Timebeg, int Duration, int Gap, 
                 bool GPS = true, FrameDir::gps_t Timeend = 0) 
      : gps (GPS), valid (true), timebeg (Timebeg), duration (Duration), 
      timeend (Timeend), gap (Gap) {
         if (timeend == 0) timeend = timebeg + duration;
      }
      static void heading (ostream& os, bool gps = true) {
         if (gps) {
            os << setw (12) << "start" << setw(12) << "stop" << 
               setw(12) << "duration" << setw(8) << "gap" << endl;
         }
         else {
            os << setw (24) << "start" << setw(24) << "stop" << 
               setw(12) << "duration" << setw(8) << "gap" << endl;
         }
      }
      static void separator (ostream& os, bool gps = true) {
         int num = gps ? 44 : 68;
         for (int i = 0; i < num; ++i) os << "-";
         os << endl;
      }
      void write (ostream& os) {
         if (valid) {
            if (gps) {
               os << setw (12) << timebeg << setw(12) << timeend << 
                  setw(12) << duration << setw(8) << gap << endl;
            }
            else {
               char t0[1024];
               char t1[1024];
               TimeStr (Time (timebeg), t0, "%3M %02d %Y  %02H:%02N:%02S");
               TimeStr (Time (timeend), t1, "%3M %02d %Y  %02H:%02N:%02S");
               os << setw (24) << t0 << setw(24) << t1 << setw (12) << 
                  duration << setw(8) << gap << endl;
            }
         }
      }
   };

   // frame series list
   typedef vector<fdir_entry> fdir_list;


   int main (int argc, char** argv)
   {
      fdir_list		fdirs;
      int		threshold = 0;
      bool 		gps = false;
   
      // parse cmd line arguments
      int 		c;
      extern char*	optarg;
      extern int	optind;	
      int		errflag = 0;
      vector<string> filenames;
      while ((c = getopt (argc, argv, "gt:h")) != EOF) {
         switch (c) {
            case 't':
               {
                  threshold = atoi (optarg);
                  break;
               }
            case 'g':
               {
                  gps = true;
                  break;
               }
            case 'h':
               {
                  errflag = 1;
                  break;
               }
         }
      }
      if (errflag || (argc <= 1)) {
         cout << "usage: fdir [-t 'threshold'] [-g] 'frame directory(ies)'" << endl;
         cout << "            -t 'threshold' : Minimum length of intervals in sec" << endl;
         cout << "            -g : show GPS time" << endl;
         cout << "example: fdir -t 90 ""/data/*/*.F""" << endl;
         exit (0);
      }
      for (int i = optind; i < argc; i++) {
         filenames.push_back (argv[i]);
      }
   
      // add filenames to frame dir
      FrameDir fdir;
      for (vector<string>::iterator i = filenames.begin(); 
          i != filenames.end(); ++i) {
         fdir.add (i->c_str(), true);
      }
   
      // loop over frames and compute continueous data segments
      FrameDir::gps_t time = 0;
      FrameDir::gps_t timebeg = 0;
      FrameDir::gps_t verybeg = 0;
      int total = 0;
      int gaps = 0;
      for (FrameDir::series_iterator i = fdir.beginSeries(); 
          i != fdir.endSeries(); ++i) {
         if (time == 0) {
            time = i->first;
            timebeg = time;
            verybeg = time;
         }
         // check for gap
         if (time != i->first) {
            int Delta = time - timebeg;
            int gap = i->first - time;
            fdir_entry fe (timebeg, Delta, gap, gps);
            fdirs.push_back (fe);
            total += Delta;
            gaps += gap;
            time = i->first;
            timebeg = time;
         }
         time += i->second.getLength().GetS();
      }
   
      // don't forget last segment
      if (time != 0) {
         int Delta = time - timebeg;
         fdir_entry fe (timebeg, Delta, 0, gps);
         fdirs.push_back (fe);
         total += Delta;
      }
   
      // check threshold
      fdir_list::iterator prev = fdirs.end();
      for (fdir_list::iterator i = fdirs.begin();
          i != fdirs.end(); ++i) {
         if (i->duration < threshold) {
            if (prev != fdirs.end()) {
               gaps += i->duration;
               prev->gap += i->duration + i->gap;
            }
            total -= i->duration;
            i->valid = false;
         }
         else {
            prev = i;
         }
      }
   
      // write report
      fdir_entry::heading (cout, gps);
      fdir_entry::separator (cout, gps);
      for (fdir_list::iterator i = fdirs.begin();
          i != fdirs.end(); ++i) {
         i->write (cout);
      }
      fdir_entry::separator (cout, gps);
      total = time - verybeg;
      fdir_entry fe (verybeg, total, gaps, gps, time);
      fe.write (cout);
   
      return 0;
   }
