/* -*- mode: c++; c-basic-offset: 4; -*- */
//
//    Print a list of channels
//
#include <string.h>
#include <strings.h>
#include <iostream>
#include <iomanip>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#define NDS2_API_VERSION 1
#ifdef  NDS2_API_VERSION
#include "DAQC_api.hh"
#include "NDS1Socket.hh"
#include "NDS2Socket.hh"
using namespace sends;
#else
#include "DAQSocket.hh"
#endif

using namespace std;

int 
main(int argc, const char *argv[]) {
    vector<DAQDChannel> List;
    int grouplist[32], ngroup=0, port=DAQD_PORT;

    const char*   ndsname = getenv("LIGONDSIP");
    const char*   format  = 0;
    if (!ndsname) ndsname = "131.215.115.67";
    bool debug = false, testdup = false;
    bool nds2 = true;
    int gps = 0;

    //---------------------------------  Get the arguments.
    for (int i=1 ; i<argc ; i++) {
        if (!strcmp(argv[i], "nds")) {
	    ndsname = argv[++i];
	} else if (!strcmp(argv[i], "gps")) {
	    gps = strtol(argv[++i], 0, 0);
	} else if (!strcmp(argv[i], "port")) {
	    port = strtol(argv[++i], 0, 0);
	} else if (!strcmp(argv[i], "-d")) {
	    testdup = true;
	} else if (!strcmp(argv[i], "-1")) {
	    nds2 = false;
	} else if (!strcmp(argv[i], "-2")) {
	    nds2 = true;
	} else if (!strcmp(argv[i], "-g")) {
	    grouplist[ngroup++] = strtol(argv[++i],0,0);
	} else if (!strcmp(argv[i], "-f")) {
	    format = argv[++i];
	} else if (!strcmp(argv[i], "debug")) {
	    debug = true;
	} else {
	    cerr << "Invalid argument: " << argv[i] << endl;
	    cerr << "Syntax: " << endl;
	    cerr << "prchans [-d] [-1] [-2] [nds <nds-ip-address>]"
		 << " [port <nds-port>]" << endl
		 <<"         [-f <format>] [-g <group>] [debug]" 
		 << endl;
	    return 1;
	}
    }

    //---------------------------------  Open a daqd socket
    cout << "Opening a socket to ND sever on node " << ndsname << endl;
#ifdef NDS2_API_VERSION
    DAQC_api* nds;
    if (!nds2) nds = new NDS1Socket;
    else       nds = new NDS2Socket;
#else
	DAQSocket* nds= new DAQSocket;
#endif
    nds->setDebug(debug);
    nds->open(ndsname, port);
    if (!nds->isOpen()) {
        cerr << "Unable to open socket to NDS on node " << ndsname << endl;
	return 0;
    }

    cout << "Getting available channels" << endl;
#ifdef NDS2_API_VERSION
    int rc = nds->Available(cUnknown, gps, List);
#else
    int rc = nds->Available(List);
#endif
    if (rc <= 0) {
	cerr << "Error requesting available channels: " << rc << endl;
	exit(1);
    }
    int nc = List.size();
    cout << "Number of channels returned = " << nc << endl;

    //----------------------------------  Look for duplicates
    if (testdup) {
        for (int i=0 ; i < nc ; i++) {
	    for (int j=i+1 ; j < nc ; j++) {
#ifdef NDS2_API_VERSION
	        if (!strcasecmp(List[i].mName.c_str(), List[j].mName.c_str())){
		    cout << "Error duplicate name: " << List[i].mName << endl;
		}
#else
	        if (!strcasecmp(List[i].mName, List[j].mName)) {
		    cout << "Error duplicate name: " << List[i].mName << endl;
		}
#endif
	    }
	}
    }

    //----------------------------------  Print the requested channel names
    if (!format) {
#ifdef NDS2_API_VERSION
        cout << "Channel                                 "
	     << "Type     Rate  dType" << endl;
#else
        cout << "Channel                                 "
	     << "Group Num     Rate  NByte  dType" << endl;
#endif
    }
    for (int i=0 ; i < nc ; i++) {
#ifdef NDS2_API_VERSION
        bool select = true;
#else
        bool select = false;
	if (!ngroup) select = true;
	else {
	    for (int j=0 ; j<ngroup ; j++) {
	        if (List[i].mGroup == grouplist[j]) select = true;
	    }
	}
#endif
	if (select) {
	    char line[1024];
	    DAQDChannel* Li = &List[i];
#ifdef NDS2_API_VERSION
	    if (format) sprintf(line, format, List[i].mName.c_str());
	    else        sprintf(line, "%-40s %-8s %8.2f %-6s", 
				Li->mName.c_str(),  
				DAQDChannel::cvt_chantype_str(Li->mChanType), 
				Li->mRate, 
				DAQDChannel::cvt_datatype_str(Li->mDatatype));
#else
	    if (format) sprintf(line, format, List[i].mName);
	    else        sprintf(line, "%-40s %3i %5i %6i %6i %6i", 
				Li->mName,  Li->mGroup, 
				Li->mNum, Li->mRate, 
				Li->mBPS, Li->mDatatype);
#endif
	    cout << line << endl;
	}
    }
    return 0;
}

