#ifndef __CINT__
#include "TSeries.hh"
#include "DecimateBy2.hh"
#include "Sine.hh"
#endif

void 
testdecimate(void) {
    TestPak tst("testdecimate", cout);

    const char* testName[8] = {"DecimateBy2",   "DecimateBy4", 
			       "DecimateBy8",   "DecimateBy16", 
			       "DecimateBy32",  "DecimateBy64", 
			       "DecimateBy128", "DecimateBy256"};
    const char* testTitle[8] = {"Decimate By   2", "Decimate By   4", 
 			        "Decimate By   8", "Decimate By  16", 
				"Decimate By  32", "Decimate By  64", 
				"Decimate By 128", "Decimate By 256"};
    tst.startSection("TSeriesDecim", "Test TSeries decimate method");
    for (int dec=1 ; dec<=8 ; dec++) {
        tst.startTitle(testName[dec-1], testTitle[dec-1]);
        double decf= double(1<<dec);
        DecimateBy2 dfilter(dec, 1);
	for (int i=0 ; i<128 ; i++) {
	    TSeries ts(Time(16*i+1), Interval(1/1024.0), 16384, Sine(1.0));
	    TSeries ts1(dfilter(ts));

	    tst.testError(ts1.getStartTime(), ts.getStartTime(),
			  "Decimated start time differs from original");

	    tst.testError(ts1.getEndTime(), ts.getEndTime(),
			  "Decimated end time differs from original");
	    tst.testError(ts.getTStep()*decf, ts1.getTStep(), 0.0, 
			  "Wrong decimated time step");
	    double sumsq = (ts1 * ts1) * decf / 16384.0;
	    // cout << "Sum squared over npoints =" << sumsq << endl;
	    tst.testError(sumsq, 0.5, 0.005, 
			  "Average power of deimated series is wrong");
	    double phi=3.1415926535*42.0*(decf-1.0)/1024.0;
	    TSeries ts2(Time(16*i+1), Interval(decf/1024.0), int(16384/decf), 
			Sine(1.0, TMath::Sqrt(sumsq/0.50), phi));
	    ts2 -= ts1;
	    TPlot(&ts2);
	}
	tst.endTest();
    }
    tst.endSection();
}
