{
cout << "LIGO Root initialization starting." << endl;

//--------------------------------------  Set up the include directories.
gInterpreter->AddIncludePath("/home/jzweizig/dmt64/dev/share/gds/macros");
gInterpreter->AddIncludePath("/home/jzweizig/dmt64/dev/include");

//-------------------------------------  Load the shared libraries.
cout << "Loading libraries from /home/jzweizig/dmt64/dev/lib" << endl;
gSystem->Load("libRgdsbase");
gSystem->Load("libRgdsmath");
gSystem->Load("libRgdscntr");
// gSystem->Load("libRclient");
gSystem->Load("libRframeio");
gSystem->Load("libRdmtsigp");
gSystem->Load("libRxsil");
gSystem->Load("libRgdsevent");
//-------------------------------------  Load graphics if not batch 
if (!gROOT->IsBatch()) {
    gSystem->Load("libRligogui");
    gSystem->Load("libRdttview");
    gSystem->Load("libRgdsplot");
} else {
    cout << "Graphics libraries not loaded: Batch mode." << endl;
}

//--------------------------------------  Create a data access object.
gROOT->LoadMacro("openDacc.cc");
openDacc();

//--------------------------------------  Create a display canvas.
if (!gROOT->IsBatch()) {
    TCanvas gds("cGDS", "GDS Data Monitor Tool");
}

//--------------------------------------  Load some common functions.
gROOT->LoadMacro("uniqueName.cc");
gROOT->LoadMacro("TPlot.cc");
gROOT->LoadMacro("THist.cc");
gROOT->LoadMacro("Bode.cc");
gROOT->LoadMacro("Spectrum.cc");
gROOT->LoadMacro("DatEnv.hh");
gROOT->LoadMacro("pTrend.cc");

cout << "Root initialization complete" << endl;
}
