void 
ABPlot(const TSeries& a, const TSeries& b, const char* opts=0) {
    //----------------------------------  Formatting parameters
    float ymargin = 0.1;  // Fractional margin in y.

    //----------------------------------  Get the TSeries A data.
    int    nBinA = a.getNSample();
    double stepA = a.getTStep();
    float* DVecA = new float[nBinA];
    a.getData(nBinA, DVecA);
    double dtime = stepA * nBinA;
    TH1F hista("TS001a", a.getName(), nBinA, 0.0, dtime);
    float ymin = DVecA[0];
    float ymax = DVecA[0];
    for (int i=0; i<nBinA; ++i) {
        hista.SetBinContent(i+1, DVecA[i]);
	if (DVecA[i] < ymin) ymin = DVecA[i];
	if (DVecA[i] > ymax) ymax = DVecA[i];
    }
    delete[] DVecA;

    //----------------------------------  Get TSeries B data
    int    nBinB = b.getNSample();
    double stepB = b.getTStep();
    double sTime = double(b.getStartTime() - a.getStartTime());
    dtime = sTime + nBinB * stepB;
    float* DVecB = new float[nBinB];
    b.getData(nBinB, DVecB);
    TH1F histb("TS001b", b.getName(), nBinB, sTime, dtime);
    for (int i=0; i<nBinB; ++i) {
        histb.SetBinContent(i+1, DVecB[i]);
	if (DVecB[i] < ymin) ymin = DVecB[i];
	if (DVecB[i] > ymax) ymax = DVecB[i];
    }
    delete[] DVecB;

    //----------------------------------  Set the hist parameters.
    float yavg = 0.5 * (ymin + ymax);
    float ydif = yavg - ymin;
    ymin = yavg - (1.0 + ymargin)*ydif;
    ymax = yavg + (1.0 + ymargin)*ydif;
    if (ymin < 0.0 && yavg-ydif >= 0.0) ymin = 0.0;
    hista.SetMinimum(ymin);
    hista.SetMaximum(ymax);

    //----------------------------------  Set the plotting options
    gStyle->SetOptStat(0);
    if (gROOT->GetSelectedPad()) (gROOT->GetSelectedPad()->GetCanvas())->cd();
    else                         new TCanvas("cGDS", "GDS Canvas");
    if (gROOT->FindObject("padT")) delete gROOT->FindObject("padT");
    TPad* padT = new TPad("padT", "Time Series", 0.0, 0.0, 1.0, 1.0);
    padT->Draw();
    padT->cd();
    padT->SetBottomMargin(0.12);
    padT->SetLeftMargin(0.15);
    padT->SetTicks(1,1);
    hista.SetLineColor(kRed);
    hista.DrawCopy(opts);
    histb.DrawCopy("SAME");

    //---------------------------------- Label axes
    TText l1; 
    l1.SetTextAlign(22);
    l1.SetTextSize(0.05);
    l1.SetTextAngle(90.);
    l1.DrawTextNDC(0.03, 0.50, "ADC Signal (adc units)");

    l1.SetTextAngle(0.);
    l1.DrawTextNDC(0.50, 0.03, "Time (seconds)");

    padT->GetCanvas()->Update();
}
